/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class LineWrappingTabPage
extends ModifyDialogTabPage {
    private static final String PREF_CATEGORY_INDEX = "org.eclipse.jdt.uiformatter_page.line_wrapping_tab_page.last_category_index";
    protected static final String[] INDENT_NAMES = new String[]{FormatterMessages.getString("LineWrappingTabPage.indentation.default"), FormatterMessages.getString("LineWrappingTabPage.indentation.on_column"), FormatterMessages.getString("LineWrappingTabPage.indentation.by_one")};
    protected static final String[] WRAPPING_NAMES = new String[]{FormatterMessages.getString("LineWrappingTabPage.splitting.do_not_split"), FormatterMessages.getString("LineWrappingTabPage.splitting.wrap_when_necessary"), FormatterMessages.getString("LineWrappingTabPage.splitting.always_wrap_first_others_when_necessary"), FormatterMessages.getString("LineWrappingTabPage.splitting.wrap_always"), FormatterMessages.getString("LineWrappingTabPage.splitting.wrap_always_indent_all_but_first"), FormatterMessages.getString("LineWrappingTabPage.splitting.wrap_always_except_first_only_if_necessary")};
    private static final Category fCompactIfCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_compact_if", "class Example {int foo(int argument) {  if (argument==0) return 0;  if (argument==1) return 42; else return 43;}}", FormatterMessages.getString("LineWrappingTabPage.compact_if_else"));
    private static final Category fTypeDeclarationSuperclassCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_superclass_in_type_declaration", "class Example extends OtherClass {}", FormatterMessages.getString("LineWrappingTabPage.extends_clause"));
    private static final Category fTypeDeclarationSuperinterfacesCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_superinterfaces_in_type_declaration", "class Example implements I1, I2, I3 {}", FormatterMessages.getString("LineWrappingTabPage.implements_clause"));
    private static final Category fConstructorDeclarationsParametersCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_constructor_declaration", "class Example {Example(int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) { this();}Example() {}}", FormatterMessages.getString("LineWrappingTabPage.parameters"));
    private static final Category fMethodDeclarationsParametersCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_method_declaration", "class Example {void foo(int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {}}", FormatterMessages.getString("LineWrappingTabPage.parameters"));
    private static final Category fMessageSendArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_method_invocation", "class Example {void foo() {Other.bar( 100, 200, 300, 400, 500, 600, 700, 800, 900 );}}", FormatterMessages.getString("LineWrappingTabPage.arguments"));
    private static final Category fMessageSendSelectorCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_selector_in_method_invocation", "class Example {int foo(Some a) {return a.getFirst();}}", FormatterMessages.getString("LineWrappingTabPage.qualified_invocations"));
    private static final Category fMethodThrowsClauseCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_throws_clause_in_method_declaration", "class Example {int foo() throws FirstException, SecondException, ThirdException {  return Other.doSomething();}}", FormatterMessages.getString("LineWrappingTabPage.throws_clause"));
    private static final Category fConstructorThrowsClauseCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_throws_clause_in_constructor_declaration", "class Example {Example() throws FirstException, SecondException, ThirdException {  return Other.doSomething();}}", FormatterMessages.getString("LineWrappingTabPage.throws_clause"));
    private static final Category fAllocationExpressionArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_allocation_expression", "class Example {SomeClass foo() {return new SomeClass(100, 200, 300, 400, 500, 600, 700, 800, 900 );}}", FormatterMessages.getString("LineWrappingTabPage.object_allocation"));
    private static final Category fQualifiedAllocationExpressionCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_qualified_allocation_expression", "class Example {SomeClass foo() {return SomeOtherClass.new SomeClass(100, 200, 300, 400, 500 );}}", FormatterMessages.getString("LineWrappingTabPage.qualified_object_allocation"));
    private static final Category fArrayInitializerExpressionsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_expressions_in_array_initializer", "class Example {int [] fArray= {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};}", FormatterMessages.getString("LineWrappingTabPage.array_init"));
    private static final Category fExplicitConstructorArgumentsCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_explicit_constructor_call", "class Example extends AnotherClass {Example() {super(100, 200, 300, 400, 500, 600, 700);}}", FormatterMessages.getString("LineWrappingTabPage.explicit_constructor_invocations"));
    private static final Category fConditionalExpressionCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_conditional_expression", "class Example extends AnotherClass {int Example(boolean Argument) {return argument ? 100000 : 200000;}}", FormatterMessages.getString("LineWrappingTabPage.conditionals"));
    private static final Category fBinaryExpressionCategory = new Category("org.eclipse.jdt.core.formatter.alignment_for_binary_expression", "class Example extends AnotherClass {int foo() {  int sum= 100 + 200 + 300 + 400 + 500 + 600 + 700 + 800;  int product= 1 * 2 * 3 * 4 * 5 * 6 * 7 * 8 * 9 * 10;  boolean val= true && false && true && false && true;  return product / sum;}}", FormatterMessages.getString("LineWrappingTabPage.binary_exprs"));
    private static int DEFAULT_PREVIEW_WINDOW_LINE_WIDTH = 40;
    private static final String PREF_PREVIEW_LINE_WIDTH = "org.eclipse.jdt.ui.codeformatter.line_wrapping_tab_page.preview_line_width";
    protected final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    protected TreeViewer fCategoriesViewer;
    protected Combo fWrappingStyleCombo;
    protected Label fIndentStyleLabel;
    protected Combo fIndentStyleCombo;
    protected Button fForceSplit;
    protected CompilationUnitPreview fPreview;
    protected Group fOptionsGroup;
    private final List fCategories;
    protected final CategoryListener fCategoryListener;
    protected String fCurrentKey;
    protected final Map fPreviewPreferences;
    private final String LINE_SPLIT = "org.eclipse.jdt.core.formatter.lineSplit";

    public LineWrappingTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
        String previewLineWidth = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = new HashMap();
        this.fPreviewPreferences.put("org.eclipse.jdt.core.formatter.lineSplit", previewLineWidth != null ? previewLineWidth : Integer.toString(DEFAULT_PREVIEW_WINDOW_LINE_WIDTH));
        this.fCategories = this.createCategories();
        this.fCategoryListener = new CategoryListener(this.fCategories);
        this.fCurrentKey = ((Category)this.fCategories.iterator().next()).key;
    }

    protected List createCategories() {
        Category classDeclarations = new Category(FormatterMessages.getString("LineWrappingTabPage.class_decls"));
        classDeclarations.children.add(fTypeDeclarationSuperclassCategory);
        classDeclarations.children.add(fTypeDeclarationSuperinterfacesCategory);
        Category constructorDeclarations = new Category(null, null, FormatterMessages.getString("LineWrappingTabPage.constructor_decls"));
        constructorDeclarations.children.add(fConstructorDeclarationsParametersCategory);
        constructorDeclarations.children.add(fConstructorThrowsClauseCategory);
        Category methodDeclarations = new Category(null, null, FormatterMessages.getString("LineWrappingTabPage.method_decls"));
        methodDeclarations.children.add(fMethodDeclarationsParametersCategory);
        methodDeclarations.children.add(fMethodThrowsClauseCategory);
        Category functionCalls = new Category(FormatterMessages.getString("LineWrappingTabPage.function_calls"));
        functionCalls.children.add(fMessageSendArgumentsCategory);
        functionCalls.children.add(fMessageSendSelectorCategory);
        functionCalls.children.add(fExplicitConstructorArgumentsCategory);
        functionCalls.children.add(fAllocationExpressionArgumentsCategory);
        functionCalls.children.add(fQualifiedAllocationExpressionCategory);
        Category expressions = new Category(FormatterMessages.getString("LineWrappingTabPage.expressions"));
        expressions.children.add(fBinaryExpressionCategory);
        expressions.children.add(fConditionalExpressionCategory);
        expressions.children.add(fArrayInitializerExpressionsCategory);
        Category statements = new Category(FormatterMessages.getString("LineWrappingTabPage.statements"));
        statements.children.add(fCompactIfCategory);
        ArrayList<Category> root = new ArrayList<Category>();
        root.add(classDeclarations);
        root.add(constructorDeclarations);
        root.add(methodDeclarations);
        root.add(functionCalls);
        root.add(expressions);
        root.add(statements);
        return root;
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group lineWidthGroup = this.createGroup(numColumns, composite, FormatterMessages.getString("LineWrappingTabPage.width_indent"));
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.getString("LineWrappingTabPage.width_indent.option.max_line_width"), "org.eclipse.jdt.core.formatter.lineSplit", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.getString("LineWrappingTabPage.width_indent.option.default_indent_wrapped"), "org.eclipse.jdt.core.formatter.continuation_indentation", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.getString("LineWrappingTabPage.width_indent.option.default_indent_array"), "org.eclipse.jdt.core.formatter.continuation_indentation_for_array_initializer", 0, 9999);
        this.fCategoriesViewer = new TreeViewer(composite, 2572);
        this.fCategoriesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((Category)parentElement).children.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return !((Category)element).children.isEmpty();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fCategoriesViewer.setInput((Object)this.fCategories);
        this.fCategoriesViewer.setExpandedElements(this.fCategories.toArray());
        GridData gd = LineWrappingTabPage.createGridData(numColumns, 1808, 0);
        this.fCategoriesViewer.getControl().setLayoutData((Object)gd);
        this.fOptionsGroup = this.createGroup(numColumns, composite, "");
        LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.getString("LineWrappingTabPage.wrapping_policy.label.text"));
        this.fWrappingStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fWrappingStyleCombo.setItems(WRAPPING_NAMES);
        this.fWrappingStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fIndentStyleLabel = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.getString("LineWrappingTabPage.indentation_policy.label.text"));
        this.fIndentStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fIndentStyleCombo.setItems(INDENT_NAMES);
        this.fIndentStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit = new Button((Composite)this.fOptionsGroup, 32);
        this.fForceSplit.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit.setText(FormatterMessages.getString("LineWrappingTabPage.force_split.checkbox.text"));
    }

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        super.doCreatePreviewPane(composite, numColumns);
        ModifyDialogTabPage.NumberPreference previewLineWidth = new ModifyDialogTabPage.NumberPreference(composite, numColumns / 2, this.fPreviewPreferences, "org.eclipse.jdt.core.formatter.lineSplit", 0, 9999, FormatterMessages.getString("LineWrappingTabPage.line_width_for_preview.label.text"));
        this.fDefaultFocusManager.add(previewLineWidth);
        previewLineWidth.addObserver(this.fUpdater);
        previewLineWidth.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_PREVIEW_LINE_WIDTH, (String)LineWrappingTabPage.this.fPreviewPreferences.get("org.eclipse.jdt.core.formatter.lineSplit"));
            }
        });
        return composite;
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void initializePage() {
        this.fCategoriesViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCategoryListener);
        this.fCategoriesViewer.addDoubleClickListener((IDoubleClickListener)this.fCategoryListener);
        this.fForceSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.forceSplitChanged(LineWrappingTabPage.this.fForceSplit.getSelection());
            }
        });
        this.fIndentStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.indentStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fWrappingStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.wrappingStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fCategoryListener.restoreSelection();
        this.fDefaultFocusManager.add(this.fCategoriesViewer.getControl());
        this.fDefaultFocusManager.add((Control)this.fWrappingStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fIndentStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fForceSplit);
    }

    protected void doUpdatePreview() {
        Object normalSetting = this.fWorkingValues.get("org.eclipse.jdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.jdt.core.formatter.lineSplit"));
        this.fPreview.update();
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", normalSetting);
    }

    protected void setPreviewText(String text) {
        Object normalSetting = this.fWorkingValues.get("org.eclipse.jdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.jdt.core.formatter.lineSplit"));
        this.fPreview.setPreviewText(text);
        this.fWorkingValues.put("org.eclipse.jdt.core.formatter.lineSplit", normalSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceSplitChanged(boolean forceSplit) {
        try {
            String value = (String)this.fWorkingValues.get(this.fCurrentKey);
            value = DefaultCodeFormatterConstants.setForceWrapping((String)value, (boolean)forceSplit);
            this.fWorkingValues.put(this.fCurrentKey, value);
        }
        catch (Exception e) {
            this.fWorkingValues.put(this.fCurrentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)forceSplit, (int)0, (int)0));
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, FormatterMessages.getFormattedString("LineWrappingTabPage.error.invalid_value", this.fCurrentKey), (Throwable)e));
        }
        finally {
            this.doUpdatePreview();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrappingStyleChanged(int wrappingStyle) {
        try {
            String value = (String)this.fWorkingValues.get(this.fCurrentKey);
            value = DefaultCodeFormatterConstants.setWrappingStyle((String)value, (int)wrappingStyle);
            this.fWorkingValues.put(this.fCurrentKey, value);
        }
        catch (Exception e) {
            this.fWorkingValues.put(this.fCurrentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)wrappingStyle, (int)0));
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, FormatterMessages.getFormattedString("LineWrappingTabPage.error.invalid_value", this.fCurrentKey), (Throwable)e));
        }
        finally {
            this.updateControls(wrappingStyle);
            this.doUpdatePreview();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indentStyleChanged(int indentStyle) {
        try {
            String value = (String)this.fWorkingValues.get(this.fCurrentKey);
            value = DefaultCodeFormatterConstants.setIndentStyle((String)value, (int)indentStyle);
            this.fWorkingValues.put(this.fCurrentKey, value);
        }
        catch (Exception e) {
            this.fWorkingValues.put(this.fCurrentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)0, (int)indentStyle));
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, FormatterMessages.getFormattedString("LineWrappingTabPage.error.invalid_value", this.fCurrentKey), (Throwable)e));
        }
        finally {
            this.doUpdatePreview();
        }
    }

    protected void updateControls(int wrappingStyle) {
        boolean doSplit = wrappingStyle != 0;
        this.fIndentStyleLabel.setEnabled(doSplit);
        this.fIndentStyleCombo.setEnabled(doSplit);
        this.fForceSplit.setEnabled(doSplit);
    }

    private final class CategoryListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private final List fCategoriesList = new ArrayList();
        private int fIndex = 0;

        public CategoryListener(List categoriesTree) {
            this.flatten(this.fCategoriesList, categoriesTree);
        }

        private void flatten(List categoriesList, List categoriesTree) {
            Iterator iter = categoriesTree.iterator();
            while (iter.hasNext()) {
                Category category = (Category)iter.next();
                ++this.fIndex;
                category.index = category.index;
                categoriesList.add(category);
                this.flatten(categoriesList, category.children);
            }
        }

        public void add(Category category) {
            category.index = this.fIndex++;
            this.fCategoriesList.add(category);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Category category = (Category)selection.getFirstElement();
            LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_CATEGORY_INDEX, category.index);
            LineWrappingTabPage.this.fCurrentKey = category.key;
            if (LineWrappingTabPage.this.fCurrentKey != null) {
                LineWrappingTabPage.this.fOptionsGroup.setText(FormatterMessages.getString("LineWrappingTabPage.group") + category.name.toLowerCase());
            } else {
                LineWrappingTabPage.this.fOptionsGroup.setText("");
            }
            LineWrappingTabPage.this.setPreviewText(category.previewText);
            String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
            boolean enabled = value != null;
            LineWrappingTabPage.this.fOptionsGroup.setVisible(enabled);
            if (enabled) {
                int wrappingStyle;
                int indentStyle;
                boolean forceWrapping;
                try {
                    forceWrapping = DefaultCodeFormatterConstants.getForceWrapping((String)value);
                    indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)value);
                    wrappingStyle = DefaultCodeFormatterConstants.getWrappingStyle((String)value);
                }
                catch (IllegalArgumentException e) {
                    forceWrapping = false;
                    indentStyle = 0;
                    wrappingStyle = 0;
                }
                LineWrappingTabPage.this.fForceSplit.setSelection(forceWrapping);
                LineWrappingTabPage.this.fIndentStyleCombo.setText(INDENT_NAMES[indentStyle]);
                LineWrappingTabPage.this.fWrappingStyleCombo.setText(WRAPPING_NAMES[wrappingStyle]);
                LineWrappingTabPage.this.updateControls(wrappingStyle);
            }
        }

        public void restoreSelection() {
            int index;
            try {
                index = LineWrappingTabPage.this.fDialogSettings.getInt(LineWrappingTabPage.PREF_CATEGORY_INDEX);
            }
            catch (NumberFormatException ex) {
                index = -1;
            }
            if (index < 0 || index > this.fCategoriesList.size() - 1) {
                index = 1;
            }
            Category category = (Category)this.fCategoriesList.get(index);
            LineWrappingTabPage.this.fCategoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new Category[]{category}));
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Category node = (Category)((IStructuredSelection)selection).getFirstElement();
                LineWrappingTabPage.this.fCategoriesViewer.setExpandedState((Object)node, !LineWrappingTabPage.this.fCategoriesViewer.getExpandedState((Object)node));
            }
        }
    }

    private static final class Category {
        public final String key;
        public final String name;
        public final String previewText;
        public final List children;
        public int index;

        public Category(String key, String previewText, String name) {
            this.key = key;
            this.name = name;
            this.previewText = previewText != null ? ModifyDialogTabPage.createPreviewHeader(name) + previewText : null;
            this.children = new ArrayList();
        }

        public Category(String name) {
            this(null, null, name);
        }

        public String toString() {
            return this.name;
        }
    }
}

