/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AlreadyExistsDialog
extends StatusDialog {
    private Composite fComposite;
    protected Text fNameText;
    private Button fRenameRadio;
    private Button fOverwriteRadio;
    private final int NUM_COLUMNS = 2;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final ProfileManager.CustomProfile fProfile;
    private final ProfileManager fProfileManager;

    public AlreadyExistsDialog(Shell parentShell, ProfileManager.CustomProfile profile, ProfileManager profileManager) {
        super(parentShell);
        this.fProfile = profile;
        this.fProfileManager = profileManager;
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, FormatterMessages.getString("AlreadyExistsDialog.message.profile_already_exists"));
        this.fEmpty = new StatusInfo(4, FormatterMessages.getString("AlreadyExistsDialog.message.profile_name_empty"));
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.getString("AlreadyExistsDialog.dialog.title"));
    }

    public Control createDialogArea(Composite parent) {
        this.initializeComposite(parent);
        this.createLabel(FormatterMessages.getFormattedString("AlreadyExistsDialog.dialog.label", this.fProfile.getName()));
        this.fRenameRadio = this.createRadioButton(FormatterMessages.getString("AlreadyExistsDialog.rename_radio_button.desc"));
        this.fNameText = this.createTextField();
        this.fOverwriteRadio = this.createRadioButton(FormatterMessages.getString("AlreadyExistsDialog.overwrite_radio_button.desc"));
        this.fRenameRadio.setSelection(true);
        this.fNameText.setText(this.fProfile.getName());
        this.fNameText.setSelection(0, this.fProfile.getName().length());
        this.fNameText.setFocus();
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AlreadyExistsDialog.this.doValidation();
            }
        });
        this.fRenameRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlreadyExistsDialog.this.fNameText.setEnabled(true);
                AlreadyExistsDialog.this.fNameText.setFocus();
                AlreadyExistsDialog.this.fNameText.setSelection(0, AlreadyExistsDialog.this.fNameText.getText().length());
                AlreadyExistsDialog.this.doValidation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fOverwriteRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlreadyExistsDialog.this.fNameText.setEnabled(false);
                AlreadyExistsDialog.this.doValidation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateStatus(this.fDuplicate);
        AlreadyExistsDialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    private void initializeComposite(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        this.fComposite.setLayout((Layout)layout);
    }

    private Label createLabel(String text) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label label = new Label(this.fComposite, 64);
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Button createRadioButton(String text) {
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Button radio = new Button(this.fComposite, 16);
        radio.setLayoutData((Object)gd);
        radio.setText(text);
        return radio;
    }

    private Text createTextField() {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Text text = new Text(this.fComposite, 2052);
        text.setLayoutData((Object)gd);
        return text;
    }

    protected void doValidation() {
        if (this.fOverwriteRadio.getSelection()) {
            this.updateStatus(this.fOk);
            return;
        }
        String name = this.fNameText.getText().trim();
        if (name.length() == 0) {
            this.updateStatus(this.fEmpty);
            return;
        }
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus(this.fDuplicate);
            return;
        }
        this.updateStatus(this.fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.fRenameRadio.getSelection()) {
            this.fProfile.setName(this.fNameText.getText().trim());
        }
        super.okPressed();
    }
}

