/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JavaMarkerAnnotation
extends MarkerAnnotation
implements IJavaAnnotation {
    public static final String JAVA_MARKER_TYPE_PREFIX = "org.eclipse.jdt";
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.jdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.jdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.eclipse.jdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IJavaAnnotation fOverlay;

    public JavaMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public String[] getArguments() {
        IMarker marker = this.getMarker();
        if (marker != null && marker.exists() && this.isProblem()) {
            return CorrectionEngine.getProblemArguments((IMarker)marker);
        }
        return null;
    }

    public int getId() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return -1;
        }
        if (this.isProblem()) {
            return marker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        String type = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(type) || ERROR_ANNOTATION_TYPE.equals(type);
    }

    public void setOverlay(IJavaAnnotation javaAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = javaAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public IJavaAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(IJavaAnnotation annotation) {
    }

    public void removeOverlaid(IJavaAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        IJavaElement element = JavaCore.create((IResource)this.getMarker().getResource());
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }
}

