/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

class JavaStructureDiffViewer
extends StructureDiffViewer {
    private static final String SMART = "SMART";
    private ActionContributionItem fSmartActionItem;
    private JavaStructureCreator fStructureCreator = new JavaStructureCreator();
    private boolean fThreeWay;

    public JavaStructureDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setStructureCreator(this.fStructureCreator);
    }

    protected void initialSelection() {
        Object[] children;
        DiffNode firstClass = null;
        Object o = this.getRoot();
        if (o != null && (children = this.getSortedChildren(o)) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                o = children[i];
                if ((children = this.getSortedChildren(o)) == null || children.length <= 0) continue;
                for (int j = 0; j < children.length; ++j) {
                    JavaNode jn;
                    int tc;
                    DiffNode dn;
                    ITypedElement e;
                    o = children[j];
                    if (!(o instanceof DiffNode) || !((e = (dn = (DiffNode)o).getId()) instanceof JavaNode) || (tc = (jn = (JavaNode)e).getTypeCode()) != 5 && tc != 4) continue;
                    firstClass = dn;
                }
            }
        }
        if (firstClass != null) {
            this.expandToLevel(firstClass, 1);
        } else {
            this.expandToLevel(2);
        }
    }

    protected void compareInputChanged(ICompareInput input) {
        this.fThreeWay = input != null ? input.getAncestor() != null : false;
        this.setSmartButtonVisible(this.fThreeWay);
        super.compareInputChanged(input);
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        ChangePropertyAction a = new ChangePropertyAction(this.getBundle(), this.getCompareConfiguration(), "action.Smart.", SMART);
        this.fSmartActionItem = new ActionContributionItem((IAction)a);
        this.fSmartActionItem.setVisible(this.fThreeWay);
        toolBarManager.appendToGroup("modes", (IContributionItem)this.fSmartActionItem);
    }

    protected void postDiffHook(Differencer differencer, IDiffContainer root) {
        boolean smart;
        if (this.fStructureCreator.canRewriteTree() && (smart = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)SMART, (boolean)false)) && root != null) {
            this.fStructureCreator.rewriteTree(differencer, root);
        }
    }

    protected void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SMART)) {
            this.diff();
        } else {
            super.propertyChange(event);
        }
    }

    private void setSmartButtonVisible(boolean visible) {
        if (this.fSmartActionItem == null) {
            return;
        }
        Control c = this.getControl();
        if (c == null && c.isDisposed()) {
            return;
        }
        this.fSmartActionItem.setVisible(visible);
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)c.getParent());
        if (tbm != null) {
            tbm.update(true);
            ToolBar tb = tbm.getControl();
            if (!tb.isDisposed()) {
                tb.getParent().layout(true);
            }
        }
    }
}

