/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public abstract class TypeInfo {
    final String fName;
    final String fPackage;
    final char[][] fEnclosingNames;
    final boolean fIsInterface;
    public static final int UNRESOLVABLE_TYPE_INFO = 1;
    public static final int JAR_FILE_ENTRY_TYPE_INFO = 2;
    public static final int IFILE_TYPE_INFO = 3;
    static final char SEPARATOR = '/';
    static final char EXTENSION_SEPARATOR = '.';
    static final char PACKAGE_PART_SEPARATOR = '.';

    protected TypeInfo(String pkg, String name, char[][] enclosingTypes, boolean isInterface) {
        this.fPackage = pkg;
        this.fName = name;
        this.fIsInterface = isInterface;
        this.fEnclosingNames = enclosingTypes;
    }

    public abstract int getElementType();

    public abstract String getPath();

    protected abstract IJavaElement getJavaElement(IJavaSearchScope var1) throws JavaModelException;

    public abstract IPath getPackageFragmentRootPath();

    public String getTypeName() {
        return this.fName;
    }

    public String getPackageName() {
        return this.fPackage;
    }

    public boolean isInterface() {
        return this.fIsInterface;
    }

    public boolean isEnclosed(IJavaSearchScope scope) {
        return scope.encloses(this.getPath());
    }

    public String getEnclosingName() {
        StringBuffer buf = new StringBuffer();
        if (this.fEnclosingNames != null) {
            for (int i = 0; i < this.fEnclosingNames.length; ++i) {
                if (i != 0) {
                    buf.append('.');
                }
                buf.append(this.fEnclosingNames[i]);
            }
        }
        return buf.toString();
    }

    public String getTypeQualifiedName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.fEnclosingNames.length; ++i) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
            }
            buf.append(this.fName);
            return buf.toString();
        }
        return this.fName;
    }

    public String getFullyQualifiedName() {
        StringBuffer buf = new StringBuffer();
        if (this.fPackage.length() > 0) {
            buf.append(this.fPackage);
            buf.append('.');
        }
        if (this.fEnclosingNames != null) {
            for (int i = 0; i < this.fEnclosingNames.length; ++i) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
            }
        }
        buf.append(this.fName);
        return buf.toString();
    }

    public String getTypeContainerName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            if (this.fPackage.length() > 0) {
                buf.append(this.fPackage);
            }
            for (int i = 0; i < this.fEnclosingNames.length; ++i) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(this.fEnclosingNames[i]);
            }
            return buf.toString();
        }
        return this.fPackage;
    }

    public IType resolveType(IJavaSearchScope scope) throws JavaModelException {
        IJavaElement elem = this.getJavaElement(scope);
        if (elem instanceof ICompilationUnit) {
            return JavaModelUtil.findTypeInCompilationUnit((ICompilationUnit)elem, this.getTypeQualifiedName());
        }
        if (elem instanceof IClassFile) {
            return ((IClassFile)elem).getType();
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("path= ");
        buf.append(this.getPath());
        buf.append("; pkg= ");
        buf.append(this.fPackage);
        buf.append("; enclosing= ");
        buf.append(this.getEnclosingName());
        buf.append("; name= ");
        buf.append(this.fName);
        return buf.toString();
    }
}

