/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.corext.util.UnresolvableTypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.widgets.Display;

public class AllTypesCache {
    private static final int INITIAL_DELAY = 4000;
    private static final int TIMEOUT = 3000;
    private static final int INITIAL_SIZE = 2000;
    private static final int CANCEL_POLL_INTERVAL = 300;
    private static final boolean TRACING;
    private static Object fgLock;
    private static volatile boolean fgIsLocked;
    private static volatile TypeCacher fgTypeCacherThread;
    private static TypeInfo[] fgTypeCache;
    private static int fgSizeHint;
    private static volatile boolean fgTerminated;
    private static volatile boolean fgAsyncMode;
    private static int fgNumberOfCacheFlushes;
    private static DelegatedProgressMonitor fDelegatedProgressMonitor;
    private static TypeCacheDeltaListener fgDeltaListener;
    private static Comparator fgTypeNameComparator;

    public static void getTypes(IJavaSearchScope scope, int kind, IProgressMonitor monitor, Collection typesFound) {
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        boolean isWorkspaceScope = scope.equals(SearchEngine.createWorkspaceScope());
        boolean isBoth = kind == 0;
        boolean isInterface = kind == 6;
        for (int i = 0; i < allTypes.length; ++i) {
            TypeInfo info = fgTypeCache[i];
            if (!isWorkspaceScope && !info.isEnclosed(scope) || !isBoth && isInterface != info.isInterface()) continue;
            typesFound.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCache(TypeInfo[] cache) {
        Object object = fgLock;
        synchronized (object) {
            fgTypeCache = cache;
            if (fgTypeCache != null) {
                fgSizeHint = fgTypeCache.length;
            }
            fgTypeCacherThread = null;
            fgLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo[] getAllTypes(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 10);
        SubProgressMonitor checkingMonitor = new SubProgressMonitor(monitor, 1);
        SubProgressMonitor searchingMonitor = new SubProgressMonitor(monitor, 9);
        AllTypesCache.forceDeltaComplete((IProgressMonitor)checkingMonitor);
        searchingMonitor.setTaskName(CorextMessages.getString("AllTypesCache.searching"));
        Object object = fgLock;
        synchronized (object) {
            block18: {
                try {
                    if (fgTypeCache != null) break block18;
                    if (fgTypeCacherThread == null) {
                        ArrayList searchResult = new ArrayList(fgSizeHint);
                        try {
                            fgIsLocked = true;
                            if (AllTypesCache.search(new TypeInfoRequestor(searchResult), 3, (IProgressMonitor)searchingMonitor)) {
                                TypeInfo[] result = searchResult.toArray(new TypeInfo[searchResult.size()]);
                                Arrays.sort(result, fgTypeNameComparator);
                                fgTypeCache = result;
                                fgSizeHint = result.length;
                            }
                            break block18;
                        }
                        finally {
                            fgIsLocked = false;
                        }
                    }
                    fDelegatedProgressMonitor.setDelegate((IProgressMonitor)searchingMonitor);
                    try {
                        while (fgTypeCache == null) {
                            fgLock.wait(300L);
                            if (!searchingMonitor.isCanceled()) continue;
                            throw new OperationCanceledException();
                        }
                    }
                    catch (InterruptedException e) {
                        JavaPlugin.log(e);
                    }
                    finally {
                        fDelegatedProgressMonitor.setDelegate(null);
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return fgTypeCache;
        }
    }

    public static boolean isCacheUpToDate(IProgressMonitor pm) {
        AllTypesCache.forceDeltaComplete(pm);
        return fgTypeCache != null;
    }

    private static void forceDeltaComplete(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        ICompilationUnit[] primaryWorkingCopies = JavaCore.getWorkingCopies(null);
        pm.beginTask("", primaryWorkingCopies.length);
        pm.setTaskName(CorextMessages.getString("AllTypesCache.checking_type_cache"));
        for (int i = 0; i < primaryWorkingCopies.length; ++i) {
            ICompilationUnit curr = primaryWorkingCopies[i];
            try {
                JavaModelUtil.reconcile(curr);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            pm.worked(1);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        pm.done();
    }

    public static int getNumberOfAllTypesHint() {
        return fgSizeHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceCacheFlush() {
        if (fgTerminated) {
            return;
        }
        if (TRACING) {
            System.out.println("All Types Cache -- cache flushed.");
        }
        Object object = fgLock;
        synchronized (object) {
            fgTypeCache = null;
            ++fgNumberOfCacheFlushes;
            if (fgTypeCacherThread != null) {
                fgTypeCacherThread.restart();
            } else if (fgAsyncMode) {
                fgTypeCacherThread = new TypeCacher(fgSizeHint, 3000);
                fgTypeCacherThread.start();
            }
        }
    }

    public static int getNumberOfCacheFlushes() {
        return fgNumberOfCacheFlushes;
    }

    public static TypeInfo[] getTypesForName(String simpleTypeName, IJavaSearchScope searchScope, IProgressMonitor monitor) {
        UnresolvableTypeInfo key;
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        HashSet<String> namesFound = new HashSet<String>();
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        int index = Arrays.binarySearch(allTypes, key = new UnresolvableTypeInfo("", simpleTypeName, null, true, null), fgTypeNameComparator);
        if (index >= 0 && index < allTypes.length) {
            TypeInfo curr;
            int i;
            for (i = index - 1; i >= 0 && simpleTypeName.equals((curr = allTypes[i]).getTypeName()); --i) {
                if (namesFound.contains(curr.getFullyQualifiedName()) || !curr.isEnclosed(searchScope)) continue;
                result.add(curr);
                namesFound.add(curr.getFullyQualifiedName());
            }
            for (i = index; i < allTypes.length && simpleTypeName.equals((curr = allTypes[i]).getTypeName()); ++i) {
                if (namesFound.contains(curr.getFullyQualifiedName()) || !curr.isEnclosed(searchScope)) continue;
                result.add(curr);
                namesFound.add(curr.getFullyQualifiedName());
            }
        }
        return result.toArray(new TypeInfo[result.size()]);
    }

    public static boolean isIndexUpToDate() {
        class TypeFoundException
        extends RuntimeException {
            TypeFoundException() {
            }
        }
        ITypeNameRequestor requestor = new ITypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                throw new TypeFoundException();
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                throw new TypeFoundException();
            }
        };
        try {
            if (!AllTypesCache.search(requestor, 2, null)) {
                return false;
            }
        }
        catch (OperationCanceledException e) {
            return false;
        }
        catch (TypeFoundException typeFoundException) {
            // empty catch block
        }
        return true;
    }

    static boolean search(ITypeNameRequestor requestor, int waitingPolicy, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        try {
            if (monitor == null) {
                monitor = fDelegatedProgressMonitor;
            }
            new SearchEngine().searchAllTypeNames(null, null, 2, 0, SearchEngine.createWorkspaceScope(), requestor, waitingPolicy, monitor);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            if (TRACING) {
                System.out.println("All Types Cache -- building cache failed");
            }
            return false;
        }
        if (TRACING) {
            System.out.println("All Types Cache");
            System.out.println("\t cache populated in thread: " + Thread.currentThread().getName());
            System.out.println("\t time needed to perform search: " + (System.currentTimeMillis() - start) + "ms");
        }
        return true;
    }

    public static void initialize() {
        fgDeltaListener = new TypeCacheDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)fgDeltaListener);
        Display d = Display.getDefault();
        if (d != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    AllTypesCache.startBackgroundMode();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startBackgroundMode() {
        long start = System.currentTimeMillis();
        if (fgIsLocked) {
            fgAsyncMode = true;
            if (TRACING) {
                System.out.println("All Types Cache -- Background Mode started. Time needed " + (System.currentTimeMillis() - start) + "ms.");
            }
            return;
        }
        Object object = fgLock;
        synchronized (object) {
            if (fgTypeCacherThread != null) {
                if (fgTerminated && fgTypeCacherThread != null) {
                    fgTypeCacherThread.abort();
                }
            } else if (!fgTerminated) {
                fgAsyncMode = true;
                if (fgTypeCache == null) {
                    fgTypeCacherThread = new TypeCacher(fgSizeHint, 4000);
                    fgTypeCacherThread.start();
                }
            }
        }
        if (TRACING) {
            System.out.println("All Types Cache -- Background Mode started. Time needed: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (fgDeltaListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)fgDeltaListener);
        }
        fgDeltaListener = null;
        Object object = fgLock;
        synchronized (object) {
            fgTerminated = true;
            fgAsyncMode = false;
            if (fDelegatedProgressMonitor != null && !fDelegatedProgressMonitor.isCanceled()) {
                fDelegatedProgressMonitor.setCanceled(true);
            }
            if (fgTypeCacherThread != null) {
                fgTypeCacherThread.abort();
                try {
                    fgTypeCacherThread.join(1000L);
                }
                catch (InterruptedException e) {
                    JavaPlugin.log(e);
                }
                fgTypeCacherThread = null;
            }
        }
    }

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/allTypesCache");
        TRACING = value != null && value.equalsIgnoreCase("true");
        fgLock = new Object();
        fgSizeHint = 2000;
        fDelegatedProgressMonitor = new DelegatedProgressMonitor();
        fgTypeNameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((TypeInfo)o1).getTypeName().compareTo(((TypeInfo)o2).getTypeName());
            }
        };
    }

    private static class TypeCacheDeltaListener
    implements IElementChangedListener {
        private TypeCacheDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (fgTerminated) {
                return;
            }
            boolean needsFlushing = this.processDelta(event.getDelta());
            if (needsFlushing) {
                AllTypesCache.forceCacheFlush();
            }
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElement elem = delta.getElement();
            boolean isAddedOrRemoved = delta.getKind() != 4 || (delta.getFlags() & 0xC0) != 0;
            switch (elem.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    if (isAddedOrRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                        return false;
                    }
                    if (isAddedOrRemoved || this.isPossibleStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isPossibleStructuralChange(int flags) {
            return (flags & 0x4001) == 1;
        }

        private boolean processChildrenDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!this.processDelta(children[i])) continue;
                return true;
            }
            return false;
        }
    }

    static class TypeCacher
    extends Thread {
        private int fDelay;
        private int fSizeHint;
        private volatile boolean fRestart;
        private volatile boolean fAbort;

        TypeCacher(int sizeHint, int delay) {
            super("All Types Caching");
            this.fSizeHint = sizeHint;
            this.fDelay = delay;
            this.setPriority(4);
        }

        void restart() {
            this.fRestart = true;
            this.interrupt();
        }

        public void abort() {
            this.fAbort = true;
            this.fRestart = true;
            this.interrupt();
        }

        public void run() {
            while (!this.fAbort) {
                if (this.fDelay > 0) {
                    try {
                        Thread.sleep(this.fDelay);
                    }
                    catch (InterruptedException e) {
                        if (!this.fAbort) continue;
                        break;
                    }
                }
                this.fRestart = false;
                Collection searchResult = this.doSearchTypes();
                if (searchResult == null) continue;
                if (!this.fAbort && !this.fRestart) {
                    TypeInfo[] result = searchResult.toArray(new TypeInfo[searchResult.size()]);
                    Arrays.sort(result, fgTypeNameComparator);
                    AllTypesCache.setCache(result);
                }
                if (this.fRestart) continue;
                break;
            }
        }

        private Collection doSearchTypes() {
            class RequestorAbort
            extends RuntimeException {
                private final /* synthetic */ TypeCacher this$0;

                RequestorAbort(TypeCacher this$0) {
                    this.this$0 = this$0;
                }
            }
            if (ResourcesPlugin.getWorkspace() == null) {
                return null;
            }
            ArrayList typesFound = new ArrayList(this.fSizeHint);
            TypeInfoRequestor requestor = new TypeInfoRequestor(typesFound){

                protected boolean inScope(char[] packageName) {
                    if (fRestart) {
                        throw new RequestorAbort(this);
                    }
                    return super.inScope(packageName);
                }
            };
            try {
                if (!AllTypesCache.search(requestor, 3, null)) {
                    return null;
                }
            }
            catch (RequestorAbort e) {
                return null;
            }
            return typesFound;
        }
    }

    static class DelegatedProgressMonitor
    implements IProgressMonitor {
        private IProgressMonitor fDelegate;
        private String fTaskName;
        private int fTotalWork = -1;
        private double fWorked;

        DelegatedProgressMonitor() {
        }

        public synchronized void beginTask(String name, int totalWork) {
            this.fTaskName = name;
            this.fTotalWork = totalWork;
            if (this.fDelegate != null) {
                this.fDelegate.beginTask(name, totalWork);
            }
        }

        public void done() {
        }

        public synchronized void internalWorked(double work) {
            this.fWorked += work;
            if (this.fDelegate != null) {
                this.fDelegate.internalWorked(work);
            }
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public synchronized void setTaskName(String name) {
            this.fTaskName = name;
            if (this.fDelegate != null) {
                this.fDelegate.setTaskName(name);
            }
        }

        public synchronized void subTask(String name) {
            if (this.fDelegate != null) {
                this.fDelegate.subTask(name);
            }
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        synchronized void setDelegate(IProgressMonitor delegate) {
            this.fDelegate = delegate;
            if (this.fDelegate != null) {
                if (this.fTaskName != null) {
                    this.fDelegate.beginTask(this.fTaskName, this.fTotalWork);
                    this.fDelegate.internalWorked(this.fWorked);
                }
            } else {
                this.fTaskName = null;
                this.fTotalWork = -1;
                this.fWorked = 0.0;
            }
        }
    }
}

