/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.RefactoringWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class UseSupertypeWherePossibleRefactoring
extends Refactoring {
    private IType fInputType;
    private TextChangeManager fChangeManager;
    private IType fSuperTypeToUse;
    private IType[] fSuperTypes;
    private boolean fUseSupertypeInInstanceOf;
    private CodeGenerationSettings fCodeGenerationSettings;

    private UseSupertypeWherePossibleRefactoring(IType clazz, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(codeGenerationSettings);
        this.fInputType = clazz;
        this.fUseSupertypeInInstanceOf = false;
        this.fCodeGenerationSettings = codeGenerationSettings;
    }

    public static UseSupertypeWherePossibleRefactoring create(IType type, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        if (!UseSupertypeWherePossibleRefactoring.isAvailable(type)) {
            return null;
        }
        return new UseSupertypeWherePossibleRefactoring(type, codeGenerationSettings);
    }

    public static boolean isAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !type.isAnonymous();
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public void setUseSupertypeInInstanceOf(boolean use) {
        this.fUseSupertypeInInstanceOf = use;
    }

    public boolean getUseSupertypeInInstanceOf() {
        return this.fUseSupertypeInInstanceOf;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fInputType);
        if (orig == null || !orig.exists()) {
            String[] keys = new String[]{this.fInputType.getCompilationUnit().getElementName()};
            String message = RefactoringCoreMessages.getFormattedString("UseSupertypeWherePossibleRefactoring.deleted", keys);
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fInputType = orig;
        this.fSuperTypes = this.getSuperTypes(pm);
        if (Checks.isException(this.fInputType, pm)) {
            String message = RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.unavailable_on_Throwable");
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return Checks.checkIfCuBroken((IMember)this.fInputType);
    }

    private IType[] getSuperTypes(IProgressMonitor pm) throws JavaModelException {
        return JavaModelUtil.getAllSuperTypes(this.fInputType, pm);
    }

    public IType[] getSuperTypes() {
        return this.fSuperTypes;
    }

    public void setSuperTypeToUse(IType superType) {
        Assert.isNotNull(superType);
        this.fSuperTypeToUse = superType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.validateModifiesFiles());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.name"), (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        try {
            pm.beginTask("", 1);
            pm.setTaskName(RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.analyzing..."));
            TextChangeManager manager = new TextChangeManager();
            this.updateReferences(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            TextChangeManager textChangeManager = manager;
            return textChangeManager;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReferences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 1);
        try {
            ExtractInterfaceUtil.updateReferences(manager, this.fInputType, this.fSuperTypeToUse, new RefactoringWorkingCopyOwner(), true, (IProgressMonitor)new SubProgressMonitor(pm, 1), status, this.fCodeGenerationSettings);
        }
        finally {
            pm.done();
        }
    }
}

