/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class RenameNonVirtualMethodProcessor
extends RenameMethodProcessor {
    public RenameNonVirtualMethodProcessor(IMethod method) {
        super(method);
    }

    public boolean isApplicable() throws CoreException {
        return super.isApplicable() && !MethodChecks.isVirtual(this.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        try {
            pm.beginTask("", 2);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), checkContext));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IMethod[] hierarchyMethods = RenameNonVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getMethod(), this.getNewElementName());
            for (int i = 0; i < hierarchyMethods.length; ++i) {
                String message;
                IMethod hierarchyMethod = hierarchyMethods[i];
                RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                if (Checks.compareParamTypes(this.getMethod().getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                    message = RefactoringCoreMessages.getFormattedString("RenamePrivateMethodRefactoring.hierarchy_defines", new String[]{JavaModelUtil.getFullyQualifiedName(this.getMethod().getDeclaringType()), this.getNewElementName()});
                    result.addError(message, context);
                    continue;
                }
                message = RefactoringCoreMessages.getFormattedString("RenamePrivateMethodRefactoring.hierarchy_defines2", new String[]{JavaModelUtil.getFullyQualifiedName(this.getMethod().getDeclaringType()), this.getNewElementName()});
                result.addWarning(message, context);
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        SearchPattern pattern = this.createReferenceSearchPattern();
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        for (int i = 0; i < groups.length; ++i) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (!cu.equals(this.getDeclaringCU())) continue;
            IResource resource = group.getResource();
            int start = this.getMethod().getNameRange().getOffset();
            int length = this.getMethod().getNameRange().getLength();
            MethodDeclarationMatch declarationMatch = new MethodDeclarationMatch((IJavaElement)this.getMethod(), 0, start, length, SearchEngine.getDefaultSearchParticipant(), resource);
            group.add((SearchMatch)declarationMatch);
            break;
        }
        return groups;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 1);
        this.addReferenceUpdates(manager, pm, status);
        this.addDeclarationUpdate(manager.get(this.getDeclaringCU()));
        pm.worked(1);
    }

    private ICompilationUnit getDeclaringCU() {
        return this.getMethod().getCompilationUnit();
    }

    SearchPattern createOccurrenceSearchPattern(IProgressMonitor pm) {
        pm.beginTask("", 1);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.getMethod(), (int)3);
        pm.done();
        return pattern;
    }

    private SearchPattern createReferenceSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.getMethod(), (int)2);
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchResultGroup[] grouped = this.getReferences(pm, status);
        for (int i = 0; i < grouped.length; ++i) {
            SearchResultGroup group = grouped[i];
            SearchMatch[] results = group.getSearchResults();
            ICompilationUnit cu = group.getCompilationUnit();
            TextChange change = manager.get(cu);
            for (int j = 0; j < results.length; ++j) {
                String editName = RefactoringCoreMessages.getString("RenamePrivateMethodRefactoring.update");
                TextChangeCompatibility.addTextEdit(change, editName, this.createTextChange(results[j]));
            }
        }
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        SearchPattern pattern = this.createReferenceSearchPattern();
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
    }
}

