/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class MethodChecks {
    private MethodChecks() {
    }

    public static boolean isVirtual(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return false;
        }
        if (JdtFlags.isPrivate((IMember)method)) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)method);
    }

    public static boolean isVirtual(IMethodBinding methodBinding) {
        if (methodBinding.isConstructor()) {
            return false;
        }
        if (Modifier.isPrivate((int)methodBinding.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static RefactoringStatus checkIfOverridesAnother(IMethod method, IProgressMonitor pm) throws JavaModelException {
        IMethod overrides = MethodChecks.overridesAnotherMethod(method, pm);
        if (overrides == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)overrides);
        String message = RefactoringCoreMessages.getFormattedString("MethodChecks.overrides", new String[]{JavaElementUtil.createMethodSignature(overrides), JavaModelUtil.getFullyQualifiedName(overrides.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)1, (Object)overrides);
    }

    public static RefactoringStatus checkIfComesFromInterface(IMethod method, IProgressMonitor pm) throws JavaModelException {
        IMethod inInterface = MethodChecks.isDeclaredInInterface(method, pm);
        if (inInterface == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)inInterface);
        String message = RefactoringCoreMessages.getFormattedString("MethodChecks.implements", new String[]{JavaElementUtil.createMethodSignature(inInterface), JavaModelUtil.getFullyQualifiedName(inInterface.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)Corext.getPluginId(), (int)2, (Object)inInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMethod isDeclaredInInterface(IMethod method, IProgressMonitor pm) throws JavaModelException {
        Assert.isTrue(MethodChecks.isVirtual(method));
        try {
            pm.beginTask("", 4);
            ITypeHierarchy hier = method.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] classes = hier.getAllClasses();
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 3);
            subPm.beginTask("", classes.length);
            for (int i = 0; i < classes.length; ++i) {
                ITypeHierarchy superTypes = classes[i].newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1));
                IType[] superinterfaces = superTypes.getAllSuperInterfaces(classes[i]);
                for (int j = 0; j < superinterfaces.length; ++j) {
                    IMethod found = Checks.findSimilarMethod(method, superinterfaces[j]);
                    if (found == null || found.equals(method)) continue;
                    IMethod iMethod = found;
                    return iMethod;
                }
                subPm.worked(1);
            }
            IMethod iMethod = null;
            return iMethod;
        }
        finally {
            pm.done();
        }
    }

    public static IMethod overridesAnotherMethod(IMethod method, IProgressMonitor pm) throws JavaModelException {
        boolean overrides;
        IMethod found = JavaModelUtil.findMethodDeclarationInHierarchy(method.getDeclaringType().newSupertypeHierarchy(pm), method.getDeclaringType(), method.getElementName(), method.getParameterTypes(), method.isConstructor());
        boolean bl = overrides = found != null && !found.equals(method) && !JdtFlags.isStatic((IMember)found) && !JdtFlags.isPrivate((IMember)found);
        if (overrides) {
            return found;
        }
        return null;
    }
}

