/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenamePackageChange
extends AbstractJavaElementRenameChange {
    public RenamePackageChange(IPackageFragment pack, String newName) throws JavaModelException {
        this(pack.getPath(), pack.getElementName(), newName);
        Assert.isTrue(!pack.isReadOnly(), "package must not be read only");
    }

    private RenamePackageChange(IPath resourcePath, String oldName, String newName) {
        super(resourcePath, oldName, newName);
    }

    protected IPath createPath(String packageName) {
        return new Path(packageName.replace('.', '/'));
    }

    private IPath createNewPath() {
        IPackageFragment oldPackage = this.getPackage();
        IPath oldPackageName = this.createPath(oldPackage.getElementName());
        IPath newPackageName = this.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append(newPackageName);
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.getModifiedElement();
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenamePackageChange.name", new String[]{this.getOldName(), this.getNewName()});
    }

    protected Change createUndoChange() {
        if (this.getPackage() == null) {
            return new NullChange();
        }
        return new RenamePackageChange(this.createNewPath(), this.getNewName(), this.getOldName());
    }

    protected void doRename(IProgressMonitor pm) throws JavaModelException, CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack != null) {
            pack.rename(this.getNewName(), false, pm);
        }
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaElement element = (IJavaElement)this.getModifiedElement();
        if (element != null && element.exists() && element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            ICompilationUnit[] units = pack.getCompilationUnits();
            if (units == null || units.length == 0) {
                return result;
            }
            pm.beginTask("", units.length);
            for (int i = 0; i < units.length; ++i) {
                pm.subTask(RefactoringCoreMessages.getFormattedString("RenamePackageChange.checking_change", element.getElementName()));
                RenamePackageChange.checkIfModifiable(result, units[i], true, true);
                pm.worked(1);
            }
            pm.done();
        }
        return result;
    }
}

