/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class SynchronizeModelProvider
implements ISyncInfoSetChangeListener,
ISynchronizeModelProvider,
IResourceChangeListener {
    private static boolean DEBUG = false;
    protected Map resourceMap = Collections.synchronizedMap(new HashMap());
    protected SynchronizeModelElement root;
    private StructuredViewer viewer;
    private Set pendingLabelUpdates = Collections.synchronizedSet(new HashSet());
    private LabelUpdateJob labelUpdater = new LabelUpdateJob();
    private ISynchronizePageConfiguration configuration;
    private boolean disposed = false;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty() == "org.eclipse.team.ui.busy") {
                SynchronizeModelProvider.this.labelUpdater.add(event.getSource(), (Boolean)event.getNewValue());
            }
        }
    };
    private SyncInfoSet set;

    public SynchronizeModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        this(new UnchangedResourceModelElement(null, (IResource)ResourcesPlugin.getWorkspace().getRoot()){

            public boolean hasChildren() {
                return true;
            }
        }, configuration, set);
    }

    public SynchronizeModelProvider(SynchronizeModelElement parent, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        Assert.isNotNull((Object)set);
        Assert.isNotNull((Object)parent);
        this.root = parent;
        this.set = set;
        this.configuration = configuration;
    }

    public SyncInfoSet getSyncInfoSet() {
        return this.set;
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(StructuredViewer viewer) {
        Assert.isTrue((boolean)(viewer instanceof AbstractTreeViewer));
        this.viewer = (AbstractTreeViewer)viewer;
    }

    public ISynchronizeModelElement prepareInput(IProgressMonitor monitor) {
        this.getSyncInfoSet().connect((ISyncInfoSetChangeListener)this, monitor);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        return this.getModelRoot();
    }

    public Object getMapping(Object object) {
        return this.resourceMap.get(object);
    }

    public void dispose() {
        this.resourceMap.clear();
        this.getSyncInfoSet().removeSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.disposed = true;
    }

    public ISynchronizeModelElement getModelRoot() {
        return this.root;
    }

    public abstract ViewerSorter getViewerSorter();

    protected ISynchronizeModelElement getModelObject(IResource resource) {
        return (ISynchronizeModelElement)this.resourceMap.get(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncInfoChanged(final ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        SynchronizeModelProvider synchronizeModelProvider = this;
        synchronized (synchronizeModelProvider) {
            if (!(event instanceof ISyncInfoTreeChangeEvent)) {
                this.reset();
            } else {
                final Control ctrl = this.getViewer().getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (!ctrl.isDisposed()) {
                                BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)new Runnable(this){
                                    private final /* synthetic */ 3 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void run() {
                                        3.access$300(this.this$1).handleChanges((ISyncInfoTreeChangeEvent)3.access$200(this.this$1));
                                        ISynchronizeModelElement root = 3.access$300(this.this$1).getModelRoot();
                                        if (root instanceof SynchronizeModelElement) {
                                            ((SynchronizeModelElement)root).fireChanges();
                                        }
                                    }
                                });
                            }
                        }

                        static /* synthetic */ ISyncInfoSetChangeEvent access$200(3 x0) {
                            return x0.event;
                        }

                        static /* synthetic */ SynchronizeModelProvider access$300(3 x0) {
                            return x0.SynchronizeModelProvider.this;
                        }
                    });
                }
            }
        }
    }

    protected abstract IDiffElement[] buildModelObjects(ISynchronizeModelElement var1);

    protected abstract void doAdd(ISynchronizeModelElement var1, ISynchronizeModelElement var2);

    protected abstract void doRemove(ISynchronizeModelElement var1);

    protected void associateDiffNode(ISynchronizeModelElement node) {
        IResource resource = node.getResource();
        if (resource != null) {
            this.resourceMap.put(resource, node);
        }
    }

    protected void unassociateDiffNode(IResource resource) {
        this.resourceMap.remove(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleChanges(ISyncInfoTreeChangeEvent event) {
        StructuredViewer viewer = this.getViewer();
        try {
            viewer.getControl().setRedraw(false);
            this.handleResourceChanges(event);
            this.handleResourceRemovals(event);
            this.handleResourceAdditions(event);
            this.firePendingLabelUpdates();
        }
        finally {
            viewer.getControl().setRedraw(true);
        }
    }

    protected abstract void handleResourceAdditions(ISyncInfoTreeChangeEvent var1);

    protected abstract void handleResourceChanges(ISyncInfoTreeChangeEvent var1);

    protected boolean isConflicting(ISynchronizeModelElement diffNode) {
        return (diffNode.getKind() & 0xC) == 12;
    }

    protected abstract void handleResourceRemovals(ISyncInfoTreeChangeEvent var1);

    protected void reset() {
        if (!this.resourceMap.isEmpty()) {
            this.saveViewerState();
        }
        this.resourceMap.clear();
        this.pendingLabelUpdates.clear();
        this.clearModelObjects(this.getModelRoot());
        IDiffElement[] elements = this.getModelRoot().getChildren();
        for (int i = 0; i < elements.length; ++i) {
            this.doRemove((ISynchronizeModelElement)elements[i]);
        }
        this.associateDiffNode(this.getModelRoot());
        this.buildModelObjects(this.getModelRoot());
        ISynchronizeModelElement root = this.getModelRoot();
        if (root instanceof SynchronizeModelElement) {
            ((SynchronizeModelElement)root).fireChanges();
        }
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                StructuredViewer viewer = SynchronizeModelProvider.this.getViewer();
                if (viewer != null && !viewer.getControl().isDisposed()) {
                    viewer.refresh();
                    SynchronizeModelProvider.this.restoreViewerState();
                }
            }
        });
    }

    protected void removeFromViewer(ISynchronizeModelElement node) {
        this.propogateConflictState(node, true);
        this.clearModelObjects(node);
        if (this.canUpdateViewer()) {
            this.doRemove(node);
        }
    }

    protected void removeFromViewer(IResource resource) {
        ISynchronizeModelElement element = this.getModelObject(resource);
        if (element != null) {
            this.removeFromViewer(element);
        }
    }

    protected void clearModelObjects(ISynchronizeModelElement node) {
        IDiffContainer parent;
        IDiffElement[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IDiffElement element = children[i];
            if (!(element instanceof ISynchronizeModelElement)) continue;
            this.clearModelObjects((ISynchronizeModelElement)element);
        }
        IResource resource = node.getResource();
        if (resource != null) {
            this.unassociateDiffNode(resource);
        }
        if ((parent = node.getParent()) != null) {
            parent.removeToRoot((IDiffElement)node);
        }
    }

    protected void addToViewer(ISynchronizeModelElement node) {
        this.associateDiffNode(node);
        node.addPropertyChangeListener(this.listener);
        this.propogateConflictState(node, false);
        String property = this.calculateProblemMarker(node);
        if (property != null) {
            node.setProperty(property, true);
        }
        if (this.canUpdateViewer()) {
            this.doAdd((SynchronizeModelElement)node.getParent(), node);
        }
    }

    private String calculateProblemMarker(ISynchronizeModelElement element) {
        String property;
        block8: {
            IResource resource = element.getResource();
            property = null;
            if (resource != null && resource.exists()) {
                try {
                    IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, this.getLogicalModelDepth(resource));
                    for (int i = 0; i < markers.length; ++i) {
                        IMarker marker = markers[i];
                        try {
                            Integer severity = (Integer)marker.getAttribute("severity");
                            if (severity == null) continue;
                            if (severity == 2) {
                                property = "org.eclipse.team.ui.error";
                                break;
                            }
                            if (severity != 1) continue;
                            property = "org.eclipse.team.ui.warning";
                            continue;
                        }
                        catch (CoreException e) {
                            if (!resource.exists()) {
                                property = null;
                                break;
                            }
                            if (!marker.exists()) continue;
                            TeamPlugin.log((CoreException)e);
                        }
                    }
                }
                catch (CoreException e) {
                    if (!resource.isAccessible() || e.getStatus().getCode() == 368 || e.getStatus().getCode() == 372) break block8;
                    TeamPlugin.log((CoreException)e);
                }
            }
        }
        return property;
    }

    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        if (this.disposed) {
            set.removeSyncSetChangedListener((ISyncInfoSetChangeListener)this);
        } else {
            this.reset();
        }
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
    }

    protected void saveViewerState() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && this.viewer instanceof AbstractTreeViewer) {
            IResource resource;
            int i;
            ISynchronizePageConfiguration config;
            final Object[][] expandedElements = new Object[1][1];
            final Object[][] selectedElements = new Object[1][1];
            this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (SynchronizeModelProvider.this.viewer != null && !SynchronizeModelProvider.this.viewer.getControl().isDisposed()) {
                        expandedElements[0] = ((AbstractTreeViewer)SynchronizeModelProvider.this.viewer).getVisibleExpandedElements();
                        selectedElements[0] = ((IStructuredSelection)SynchronizeModelProvider.this.viewer.getSelection()).toArray();
                    }
                }
            });
            if (expandedElements[0].length > 0) {
                config = this.getConfiguration();
                ArrayList<String> savedExpansionState = new ArrayList<String>();
                for (i = 0; i < expandedElements[0].length; ++i) {
                    if (!(expandedElements[0][i] instanceof ISynchronizeModelElement) || (resource = ((ISynchronizeModelElement)expandedElements[0][i]).getResource()) == null) continue;
                    savedExpansionState.add(resource.getFullPath().toString());
                }
                config.setProperty("org.eclipse.team.ui.P_VIEWER_EXPANSION_STATE", savedExpansionState);
            }
            if (selectedElements[0].length > 0) {
                config = this.getConfiguration();
                ArrayList<String> savedSelectedState = new ArrayList<String>();
                for (i = 0; i < selectedElements[0].length; ++i) {
                    if (!(selectedElements[0][i] instanceof ISynchronizeModelElement) || (resource = ((ISynchronizeModelElement)selectedElements[0][i]).getResource()) == null) continue;
                    savedSelectedState.add(resource.getFullPath().toString());
                }
                config.setProperty("org.eclipse.team.ui.P_VIEWER_SELECTION_STATE", savedSelectedState);
            }
        }
    }

    protected void restoreViewerState() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && this.viewer instanceof AbstractTreeViewer) {
            List savedExpansionState = (List)this.configuration.getProperty("org.eclipse.team.ui.P_VIEWER_EXPANSION_STATE");
            List savedSelectionState = (List)this.configuration.getProperty("org.eclipse.team.ui.P_VIEWER_SELECTION_STATE");
            IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
            final ArrayList<ISynchronizeModelElement> expandedElements = new ArrayList<ISynchronizeModelElement>();
            if (savedExpansionState != null) {
                Iterator it = savedExpansionState.iterator();
                while (it.hasNext()) {
                    String path = (String)it.next();
                    IResource resource = container.findMember(path, true);
                    ISynchronizeModelElement element = this.getModelObject(resource);
                    if (element == null) continue;
                    expandedElements.add(element);
                }
            }
            final ArrayList<ISynchronizeModelElement> selectedElements = new ArrayList<ISynchronizeModelElement>();
            if (savedSelectionState != null) {
                Iterator it = savedSelectionState.iterator();
                while (it.hasNext()) {
                    String path = (String)it.next();
                    IResource resource = container.findMember(path, true);
                    ISynchronizeModelElement element = this.getModelObject(resource);
                    if (element == null) continue;
                    selectedElements.add(element);
                }
            }
            this.asyncExec(new Runnable(){

                public void run() {
                    ((AbstractTreeViewer)SynchronizeModelProvider.this.viewer).setExpandedElements(expandedElements.toArray());
                    SynchronizeModelProvider.this.viewer.setSelection((ISelection)new StructuredSelection((List)selectedElements));
                }
            });
        }
    }

    public void saveState() {
        this.saveViewerState();
    }

    protected void queueForLabelUpdate(ISynchronizeModelElement diffNode) {
        this.pendingLabelUpdates.add(diffNode);
    }

    private boolean canUpdateViewer() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null || viewer.getControl().isDisposed()) {
            return false;
        }
        Display display = viewer.getControl().getDisplay();
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePendingLabelUpdates() {
        if (!this.canUpdateViewer()) {
            return;
        }
        try {
            Object[] updates = this.pendingLabelUpdates.toArray(new Object[this.pendingLabelUpdates.size()]);
            this.updateLabels(updates);
        }
        finally {
            this.pendingLabelUpdates.clear();
        }
    }

    private void updateLabels(Object[] elements) {
        if (this.canUpdateViewer()) {
            StructuredViewer tree = this.getViewer();
            tree.update(elements, null);
        }
    }

    protected void propogateConflictState(ISynchronizeModelElement element, boolean clear) {
        boolean wasConflict;
        boolean isConflict = clear ? false : this.isConflicting(element);
        if (isConflict != (wasConflict = element.getProperty("org.eclipse.team.ui.conflict"))) {
            element.setPropertyToRoot("org.eclipse.team.ui.conflict", isConflict);
            this.updateParentLabels(element);
        }
    }

    private void propagateProblemMarkers(ISynchronizeModelElement element) {
        ISynchronizeModelElement parent;
        String property;
        boolean recalculateParentDecorations;
        IResource resource = element.getResource();
        if (resource != null && (recalculateParentDecorations = this.hadProblemProperty(element, property = this.calculateProblemMarker(element))) && (parent = (ISynchronizeModelElement)element.getParent()) != null) {
            this.propagateProblemMarkers(parent);
        }
    }

    private boolean hadProblemProperty(ISynchronizeModelElement element, String property) {
        boolean hadError = element.getProperty("org.eclipse.team.ui.error");
        boolean hadWarning = element.getProperty("org.eclipse.team.ui.warning");
        IResource resource = element.getResource();
        if (resource != null && resource.isPhantom()) {
            return true;
        }
        if (hadError) {
            if (property != "org.eclipse.team.ui.error") {
                element.setPropertyToRoot("org.eclipse.team.ui.error", false);
                if (property != null) {
                    element.setPropertyToRoot(property, true);
                }
                return true;
            }
            return false;
        }
        if (hadWarning) {
            if (property != "org.eclipse.team.ui.warning") {
                element.setPropertyToRoot("org.eclipse.team.ui.warning", false);
                if (property != null) {
                    element.setPropertyToRoot(property, true);
                    return false;
                }
                return true;
            }
            return false;
        }
        if (property == "org.eclipse.team.ui.error") {
            element.setPropertyToRoot(property, true);
            return false;
        }
        if (property == "org.eclipse.team.ui.warning") {
            element.setPropertyToRoot(property, true);
            return true;
        }
        return false;
    }

    private void updateParentLabels(ISynchronizeModelElement diffNode) {
        this.queueForLabelUpdate(diffNode);
        while (diffNode.getParent() != null) {
            diffNode = (ISynchronizeModelElement)diffNode.getParent();
            this.queueForLabelUpdate(diffNode);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        String[] markerTypes = this.getMarkerTypes();
        HashMap<IResource, ISynchronizeModelElement> changes = new HashMap<IResource, ISynchronizeModelElement>();
        for (int idx = 0; idx < markerTypes.length; ++idx) {
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas(markerTypes[idx], true);
            for (int i = 0; i < markerDeltas.length; ++i) {
                ISynchronizeModelElement element;
                IMarkerDelta delta = markerDeltas[i];
                IResource resource = delta.getResource();
                if (changes.containsKey(resource) || (element = this.getClosestExistingParent(delta.getResource())) == null) continue;
                changes.put(resource, element);
            }
        }
        if (!changes.isEmpty()) {
            this.startMarkerUpdateJob(changes.values().toArray(new ISynchronizeModelElement[changes.size()]));
        }
    }

    private void startMarkerUpdateJob(final ISynchronizeModelElement[] changes) {
        Job job = new Job(Policy.bind("SynchronizeModelProvider.0")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                8 var4_3 = this;
                synchronized (var4_3) {
                    for (int i = 0; i < changes.length; ++i) {
                        ISynchronizeModelElement element = changes[i];
                        SynchronizeModelProvider.this.propagateProblemMarkers(element);
                        SynchronizeModelProvider.this.updateParentLabels(element);
                    }
                }
                if (DEBUG) {
                    long time = System.currentTimeMillis() - start;
                    SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("m:ss.SSS");
                    String took = TIME_FORMAT.format(new Date(time));
                    System.out.println(took + " for " + changes.length + " files");
                }
                SynchronizeModelProvider.this.asyncExec(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        8.access$800(this.this$1).firePendingLabelUpdates();
                    }
                });
                return Status.OK_STATUS;
            }

            static /* synthetic */ SynchronizeModelProvider access$800(8 x0) {
                return x0.SynchronizeModelProvider.this;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected ISynchronizeModelElement getClosestExistingParent(IResource resource) {
        ISynchronizeModelElement element = this.getModelObject(resource);
        if (element == null) {
            while ((element = this.getModelObject(resource = resource.getParent())) == null && resource != null) {
            }
        }
        return element;
    }

    protected int getLogicalModelDepth(IResource resource) {
        return 2;
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    private void asyncExec(final Runnable r) {
        StructuredViewer v = this.getViewer();
        if (v == null) {
            return;
        }
        final Control ctrl = v.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ctrl.isDisposed()) {
                        BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)r);
                    }
                }
            });
        }
    }

    class LabelUpdateJob
    extends WorkbenchJob {
        public static final int BATCH_WAIT_INCREMENT = 100;
        Set nodes = new HashSet();

        public LabelUpdateJob() {
            super(Policy.bind("HierarchicalModelProvider.0"));
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            Object[] updates;
            Set set = this.nodes;
            synchronized (set) {
                updates = this.nodes.toArray(new Object[this.nodes.size()]);
                this.nodes.clear();
            }
            if (SynchronizeModelProvider.this.canUpdateViewer()) {
                StructuredViewer tree = SynchronizeModelProvider.this.getViewer();
                tree.update(updates, null);
            }
            this.schedule(100L);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object node, boolean isBusy) {
            Set set = this.nodes;
            synchronized (set) {
                this.nodes.add(node);
            }
            if (isBusy) {
                this.schedule(100L);
            } else {
                this.schedule(1000L);
            }
        }

        public boolean shouldRun() {
            return !this.nodes.isEmpty();
        }
    }
}

