/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.core.subscribers.WorkingSetFilteredSyncInfoCollector;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.actions.SubscriberActionContribution;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public final class SubscriberParticipantPage
extends SyncInfoSetSynchronizePage
implements IAdaptable {
    private SubscriberParticipant participant;
    private static final int[] INCOMING_MODE_FILTER = new int[]{12, 8};
    private static final int[] OUTGOING_MODE_FILTER = new int[]{12, 4};
    private static final int[] BOTH_MODE_FILTER = new int[]{12, 8, 4};
    private static final int[] CONFLICTING_MODE_FILTER = new int[]{12};
    private WorkingSetFilteredSyncInfoCollector collector;

    public SubscriberParticipantPage(ISynchronizePageConfiguration configuration, SubscriberSyncInfoCollector subscriberCollector) {
        super(configuration);
        this.participant = (SubscriberParticipant)configuration.getParticipant();
        configuration.setComparisonType(this.isThreeWay() ? "three-way" : "two-way");
        configuration.addActionContribution(new SubscriberActionContribution());
        this.initializeCollector(configuration, subscriberCollector);
    }

    public SubscriberParticipant getParticipant() {
        return this.participant;
    }

    protected void updateMode(int mode) {
        if (this.collector != null && this.isThreeWay()) {
            int[] modeFilter = BOTH_MODE_FILTER;
            switch (mode) {
                case 1: {
                    modeFilter = INCOMING_MODE_FILTER;
                    break;
                }
                case 2: {
                    modeFilter = OUTGOING_MODE_FILTER;
                    break;
                }
                case 4: {
                    modeFilter = BOTH_MODE_FILTER;
                    break;
                }
                case 8: {
                    modeFilter = CONFLICTING_MODE_FILTER;
                }
            }
            this.collector.setFilter((SyncInfoFilter)new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{new FastSyncInfoFilter.SyncInfoDirectionFilter(modeFilter)}));
        }
    }

    private void initializeCollector(ISynchronizePageConfiguration configuration, SubscriberSyncInfoCollector subscriberCollector) {
        SubscriberParticipant participant = this.getParticipant();
        this.collector = new WorkingSetFilteredSyncInfoCollector(subscriberCollector, participant.getSubscriber().roots());
        this.updateMode(configuration.getMode());
        this.collector.reset();
        configuration.setProperty("org.eclipse.team.ui.P_SYNC_INFO_SET", this.collector.getSyncInfoTree());
        configuration.setProperty("org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET", this.collector.getWorkingSetSyncInfoSet());
    }

    protected boolean isThreeWay() {
        return this.getParticipant().getSubscriber().getResourceComparator().isThreeWay();
    }

    public void reset() {
        this.getParticipant().reset();
    }

    public WorkingSetFilteredSyncInfoCollector getCollector() {
        return this.collector;
    }

    public void dispose() {
        super.dispose();
        this.collector.dispose();
    }
}

