/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupUtils;

public class ExternalArchiveSourceContainer
extends AbstractSourceContainer {
    private boolean fDetectRoots = false;
    private Map fRoots = new HashMap(5);
    private String fArchivePath = null;
    public static final String TYPE_ID = DebugPlugin.getUniqueIdentifier() + ".containerType.externalArchive";

    public ExternalArchiveSourceContainer(String archivePath, boolean detectRootPaths) {
        this.fArchivePath = archivePath;
        this.fDetectRoots = detectRootPaths;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        boolean isQualfied;
        name = name.replace('\\', '/');
        ZipFile file = this.getArchive();
        boolean bl = isQualfied = name.indexOf(47) > 0;
        if (this.fDetectRoots && isQualfied) {
            String root = this.getRoot(file, name);
            if (root != null) {
                ZipEntry entry;
                if (root.length() > 0) {
                    name = root + name;
                }
                if ((entry = file.getEntry(name)) != null) {
                    return new Object[]{new ZipEntryStorage(file, entry)};
                }
            }
        } else {
            ZipEntry entry = file.getEntry(name);
            if (entry != null) {
                return new Object[]{new ZipEntryStorage(file, entry)};
            }
            Enumeration<? extends ZipEntry> entries = file.entries();
            ArrayList<ZipEntryStorage> matches = null;
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(name) || !isQualfied && entryName.length() != name.length() && entryName.charAt(entryName.length() - name.length() - 1) != '/') continue;
                if (this.isFindDuplicates()) {
                    if (matches == null) {
                        matches = new ArrayList<ZipEntryStorage>();
                    }
                    matches.add(new ZipEntryStorage(file, entry));
                    continue;
                }
                return new Object[]{new ZipEntryStorage(file, entry)};
            }
            if (matches != null) {
                return matches.toArray();
            }
        }
        return EMPTY;
    }

    private String getRoot(ZipFile file, String name) throws CoreException {
        int index = name.lastIndexOf(46);
        String fileType = null;
        fileType = index >= 0 ? name.substring(index) : "";
        String root = (String)this.fRoots.get(fileType);
        if (root == null && (root = this.detectRoot(file, name)) != null) {
            this.fRoots.put(fileType, root);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String detectRoot(ZipFile file, String name) throws CoreException {
        ZipFile zipFile = file;
        synchronized (zipFile) {
            Enumeration<? extends ZipEntry> entries = file.entries();
            try {
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(name)) continue;
                    int rootLength = entryName.length() - name.length();
                    if (rootLength > 0) {
                        return entryName.substring(0, rootLength);
                    }
                    return "";
                }
            }
            catch (IllegalStateException e) {
                this.abort(MessageFormat.format(SourceLookupMessages.getString("ExternalArchiveSourceContainer.1"), this.getName()), e);
            }
        }
        return null;
    }

    private ZipFile getArchive() throws CoreException {
        try {
            return SourceLookupUtils.getZipFile(this.fArchivePath);
        }
        catch (IOException e) {
            this.abort(MessageFormat.format(SourceLookupMessages.getString("ExternalArchiveSourceContainer.2"), this.fArchivePath), e);
            return null;
        }
    }

    public String getName() {
        return this.fArchivePath;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean isDetectRoot() {
        return this.fDetectRoots;
    }

    public boolean equals(Object obj) {
        return obj instanceof ExternalArchiveSourceContainer && ((ExternalArchiveSourceContainer)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void dispose() {
        super.dispose();
        this.fRoots.clear();
    }
}

