/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class StandardVMRunner
extends AbstractVMRunner {
    protected IVMInstall fVMInstance;

    public StandardVMRunner(IVMInstall vmInstance) {
        this.fVMInstance = vmInstance;
    }

    protected String renderDebugTarget(String classToRun, int host) {
        String format = LaunchingMessages.getString("StandardVMRunner.{0}_at_localhost_{1}_1");
        return MessageFormat.format(format, classToRun, String.valueOf(host));
    }

    public static String renderProcessLabel(String[] commandLine) {
        String format = LaunchingMessages.getString("StandardVMRunner.{0}_({1})_2");
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine[0], timestamp);
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < commandLine.length; ++i) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            for (int j = 0; j < characters.length; ++j) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command.toString());
                buf.append('\"');
                continue;
            }
            buf.append(command.toString());
        }
        return buf.toString();
    }

    protected void addArguments(String[] args, List v) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            v.add(args[i]);
        }
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort(MessageFormat.format(LaunchingMessages.getString("StandardVMRunner.Specified_working_directory_does_not_exist_or_is_not_a_directory__{0}_3"), path), null, 108);
        }
        return dir;
    }

    protected String getPluginIdentifier() {
        return LaunchingPlugin.getUniqueIdentifier();
    }

    protected String constructProgramString(VMRunnerConfiguration config) throws CoreException {
        String command = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
        }
        if (command == null) {
            File exe = StandardVMType.findJavaExecutable(this.fVMInstance.getInstallLocation());
            if (exe == null) {
                this.abort(MessageFormat.format(LaunchingMessages.getString("StandardVMRunner.Unable_to_locate_executable_for_{0}_1"), this.fVMInstance.getName()), null, 150);
            }
            return exe.getAbsolutePath();
        }
        String installLocation = this.fVMInstance.getInstallLocation().getAbsolutePath() + File.separatorChar;
        File exe = new File(installLocation + "bin" + File.separatorChar + command);
        if (this.fileExists(exe)) {
            return exe.getAbsolutePath();
        }
        if (this.fileExists(exe = new File(exe.getAbsolutePath() + ".exe"))) {
            return exe.getAbsolutePath();
        }
        exe = new File(installLocation + "jre" + File.separatorChar + "bin" + File.separatorChar + command);
        if (this.fileExists(exe)) {
            return exe.getAbsolutePath();
        }
        if (this.fileExists(exe = new File(exe.getAbsolutePath() + ".exe"))) {
            return exe.getAbsolutePath();
        }
        this.abort(MessageFormat.format(LaunchingMessages.getString("StandardVMRunner.Specified_executable_{0}_does_not_exist_for_{1}_4"), command, this.fVMInstance.getName()), null, 150);
        return null;
    }

    protected boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    protected String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuffer buf = new StringBuffer();
        if (cp.length == 0) {
            return "";
        }
        for (int i = 0; i < cp.length; ++i) {
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(cp[i]);
            ++pathCount;
        }
        return buf.toString();
    }

    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.getString("StandardVMRunner.Launching_VM..._1"), 2);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMRunner.Constructing_command_line..._2"));
        String program = this.constructProgramString(config);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        String[] allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        this.addBootClassPathArguments(arguments, config);
        String[] cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        arguments.add(config.getClassToLaunch());
        String[] programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        String[] envp = config.getEnvironment();
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.getString("StandardVMRunner.Starting_virtual_machine..._3"));
        Process p = null;
        File workingDir = this.getWorkingDir(config);
        p = this.exec(cmdLine, workingDir, envp);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = this.newProcess(launch, p, StandardVMRunner.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, StandardVMRunner.renderCommandLine(cmdLine));
        subMonitor.worked(1);
        subMonitor.done();
    }

    protected void addBootClassPathArguments(List arguments, VMRunnerConfiguration config) {
        String[] prependBootCP = null;
        String[] bootCP = null;
        String[] appendBootCP = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            prependBootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND);
            bootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH);
            appendBootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_APPEND);
        }
        if (prependBootCP == null && bootCP == null && appendBootCP == null) {
            bootCP = config.getBootClassPath();
        }
        if (prependBootCP != null) {
            arguments.add("-Xbootclasspath/p:" + this.convertClassPath(prependBootCP));
        }
        if (bootCP != null && bootCP.length > 0) {
            arguments.add("-Xbootclasspath:" + this.convertClassPath(bootCP));
        }
        if (appendBootCP != null) {
            arguments.add("-Xbootclasspath/a:" + this.convertClassPath(appendBootCP));
        }
    }
}

