/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.wizards.tools.MigratePluginWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MigrationAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>(elems.length);
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            for (int i = 0; i < elems.length; ++i) {
                IPluginModelBase model;
                Object elem = elems[i];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                if (project == null || (model = manager.findModel(project)) == null) continue;
                models.add(model);
            }
            IPluginModelBase[] modelArray = models.toArray(new IPluginModelBase[models.size()]);
            MigratePluginWizard wizard = new MigratePluginWizard(modelArray);
            Display display = this.getDisplay();
            final WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)wizard);
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

