/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.ui.search.DependencyExtentLabelProvider;
import org.eclipse.pde.internal.ui.search.JavaSearchOperation;
import org.eclipse.pde.internal.ui.search.SearchGoToAction;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.actions.ActionGroup;

class JavaSearchCollector
implements IJavaSearchResultCollector {
    private IProgressMonitor monitor;
    private ISearchResultView resultView;
    private JavaSearchOperation operation;

    public JavaSearchCollector(JavaSearchOperation op, IProgressMonitor monitor) {
        this.operation = op;
        this.monitor = monitor;
    }

    public void aboutToStart() {
        this.resultView = SearchUI.getSearchResultView();
        this.resultView.searchStarted((IActionGroupFactory)new SearchActionGroupFactory(), this.operation.getSingularLabel(), this.operation.getPluralLabel(), null, "org.eclipse.pde.internal.ui.search.javaSearch", (ILabelProvider)new DependencyExtentLabelProvider(), (IAction)new SearchGoToAction(), (IGroupByKeyComputer)new GroupByKeyComputer(), (IRunnableWithProgress)this.operation);
    }

    public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        if (accuracy == 0) {
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(3);
            JavaCore.addJavaElementMarkerAttributes(attributes, (IJavaElement)enclosingElement);
            attributes.put("charStart", new Integer(Math.max(start, 0)));
            attributes.put("charEnd", new Integer(Math.max(end, 0)));
            IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
            marker.setAttributes(attributes);
            this.resultView.addMatch(enclosingElement.getElementName(), (Object)enclosingElement, resource, marker);
        }
    }

    public void done() {
        if (this.resultView != null) {
            this.resultView.searchFinished();
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    class GroupByKeyComputer
    implements IGroupByKeyComputer {
        GroupByKeyComputer() {
        }

        public Object computeGroupByKey(IMarker marker) {
            return marker;
        }
    }

    class SearchActionGroup
    extends ActionGroup {
        SearchActionGroup() {
        }
    }

    class SearchActionGroupFactory
    implements IActionGroupFactory {
        SearchActionGroupFactory() {
        }

        public ActionGroup createActionGroup(ISearchResultView searchView) {
            return new SearchActionGroup();
        }
    }
}

