/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginElementNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginImportNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginLibraryNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginObjectNode;

public abstract class PluginBaseNode
extends PluginObjectNode
implements IPluginBase {
    private String fSchemaVersion;

    public void add(IPluginLibrary library) throws CoreException {
        IDocumentNode parent = this.getEnclosingElement("runtime", true);
        if (library instanceof PluginLibraryNode) {
            PluginLibraryNode node = (PluginLibraryNode)library;
            node.setModel(this.getModel());
            library.setInTheModel(true);
            parent.addChildNode(node);
            this.fireStructureChanged((IPluginObject)library, 1);
        }
    }

    public void add(IPluginImport pluginImport) throws CoreException {
        IDocumentNode parent = this.getEnclosingElement("requires", true);
        if (pluginImport instanceof PluginImportNode) {
            PluginImportNode node = (PluginImportNode)pluginImport;
            node.setModel(this.getModel());
            pluginImport.setInTheModel(true);
            parent.addChildNode(node);
            this.fireStructureChanged((IPluginObject)pluginImport, 1);
        }
    }

    public void remove(IPluginImport pluginImport) throws CoreException {
        IDocumentNode parent = this.getEnclosingElement("requires", false);
        if (parent != null) {
            parent.removeChildNode((IDocumentNode)pluginImport);
            pluginImport.setInTheModel(false);
            this.fireStructureChanged((IPluginObject)pluginImport, 2);
        }
    }

    public IPluginLibrary[] getLibraries() {
        ArrayList<IDocumentNode> result = new ArrayList<IDocumentNode>();
        IDocumentNode requiresNode = this.getEnclosingElement("runtime", false);
        if (requiresNode != null) {
            IDocumentNode[] children = requiresNode.getChildNodes();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof IPluginLibrary)) continue;
                result.add(children[i]);
            }
        }
        return result.toArray(new IPluginLibrary[result.size()]);
    }

    private IDocumentNode getEnclosingElement(String elementName, boolean create) {
        PluginElementNode element = null;
        IDocumentNode[] children = this.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IPluginElement) || !((PluginElementNode)children[i]).getXMLTagName().equals(elementName)) continue;
            element = (PluginElementNode)children[i];
            break;
        }
        if (element == null && create) {
            element = new PluginElementNode();
            element.setXMLTagName(elementName);
            element.setParentNode(this);
            element.setModel(this.getModel());
            element.setInTheModel(true);
            if (elementName.equals("runtime")) {
                this.addChildNode(element, 0);
            } else if (elementName.equals("requires")) {
                if (children.length > 0 && children[0].getXMLTagName().equals("runtime")) {
                    this.addChildNode(element, 1);
                } else {
                    this.addChildNode(element, 0);
                }
            }
        }
        return element;
    }

    public IPluginImport[] getImports() {
        ArrayList<IDocumentNode> result = new ArrayList<IDocumentNode>();
        IDocumentNode requiresNode = this.getEnclosingElement("requires", false);
        if (requiresNode != null) {
            IDocumentNode[] children = requiresNode.getChildNodes();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof IPluginImport)) continue;
                result.add(children[i]);
            }
        }
        return result.toArray(new IPluginImport[result.size()]);
    }

    public String getProviderName() {
        return this.getXMLAttributeValue("provider-name");
    }

    public String getVersion() {
        return this.getXMLAttributeValue("version");
    }

    public void remove(IPluginLibrary library) throws CoreException {
        IDocumentNode parent = this.getEnclosingElement("runtime", false);
        if (parent != null) {
            parent.removeChildNode((IDocumentNode)library);
            library.setInTheModel(false);
            this.fireStructureChanged((IPluginObject)library, 2);
        }
    }

    public void setProviderName(String providerName) throws CoreException {
        this.setXMLAttribute("provider-name", providerName);
    }

    public void setVersion(String version) throws CoreException {
        this.setXMLAttribute("version", version);
    }

    public void swap(IPluginLibrary l1, IPluginLibrary l2) throws CoreException {
        IDocumentNode node = this.getEnclosingElement("runtime", false);
        if (node != null) {
            node.swap((IDocumentNode)l1, (IDocumentNode)l2);
            this.firePropertyChanged(node, "library_order", l1, l2);
        }
    }

    public String getSchemaVersion() {
        return this.fSchemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) throws CoreException {
        this.fSchemaVersion = schemaVersion;
    }

    public void add(IPluginExtension extension) throws CoreException {
        if (extension instanceof PluginExtensionNode) {
            PluginExtensionNode node = (PluginExtensionNode)extension;
            node.setModel(this.getModel());
            extension.setInTheModel(true);
            this.addChildNode(node);
            this.fireStructureChanged((IPluginObject)extension, 1);
        }
    }

    public void add(IPluginExtensionPoint extensionPoint) throws CoreException {
        if (extensionPoint instanceof PluginExtensionPointNode) {
            PluginExtensionPointNode node = (PluginExtensionPointNode)extensionPoint;
            node.setModel(this.getModel());
            extensionPoint.setInTheModel(true);
            node.setParentNode(this);
            IPluginExtensionPoint[] extPoints = this.getExtensionPoints();
            if (extPoints.length > 0) {
                this.addChildNode(node, this.indexOf((IDocumentNode)extPoints[extPoints.length - 1]) + 1);
            } else {
                IDocumentNode requires = this.getEnclosingElement("requires", false);
                if (requires != null) {
                    this.addChildNode(node, this.indexOf(requires) + 1);
                } else {
                    IDocumentNode runtime = this.getEnclosingElement("runtime", false);
                    if (runtime != null) {
                        this.addChildNode(node, this.indexOf(runtime) + 1);
                    } else {
                        this.addChildNode(node, 0);
                    }
                }
            }
            this.fireStructureChanged((IPluginObject)extensionPoint, 1);
        }
    }

    public IPluginExtensionPoint[] getExtensionPoints() {
        ArrayList<IDocumentNode> result = new ArrayList<IDocumentNode>();
        IDocumentNode[] children = this.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IPluginExtensionPoint)) continue;
            result.add(children[i]);
        }
        return result.toArray(new IPluginExtensionPoint[result.size()]);
    }

    public IPluginExtension[] getExtensions() {
        ArrayList<IDocumentNode> result = new ArrayList<IDocumentNode>();
        IDocumentNode[] children = this.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IPluginExtension)) continue;
            result.add(children[i]);
        }
        return result.toArray(new IPluginExtension[result.size()]);
    }

    public int getIndexOf(IPluginExtension e) {
        IPluginExtension[] children = this.getExtensions();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(e)) continue;
            return i;
        }
        return -1;
    }

    public void remove(IPluginExtension extension) throws CoreException {
        if (extension instanceof IDocumentNode) {
            this.removeChildNode((IDocumentNode)extension);
            extension.setInTheModel(false);
            this.fireStructureChanged((IPluginObject)extension, 2);
        }
    }

    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        if (extensionPoint instanceof IDocumentNode) {
            this.removeChildNode((IDocumentNode)extensionPoint);
            extensionPoint.setInTheModel(false);
            this.fireStructureChanged((IPluginObject)extensionPoint, 2);
        }
    }

    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        this.swap((IDocumentNode)e1, (IDocumentNode)e2);
        this.firePropertyChanged(this, "extension_order", e1, e2);
    }

    public void swap(IPluginImport import1, IPluginImport import2) throws CoreException {
        IDocumentNode node = this.getEnclosingElement("requires", false);
        if (node != null) {
            node.swap((IDocumentNode)import1, (IDocumentNode)import2);
            this.firePropertyChanged(node, "import_order", import1, import2);
        }
    }

    public String getId() {
        return this.getXMLAttributeValue("id");
    }

    public void setId(String id) throws CoreException {
        this.setXMLAttribute("id", id);
    }

    public String getName() {
        return this.getXMLAttributeValue("name");
    }

    public void setName(String name) throws CoreException {
        this.setXMLAttribute("name", name);
    }

    public String write(boolean indent) {
        IDocumentNode requires;
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newLine);
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            buffer.append("<?eclipse version=\"3.0\"?>" + newLine);
        }
        buffer.append(this.writeShallow(false) + newLine);
        IDocumentNode runtime = this.getEnclosingElement("runtime", false);
        if (runtime != null) {
            runtime.setLineIndent(this.getLineIndent() + 3);
            buffer.append(runtime.write(true) + newLine);
        }
        if ((requires = this.getEnclosingElement("requires", false)) != null) {
            requires.setLineIndent(this.getLineIndent() + 3);
            buffer.append(requires.write(true) + newLine);
        }
        IPluginExtensionPoint[] extPoints = this.getExtensionPoints();
        for (int i = 0; i < extPoints.length; ++i) {
            IDocumentNode extPoint = (IDocumentNode)extPoints[i];
            extPoint.setLineIndent(this.getLineIndent() + 3);
            buffer.append(extPoint.write(true) + newLine);
        }
        IPluginExtension[] extensions = this.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IDocumentNode extension = (IDocumentNode)extensions[i];
            extension.setLineIndent(this.getLineIndent() + 3);
            buffer.append(extension.write(true) + newLine);
        }
        buffer.append("</" + this.getXMLTagName() + ">");
        return buffer.toString();
    }

    public String writeShallow(boolean terminate) {
        String provider;
        String version;
        String name;
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + this.getXMLTagName());
        buffer.append(newLine);
        String id = this.getId();
        if (id != null && id.trim().length() > 0) {
            buffer.append("   id=\"" + this.getWritableString(id) + "\"" + newLine);
        }
        if ((name = this.getName()) != null && name.trim().length() > 0) {
            buffer.append("   name=\"" + this.getWritableString(name) + "\"" + newLine);
        }
        if ((version = this.getVersion()) != null && version.trim().length() > 0) {
            buffer.append("   version=\"" + this.getWritableString(version) + "\"" + newLine);
        }
        if ((provider = this.getProviderName()) != null && provider.trim().length() > 0) {
            buffer.append("   provider-name=\"" + this.getWritableString(provider) + "\"");
        }
        String[] specific = this.getSpecificAttributes();
        for (int i = 0; i < specific.length; ++i) {
            buffer.append(newLine + specific[i]);
        }
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }

    protected abstract String[] getSpecificAttributes();
}

