/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.BasicLauncherTab;
import org.eclipse.pde.internal.ui.launcher.JUnitLaunchConfiguration;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class JUnitArgumentsTab
extends BasicLauncherTab {
    protected String getApplicationAttribute() {
        return "testApplication";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-test-workspace").toOSString());
        config.setAttribute("clearws", true);
        config.setAttribute("askclear", false);
        config.setAttribute("progargs", LauncherUtils.getDefaultProgramArguments());
        config.setAttribute("vmargs", "");
        config.setAttribute("bootstrap", "");
        if (!JUnitLaunchConfiguration.requiresUI((ILaunchConfiguration)config)) {
            config.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
        }
    }

    protected String[] getApplicationNames() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(PDEPlugin.getResourceString("JUnitArgumentsTab.headless"));
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            for (int j = 0; j < extensions.length; ++j) {
                String id;
                String point = extensions[j].getPoint();
                if (point == null || !point.equals("org.eclipse.core.runtime.applications") || (id = extensions[j].getPluginBase().getId() + "." + extensions[j].getId()) == null || id.startsWith("org.eclipse.pde.junit.runtime")) continue;
                result.add(id);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String application = config.getAttribute("application", (String)null);
        if ("org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
            this.fApplicationCombo.setText(this.fApplicationCombo.getItem(0));
        } else {
            super.initializeApplicationSection(config);
        }
    }

    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        if (this.fApplicationCombo.getSelectionIndex() == 0) {
            config.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
        } else {
            config.setAttribute("application", (String)null);
            super.saveApplicationSection(config);
        }
    }
}

