/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AdvancedLauncherTab
extends AbstractLauncherTab
implements ILaunchConfigurationTab,
ILauncherSettings {
    private Button fUseDefaultRadio;
    private Button fUseFeaturesRadio;
    private Button fUseListRadio;
    private Button fAddRequiredButton;
    private CheckboxTreeViewer fPluginTreeViewer;
    private Label fVisibleLabel;
    private NamedElement fWorkspacePlugins;
    private NamedElement fExternalPlugins;
    private IPluginModelBase[] fExternalModels;
    private IPluginModelBase[] fWorkspaceModels;
    private Button fDefaultsButton;
    private int fNumExternalChecked = 0;
    private int fNumWorkspaceChecked = 0;
    private Image fImage;
    private boolean fShowFeatures = true;
    private Button fSelectAllButton;
    private Button fDeselectButton;

    public AdvancedLauncherTab() {
        this(true);
    }

    public AdvancedLauncherTab(boolean showFeatures) {
        this.fShowFeatures = showFeatures;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fImage = PDEPluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.fExternalModels = PDECore.getDefault().getExternalModelManager().getAllModels();
        this.fWorkspaceModels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fUseDefaultRadio = new Button(composite, 16);
        this.fUseDefaultRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useDefault"));
        if (this.fShowFeatures) {
            this.fUseFeaturesRadio = new Button(composite, 16);
            this.fUseFeaturesRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useFeatures"));
        }
        this.fUseListRadio = new Button(composite, 16);
        this.fUseListRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useList"));
        this.createPluginList(composite);
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_advanced");
    }

    private void hookListeners() {
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.useDefaultChanged();
            }
        };
        this.fUseDefaultRadio.addSelectionListener((SelectionListener)adapter);
        if (this.fShowFeatures) {
            this.fUseFeaturesRadio.addSelectionListener((SelectionListener)adapter);
        }
        this.fDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.computeInitialCheckState();
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fAddRequiredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)AdvancedLauncherTab.this.getControl().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        AdvancedLauncherTab.access$800(3.access$700(this.this$1));
                        AdvancedLauncherTab.access$600(3.access$700(this.this$1));
                    }
                });
            }

            static /* synthetic */ AdvancedLauncherTab access$700(3 x0) {
                return x0.AdvancedLauncherTab.this;
            }
        });
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.toggleGroups(true);
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fDeselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.toggleGroups(false);
                AdvancedLauncherTab.this.updateStatus();
            }
        });
    }

    protected void toggleGroups(boolean select) {
        this.handleGroupStateChanged(this.fWorkspacePlugins, select);
        this.handleGroupStateChanged(this.fExternalPlugins, select);
    }

    private void useDefaultChanged() {
        this.adjustCustomControlEnableState(this.fUseListRadio.getSelection());
        this.updateStatus();
    }

    private void adjustCustomControlEnableState(boolean enable) {
        this.fVisibleLabel.setVisible(enable);
        this.fPluginTreeViewer.getTree().setVisible(enable);
        this.fAddRequiredButton.setVisible(enable);
        this.fDefaultsButton.setVisible(enable);
        this.fSelectAllButton.setVisible(enable);
        this.fDeselectButton.setVisible(enable);
    }

    private void createPluginList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fVisibleLabel = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fVisibleLabel.setLayoutData((Object)gd);
        this.fVisibleLabel.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.visibleList"));
        this.createPluginViewer(composite);
        this.createButtonContainer(composite);
    }

    private void computeSubset() {
        int i;
        Object[] checked = this.fPluginTreeViewer.getCheckedElements();
        TreeMap map = new TreeMap();
        for (i = 0; i < checked.length; ++i) {
            if (!(checked[i] instanceof IPluginModelBase)) continue;
            IPluginModelBase model = (IPluginModelBase)checked[i];
            this.addPluginAndDependencies(model, map);
        }
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            this.addPluginAndDependencies(this.findPlugin("org.eclipse.core.runtime"), map);
        }
        checked = map.values().toArray();
        this.fPluginTreeViewer.setCheckedElements(map.values().toArray());
        this.fNumExternalChecked = 0;
        this.fNumWorkspaceChecked = 0;
        for (i = 0; i < checked.length; ++i) {
            if (checked[i] instanceof WorkspacePluginModelBase) {
                ++this.fNumWorkspaceChecked;
                continue;
            }
            ++this.fNumExternalChecked;
        }
        this.adjustGroupState();
    }

    private void addPluginAndDependencies(IPluginModelBase model, TreeMap map) {
        if (model == null) {
            return;
        }
        String id = model.getPluginBase().getId();
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, model);
        if (model instanceof IFragmentModel) {
            IPluginModelBase parent = this.findPlugin(((IFragmentModel)model).getFragment().getPluginId());
            this.addPluginAndDependencies(parent, map);
        } else {
            boolean addFragments = false;
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            for (int i = 0; i < libs.length; ++i) {
                if (!ClasspathUtilCore.containsVariables((String)libs[i].getName())) continue;
                addFragments = true;
                break;
            }
            if (addFragments) {
                IFragmentModel[] fragments = this.findFragments(model.getPluginBase());
                for (int i = 0; i < fragments.length; ++i) {
                    this.addPluginAndDependencies((IPluginModelBase)fragments[i], map);
                }
            }
        }
        IPluginImport[] imports = model.getPluginBase().getImports();
        for (int i = 0; i < imports.length; ++i) {
            this.addPluginAndDependencies(this.findPlugin(imports[i].getId()), map);
        }
    }

    private IPluginModelBase findPlugin(String id) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        if (entry != null) {
            IPluginModelBase model = entry.getActiveModel();
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                return model;
            }
            model = entry.getExternalModel();
            if (model != null && this.fPluginTreeViewer.getChecked((Object)model)) {
                return model;
            }
            return entry.getActiveModel();
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPluginBase plugin) {
        ModelEntry[] entries = PDECore.getDefault().getModelManager().getEntries();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        for (int i = 0; i < entries.length; ++i) {
            String id;
            ModelEntry entry = entries[i];
            IPluginModelBase model = entry.getActiveModel();
            if (!(model instanceof IFragmentModel) || !(id = ((IFragmentModel)model).getFragment().getPluginId()).equals(plugin.getId())) continue;
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                result.add(model);
                continue;
            }
            model = entry.getExternalModel();
            if (model != null && this.fPluginTreeViewer.getChecked((Object)model)) {
                result.add(model);
                continue;
            }
            result.add(entry.getActiveModel());
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    private void adjustGroupState() {
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    private void createPluginViewer(Composite composite) {
        this.fPluginTreeViewer = new CheckboxTreeViewer(composite, 2048);
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModelBase) {
                    AdvancedLauncherTab.this.handleCheckStateChanged((IPluginModelBase)element, event.getChecked());
                } else {
                    AdvancedLauncherTab.this.handleGroupStateChanged(element, event.getChecked());
                }
                AdvancedLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginTreeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == AdvancedLauncherTab.this.fWorkspacePlugins) {
                    return -1;
                }
                return 0;
            }
        });
        this.fPluginTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.fWorkspacePlugins = new NamedElement(PDEPlugin.getResourceString("AdvancedLauncherTab.workspacePlugins"), pluginsImage);
        this.fExternalPlugins = new NamedElement(PDEPlugin.getResourceString("AdvancedLauncherTab.externalPlugins"), pluginsImage);
    }

    private void createButtonContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = new Button(composite, 8);
        this.fSelectAllButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.selectAll"));
        this.fSelectAllButton.setLayoutData((Object)new GridData(770));
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fDeselectButton = new Button(composite, 8);
        this.fDeselectButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.deselectAll"));
        this.fDeselectButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fDeselectButton);
        this.fAddRequiredButton = new Button(composite, 8);
        this.fAddRequiredButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.subset"));
        this.fAddRequiredButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fAddRequiredButton);
        this.fDefaultsButton = new Button(composite, 8);
        this.fDefaultsButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.defaults"));
        this.fDefaultsButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fDefaultsButton);
    }

    private void initWorkspacePluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumWorkspaceChecked = this.fWorkspaceModels.length;
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        TreeSet deselected = LauncherUtils.parseDeselectedWSIds(config);
        for (int i = 0; i < this.fWorkspaceModels.length; ++i) {
            if (!deselected.contains(this.fWorkspaceModels[i].getPluginBase().getId()) || !this.fPluginTreeViewer.setChecked((Object)this.fWorkspaceModels[i], false)) continue;
            --this.fNumWorkspaceChecked;
        }
        if (this.fNumWorkspaceChecked == 0) {
            this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, false);
        }
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    private void initExternalPluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumExternalChecked = 0;
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        TreeSet selected = LauncherUtils.parseSelectedExtIds(config);
        for (int i = 0; i < this.fExternalModels.length; ++i) {
            if (!selected.contains(this.fExternalModels[i].getPluginBase().getId()) || !this.fPluginTreeViewer.setChecked((Object)this.fExternalModels[i], true)) continue;
            ++this.fNumExternalChecked;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fUseDefaultRadio.setSelection(config.getAttribute("default", true));
            if (this.fShowFeatures) {
                this.fUseFeaturesRadio.setSelection(config.getAttribute("usefeatures", false));
                this.fUseListRadio.setSelection(!this.fUseDefaultRadio.getSelection() && !this.fUseFeaturesRadio.getSelection());
            } else {
                this.fUseListRadio.setSelection(!this.fUseDefaultRadio.getSelection());
            }
            if (this.fPluginTreeViewer.getInput() == null) {
                this.fPluginTreeViewer.setUseHashlookup(true);
                this.fPluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
                this.fPluginTreeViewer.reveal((Object)this.fWorkspacePlugins);
            }
            if (this.fUseDefaultRadio.getSelection()) {
                this.computeInitialCheckState();
            } else if (this.fUseListRadio.getSelection()) {
                this.initWorkspacePluginsState(config);
                this.initExternalPluginsState(config);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.adjustCustomControlEnableState(this.fUseListRadio.getSelection());
        this.updateStatus();
    }

    private void computeInitialCheckState() {
        IPluginModelBase model;
        int i;
        TreeSet<String> wtable = new TreeSet<String>();
        this.fNumWorkspaceChecked = 0;
        this.fNumExternalChecked = 0;
        for (i = 0; i < this.fWorkspaceModels.length; ++i) {
            model = this.fWorkspaceModels[i];
            ++this.fNumWorkspaceChecked;
            String id = model.getPluginBase().getId();
            if (id == null) continue;
            wtable.add(model.getPluginBase().getId());
        }
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        this.fNumExternalChecked = 0;
        for (i = 0; i < this.fExternalModels.length; ++i) {
            model = this.fExternalModels[i];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (masked || !model.isEnabled()) continue;
            this.fPluginTreeViewer.setChecked((Object)model, true);
            ++this.fNumExternalChecked;
        }
        this.adjustGroupState();
    }

    private void handleCheckStateChanged(IPluginModelBase model, boolean checked) {
        if (model.getUnderlyingResource() == null) {
            this.fNumExternalChecked = checked ? ++this.fNumExternalChecked : --this.fNumExternalChecked;
        } else {
            this.fNumWorkspaceChecked = checked ? ++this.fNumWorkspaceChecked : --this.fNumWorkspaceChecked;
        }
        this.adjustGroupState();
    }

    private void handleGroupStateChanged(Object group, boolean checked) {
        this.fPluginTreeViewer.setSubtreeChecked(group, checked);
        this.fPluginTreeViewer.setGrayed(group, false);
        if (group == this.fWorkspacePlugins) {
            this.fNumWorkspaceChecked = checked ? this.fWorkspaceModels.length : 0;
        } else if (group == this.fExternalPlugins) {
            this.fNumExternalChecked = checked ? this.fExternalModels.length : 0;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fShowFeatures) {
            config.setAttribute("default", true);
            config.setAttribute("usefeatures", false);
        } else {
            config.setAttribute("default", true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("default", this.fUseDefaultRadio.getSelection());
        if (this.fShowFeatures) {
            config.setAttribute("usefeatures", this.fUseFeaturesRadio.getSelection());
        }
        if (this.fUseListRadio.getSelection()) {
            StringBuffer wbuf = new StringBuffer();
            for (int i = 0; i < this.fWorkspaceModels.length; ++i) {
                IPluginModelBase model = this.fWorkspaceModels[i];
                if (this.fPluginTreeViewer.getChecked((Object)model)) continue;
                wbuf.append(model.getPluginBase().getId() + File.pathSeparatorChar);
            }
            config.setAttribute("wsproject", wbuf.toString());
            StringBuffer exbuf = new StringBuffer();
            Object[] checked = this.fPluginTreeViewer.getCheckedElements();
            for (int i = 0; i < checked.length; ++i) {
                if (!(checked[i] instanceof ExternalPluginModelBase)) continue;
                IPluginModelBase model = (IPluginModelBase)checked[i];
                exbuf.append(model.getPluginBase().getId() + File.pathSeparatorChar);
            }
            config.setAttribute("extplugins", exbuf.toString());
        } else {
            config.setAttribute("wsproject", (String)null);
            config.setAttribute("extplugins", (String)null);
        }
    }

    private void updateStatus() {
        this.updateStatus(this.validate());
    }

    private IStatus validate() {
        if (this.fShowFeatures && this.fUseFeaturesRadio.getSelection()) {
            IPath workspacePath = PDEPlugin.getWorkspace().getRoot().getLocation();
            IPath featurePath = workspacePath.removeLastSegments(1).append("features");
            if (!workspacePath.lastSegment().equalsIgnoreCase("plugins") || !featurePath.toFile().exists()) {
                return AdvancedLauncherTab.createStatus(4, PDEPlugin.getResourceString("AdvancedLauncherTab.error.featureSetup"));
            }
        }
        return AdvancedLauncherTab.createStatus(0, "");
    }

    public String getName() {
        return PDEPlugin.getResourceString("AdvancedLauncherTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    static /* synthetic */ void access$800(AdvancedLauncherTab x0) {
        x0.computeSubset();
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AdvancedLauncherTab.this.fExternalPlugins) {
                return AdvancedLauncherTab.this.fExternalModels;
            }
            if (parent == AdvancedLauncherTab.this.fWorkspacePlugins) {
                return AdvancedLauncherTab.this.fWorkspaceModels;
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{AdvancedLauncherTab.this.fWorkspacePlugins, AdvancedLauncherTab.this.fExternalPlugins};
        }
    }
}

