/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class PDEFormPage
extends FormPage {
    public PDEFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            WorkbenchHelp.displayHelpResource((String)1.access$000(this.this$1));
                        }
                    });
                }

                static /* synthetic */ String access$000(1 x0) {
                    return x0.href;
                }
            };
            helpAction.setToolTipText(PDEPlugin.getResourceString("PDEFormPage.help"));
            helpAction.setImageDescriptor(PDEPluginImages.DESC_HELP);
            manager.add((IAction)helpAction);
            form.updateToolBar();
        }
    }

    public PDEFormEditor getPDEEditor() {
        return (PDEFormEditor)this.getEditor();
    }

    protected String getHelpResource() {
        return null;
    }

    public IBaseModel getModel() {
        return this.getPDEEditor().getAggregateModel();
    }

    public void contextMenuAboutToShow(IMenuManager menu) {
    }

    protected Control getFocusControl() {
        ScrolledForm control = this.getManagedForm().getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    public boolean performGlobalAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return false;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return true;
        }
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).doGlobalAction(actionId);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).doGlobalAction(actionId);
            }
        }
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof PDESection) {
                return ((PDESection)focusPart).canPaste(clipboard);
            }
            if (focusPart instanceof PDEDetails) {
                return ((PDEDetails)focusPart).canPaste(clipboard);
            }
        }
        return false;
    }

    private AbstractFormPart getFocusSection() {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return null;
        }
        AbstractFormPart targetPart = null;
        for (Composite parent = focusControl.getParent(); parent != null; parent = parent.getParent()) {
            Object data = parent.getData("part");
            if (data == null || !(data instanceof AbstractFormPart)) continue;
            targetPart = (AbstractFormPart)data;
            break;
        }
        return targetPart;
    }

    public IPropertySheetPage getPropertySheetPage() {
        return null;
    }

    protected boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public void cancelEdit() {
        IFormPart[] parts = this.getManagedForm().getParts();
        for (int i = 0; i < parts.length; ++i) {
            IFormPart part = parts[i];
            if (!(part instanceof IContextPart)) continue;
            ((IContextPart)part).cancelEdit();
        }
    }
}

