/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class PushStaticFieldVariable
extends CompoundInstruction {
    private String fFieldName;
    private String fQualifiedTypeName;

    public PushStaticFieldVariable(String fieldName, String qualifiedTypeName, int start) {
        super(start);
        this.fFieldName = fieldName;
        this.fQualifiedTypeName = qualifiedTypeName;
    }

    public void execute() throws CoreException {
        IJavaType receiver = this.getType(this.fQualifiedTypeName);
        IJavaFieldVariable field = null;
        if (receiver instanceof IJavaInterfaceType) {
            field = ((IJavaInterfaceType)receiver).getField(this.fFieldName);
        } else if (receiver instanceof IJavaClassType) {
            field = ((IJavaClassType)receiver).getField(this.fFieldName);
        }
        if (field == null) {
            String message = MessageFormat.format(InstructionsEvaluationMessages.getString("PushStaticFieldVariable.Cannot_find_the_field_{0}_in_{1}_1"), this.fFieldName, this.fQualifiedTypeName);
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, message, null));
        }
        this.push(field);
    }

    public String toString() {
        return MessageFormat.format(InstructionsEvaluationMessages.getString("PushStaticFieldVariable.push_static_field_{0}_2"), this.fFieldName);
    }
}

