/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class SimpleMarkerAnnotation
extends Annotation {
    private IMarker fMarker;

    public SimpleMarkerAnnotation(IMarker marker) {
        this(EditorsPlugin.getDefault().getAnnotationTypeLookup().getAnnotationType(marker), marker);
    }

    public SimpleMarkerAnnotation(String annotationType, IMarker marker) {
        super(annotationType, true, null);
        Assert.isNotNull((Object)marker);
        this.fMarker = marker;
    }

    public IMarker getMarker() {
        return this.fMarker;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == ((Object)((Object)this)).getClass()) {
            return this.fMarker.equals(((SimpleMarkerAnnotation)((Object)o)).fMarker);
        }
        return false;
    }

    public int hashCode() {
        return this.fMarker.hashCode();
    }

    public void update() {
        this.updateType();
    }

    private void updateType() {
        String annotationType = EditorsPlugin.getDefault().getAnnotationTypeLookup().getAnnotationType(this.fMarker);
        if (annotationType != null && !annotationType.equals(this.getType())) {
            this.setType(annotationType);
        }
    }

    public String getText() {
        return MarkerUtilities.getMessage(this.fMarker);
    }
}

