/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.pde.internal.core.PlatformConfigurationUtils;

public class PlatformConfiguration
implements IPlatformConfiguration {
    private static PlatformConfiguration currentPlatformConfiguration = null;
    private URL configLocation;
    private HashMap sites = new HashMap();
    private HashMap externalLinkSites = new HashMap();
    private HashMap cfgdFeatures = new HashMap();
    private HashMap bootPlugins = new HashMap();
    private String defaultFeature;
    private long changeStamp;
    private boolean changeStampIsValid = false;
    private long lastFeaturesChangeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid = false;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid = false;
    private boolean transientConfig = false;
    private File cfgLockFile;
    private RandomAccessFile cfgLockFileRAF;
    private BootDescriptor runtimeDescriptor;
    private static String cmdConfiguration = null;
    private static String cmdFeature = null;
    private static String cmdApplication = null;
    private static URL cmdPlugins = null;
    private static boolean cmdInitialize = false;
    private static boolean cmdFirstUse = false;
    private static boolean cmdUpdate = false;
    private static boolean cmdNoUpdate = false;
    private static boolean cmdDev = false;
    static boolean DEBUG = false;
    private static final String RUNTIME_PLUGIN_ID = "org.eclipse.core.runtime";
    private static final String ECLIPSE = "eclipse";
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private static final String CONFIG_DIR = ".config";
    private static final String CONFIG_FILE = ".config/platform.cfg";
    private static final String CONFIG_FILE_INIT = "install.ini";
    private static final String CONFIG_FILE_LOCK_SUFFIX = ".lock";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String CHANGES_MARKER = ".newupdates";
    private static final String LINKS = "links";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String FEATURE_XML = "feature.xml";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String[] BOOTSTRAP_PLUGINS = new String[]{"org.eclipse.core.boot"};
    private static final String CFG_BOOT_PLUGIN = "bootstrap";
    private static final String CFG_SITE = "site";
    private static final String CFG_URL = "url";
    private static final String CFG_POLICY = "policy";
    private static final String[] CFG_POLICY_TYPE = new String[]{"USER-INCLUDE", "USER-EXCLUDE"};
    private static final String CFG_POLICY_TYPE_UNKNOWN = "UNKNOWN";
    private static final String CFG_LIST = "list";
    private static final String CFG_STAMP = "stamp";
    private static final String CFG_FEATURE_STAMP = "stamp.features";
    private static final String CFG_PLUGIN_STAMP = "stamp.plugins";
    private static final String CFG_UPDATEABLE = "updateable";
    private static final String CFG_LINK_FILE = "linkfile";
    private static final String CFG_FEATURE_ENTRY = "feature";
    private static final String CFG_FEATURE_ENTRY_DEFAULT = "feature.default.id";
    private static final String CFG_FEATURE_ENTRY_ID = "id";
    private static final String CFG_FEATURE_ENTRY_PRIMARY = "primary";
    private static final String CFG_FEATURE_ENTRY_VERSION = "version";
    private static final String CFG_FEATURE_ENTRY_PLUGIN_VERSION = "plugin-version";
    private static final String CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER = "plugin-identifier";
    private static final String CFG_FEATURE_ENTRY_APPLICATION = "application";
    private static final String CFG_FEATURE_ENTRY_ROOT = "root";
    private static final String INIT_DEFAULT_FEATURE_ID = "feature.default.id";
    private static final String INIT_DEFAULT_PLUGIN_ID = "feature.default.plugin.id";
    private static final String INIT_DEFAULT_FEATURE_APPLICATION = "feature.default.application";
    private static final String DEFAULT_FEATURE_ID = "org.eclipse.platform";
    private static final String DEFAULT_FEATURE_APPLICATION = "org.eclipse.ui.workbench";
    private static final String CFG_VERSION = "version";
    private static final String CFG_TRANSIENT = "transient";
    private static final String VERSION = "2.1";
    private static final String EOF = "eof";
    private static final int CFG_LIST_LENGTH = 10;
    private static final int DEFAULT_POLICY_TYPE = 1;
    private static final String[] DEFAULT_POLICY_LIST = new String[0];
    private static final String LINK_PATH = "path";
    private static final String LINK_READ = "r";
    private static final String LINK_READ_WRITE = "rw";
    private static final String CMD_CONFIGURATION = "-configuration";
    private static final String CMD_FEATURE = "-feature";
    private static final String CMD_APPLICATION = "-application";
    private static final String CMD_PLUGINS = "-plugins";
    private static final String CMD_UPDATE = "-update";
    private static final String CMD_INITIALIZE = "-initialize";
    private static final String CMD_FIRSTUSE = "-firstuse";
    private static final String CMD_NO_UPDATE = "-noupdate";
    private static final String CMD_NEW_UPDATES = "-newUpdates";
    private static final String CMD_DEV = "-dev";
    protected static final String RECONCILER_APP = "org.eclipse.update.core.reconciler";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static URL installURL;

    private PlatformConfiguration(String configArg, String metaPath, URL pluginPath) throws IOException {
        URL configURL = null;
        if (configArg != null && !configArg.trim().equals("")) {
            configURL = new URL(configArg);
        }
        boolean createRootSite = pluginPath == null;
        this.initializeCurrent(configURL, metaPath, createRootSite);
        if (pluginPath != null) {
            this.updateConfigurationFromPlugins(pluginPath);
        }
        this.loadInitializationAttributes();
        this.configureExternalLinks();
        this.validateSites();
        this.computeChangeStamp();
    }

    PlatformConfiguration(URL url) throws IOException {
        this.initialize(url);
    }

    public IPlatformConfiguration.ISiteEntry createSiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        return new SiteEntry(url, policy, this);
    }

    public IPlatformConfiguration.ISitePolicy createSitePolicy(int type, String[] list) {
        return new SitePolicy(type, list);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginVersion, primary, application, root);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, root);
    }

    public void configureSite(IPlatformConfiguration.ISiteEntry entry) {
        this.configureSite(entry, false);
    }

    public synchronized void configureSite(IPlatformConfiguration.ISiteEntry entry, boolean replace) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        if (this.sites.containsKey(key) && !replace) {
            return;
        }
        this.sites.put(key, entry);
    }

    public synchronized void unconfigureSite(IPlatformConfiguration.ISiteEntry entry) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        this.sites.remove(key);
    }

    public IPlatformConfiguration.ISiteEntry[] getConfiguredSites() {
        if (this.sites.size() == 0) {
            return new IPlatformConfiguration.ISiteEntry[0];
        }
        return this.sites.values().toArray(new IPlatformConfiguration.ISiteEntry[0]);
    }

    public IPlatformConfiguration.ISiteEntry findConfiguredSite(URL url) {
        if (url == null) {
            return null;
        }
        String key = url.toExternalForm();
        IPlatformConfiguration.ISiteEntry result = (IPlatformConfiguration.ISiteEntry)this.sites.get(key);
        try {
            if (result == null) {
                result = (IPlatformConfiguration.ISiteEntry)this.sites.get(URLDecoder.decode(key, null));
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return result;
    }

    public synchronized void configureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.cfgdFeatures.put(key, entry);
    }

    public synchronized void unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.cfgdFeatures.remove(key);
    }

    public IPlatformConfiguration.IFeatureEntry[] getConfiguredFeatureEntries() {
        if (this.cfgdFeatures.size() == 0) {
            return new IPlatformConfiguration.IFeatureEntry[0];
        }
        return this.cfgdFeatures.values().toArray(new IPlatformConfiguration.IFeatureEntry[0]);
    }

    public IPlatformConfiguration.IFeatureEntry findConfiguredFeatureEntry(String id) {
        if (id == null) {
            return null;
        }
        return (IPlatformConfiguration.IFeatureEntry)this.cfgdFeatures.get(id);
    }

    public URL getConfigurationLocation() {
        return this.configLocation;
    }

    public long getChangeStamp() {
        if (!this.changeStampIsValid) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    public long getFeaturesChangeStamp() {
        if (!this.featuresChangeStampIsValid) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    public long getPluginsChangeStamp() {
        if (!this.pluginsChangeStampIsValid) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    public String getApplicationIdentifier() {
        if (cmdInitialize) {
            return RECONCILER_APP;
        }
        if (this.featuresChangeStamp != this.lastFeaturesChangeStamp) {
            boolean update;
            boolean bl = update = !cmdNoUpdate || cmdUpdate;
            if (update) {
                return RECONCILER_APP;
            }
        }
        return this.getApplicationIdentifierInternal();
    }

    private String getApplicationIdentifierInternal() {
        IPlatformConfiguration.IFeatureEntry fe;
        if (cmdApplication != null) {
            return cmdApplication;
        }
        String feature = cmdFeature;
        if (feature == null) {
            feature = this.defaultFeature;
        }
        if (feature != null && (fe = this.findConfiguredFeatureEntry(feature)) != null && fe.getFeatureApplication() != null) {
            return fe.getFeatureApplication();
        }
        return DEFAULT_FEATURE_APPLICATION;
    }

    public String getPrimaryFeatureIdentifier() {
        if (cmdFeature != null) {
            return cmdFeature;
        }
        if (this.defaultFeature != null) {
            return this.defaultFeature;
        }
        return DEFAULT_FEATURE_ID;
    }

    public URL[] getPluginPath() {
        ArrayList<URL> path = new ArrayList<URL>();
        if (DEBUG) {
            PlatformConfiguration.debug("computed plug-in path:");
        }
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        for (int i = 0; i < sites.length; ++i) {
            String[] plugins = sites[i].getPlugins();
            for (int j = 0; j < plugins.length; ++j) {
                try {
                    URL pathURL = new URL(((SiteEntry)sites[i]).getResolvedURL(), plugins[j]);
                    path.add(pathURL);
                    if (!DEBUG) continue;
                    PlatformConfiguration.debug("   " + pathURL.toString());
                    continue;
                }
                catch (MalformedURLException e) {
                    if (!DEBUG) continue;
                    PlatformConfiguration.debug("   bad URL: " + e);
                }
            }
        }
        return path.toArray(new URL[0]);
    }

    public String[] getBootstrapPluginIdentifiers() {
        return BOOTSTRAP_PLUGINS;
    }

    public void setBootstrapPluginLocation(String id, URL location) {
        String[] ids = this.getBootstrapPluginIdentifiers();
        for (int i = 0; i < ids.length; ++i) {
            if (!ids[i].equals(id)) continue;
            this.bootPlugins.put(id, location.toExternalForm());
            break;
        }
    }

    public boolean isUpdateable() {
        return true;
    }

    public boolean isTransient() {
        return this.transientConfig;
    }

    public void isTransient(boolean value) {
    }

    public synchronized void refresh() {
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        for (int i = 0; i < sites.length; ++i) {
            ((SiteEntry)sites[i]).refresh();
        }
        this.lastFeaturesChangeStamp = this.featuresChangeStamp;
        this.changeStampIsValid = false;
        this.featuresChangeStampIsValid = false;
        this.pluginsChangeStampIsValid = false;
    }

    public void save() throws IOException {
        if (this.isUpdateable()) {
            this.save(this.configLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(URL url) throws IOException {
        boolean ok;
        if (url == null) {
            throw new IOException("Unable to save.  No URL is specified");
        }
        PrintWriter w = null;
        OutputStream os = null;
        if (!url.getProtocol().equals("file")) {
            URLConnection uc = url.openConnection();
            uc.setDoOutput(true);
            os = uc.getOutputStream();
            w = new PrintWriter(os);
            try {
                this.write(w);
            }
            finally {
                w.close();
            }
        }
        File cfigFile = new File(url.getFile().replace('/', File.separatorChar));
        File cfigDir = cfigFile.getParentFile();
        if (cfigDir != null) {
            cfigDir.mkdirs();
        }
        File cfigTmp = new File(cfigFile.getAbsolutePath() + CONFIG_FILE_TEMP_SUFFIX);
        os = new FileOutputStream(cfigTmp);
        w = new PrintWriter(os);
        try {
            this.write(w);
        }
        finally {
            w.close();
        }
        FileInputStream is = new FileInputStream(cfigTmp);
        Properties tmpProps = new Properties();
        try {
            tmpProps.load(is);
            if (!EOF.equals(tmpProps.getProperty(EOF))) {
                throw new IOException("Unable to save " + cfigTmp.getAbsolutePath());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        File cfigBak = new File(cfigFile.getAbsolutePath() + CONFIG_FILE_BAK_SUFFIX);
        cfigBak.delete();
        if (cfigFile.exists()) {
            cfigFile.renameTo(cfigBak);
        }
        if (ok = cfigTmp.renameTo(cfigFile)) {
            cfigBak.delete();
        } else {
            throw new IOException("Unable to save " + cfigTmp.getAbsolutePath());
        }
    }

    public BootDescriptor getPluginBootDescriptor(String id) {
        if (RUNTIME_PLUGIN_ID.equals(id)) {
            return this.runtimeDescriptor;
        }
        return null;
    }

    static PlatformConfiguration getCurrent() {
        return currentPlatformConfiguration;
    }

    static synchronized String[] startup(String[] cmdArgs, URL r10plugins, String r10app, String metaPath, URL installURL) throws Exception {
        PlatformConfiguration.installURL = installURL;
        cmdPlugins = r10plugins;
        cmdApplication = r10app;
        String[] passthruArgs = PlatformConfiguration.processCommandLine(cmdArgs);
        if (cmdDev) {
            cmdNoUpdate = true;
        }
        if (currentPlatformConfiguration == null) {
            currentPlatformConfiguration = new PlatformConfiguration(cmdConfiguration, metaPath, cmdPlugins);
        }
        passthruArgs = PlatformConfiguration.checkForFeatureChanges(passthruArgs, currentPlatformConfiguration);
        passthruArgs = PlatformConfiguration.checkForNewUpdates(currentPlatformConfiguration, passthruArgs);
        return passthruArgs;
    }

    static synchronized void shutdown() throws IOException {
        PlatformConfiguration config = PlatformConfiguration.getCurrent();
        if (config != null) {
            block3: {
                try {
                    config.save();
                }
                catch (IOException e) {
                    if (!DEBUG) break block3;
                    PlatformConfiguration.debug("Unable to save configuration " + e.toString());
                }
            }
            config.clearConfigurationLock();
        }
    }

    private synchronized void initializeCurrent(URL url, String metaPath, boolean createRootSite) throws IOException {
        if (cmdInitialize) {
            url = new URL(PlatformConfiguration.getInstallURL(), CONFIG_FILE);
            this.getConfigurationLock(url);
            this.resetInitializationConfiguration(url);
            if (createRootSite) {
                this.configureSite(this.getRootSite());
            }
            if (DEBUG) {
                PlatformConfiguration.debug("Initializing configuration " + url.toString());
            }
            this.configLocation = url;
            PlatformConfiguration.verifyPath(this.configLocation);
            return;
        }
        if (url != null) {
            block18: {
                this.getConfigurationLock(url);
                try {
                    this.load(url);
                    if (DEBUG) {
                        PlatformConfiguration.debug("Using configuration " + url.toString());
                    }
                }
                catch (IOException e) {
                    cmdFirstUse = true;
                    if (createRootSite) {
                        this.configureSite(this.getRootSite());
                    }
                    if (!DEBUG) break block18;
                    PlatformConfiguration.debug("Creating configuration " + url.toString());
                }
            }
            this.configLocation = url;
            PlatformConfiguration.verifyPath(this.configLocation);
            return;
        }
        URL defaultStateURL = this.getDefaultStateLocation();
        URL cfigURL = new URL(defaultStateURL, CONFIG_FILE);
        this.getConfigurationLock(cfigURL);
        try {
            this.load(cfigURL);
            this.configLocation = cfigURL;
            PlatformConfiguration.verifyPath(this.configLocation);
            if (DEBUG) {
                PlatformConfiguration.debug("Using configuration " + this.configLocation.toString());
            }
            return;
        }
        catch (IOException e) {
            cmdFirstUse = true;
            if (createRootSite) {
                try {
                    url = new URL(PlatformConfiguration.getInstallURL(), CONFIG_FILE);
                    this.load(url);
                    if (PlatformConfiguration.getInstallURL() != defaultStateURL) {
                        this.copyInitializedState(PlatformConfiguration.getInstallURL(), defaultStateURL.getFile(), CONFIG_DIR);
                    }
                    this.configLocation = cfigURL;
                    PlatformConfiguration.verifyPath(this.configLocation);
                    if (DEBUG) {
                        PlatformConfiguration.debug("Using configuration " + this.configLocation.toString());
                        PlatformConfiguration.debug("Initialized from    " + url.toString());
                    }
                    return;
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            if (createRootSite) {
                this.configureSite(this.getRootSite());
            }
            this.configLocation = cfigURL;
            PlatformConfiguration.verifyPath(this.configLocation);
            if (DEBUG) {
                PlatformConfiguration.debug("Creating configuration " + this.configLocation.toString());
            }
            return;
        }
    }

    private synchronized void initialize(URL url) throws IOException {
        if (url == null) {
            if (DEBUG) {
                PlatformConfiguration.debug("Creating empty configuration object");
            }
            return;
        }
        this.load(url);
        this.configLocation = url;
        if (DEBUG) {
            PlatformConfiguration.debug("Using configuration " + this.configLocation.toString());
        }
    }

    private IPlatformConfiguration.ISiteEntry getRootSite() {
        IPlatformConfiguration.ISitePolicy defaultPolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        URL siteURL = null;
        try {
            siteURL = new URL("platform:/base/");
        }
        catch (MalformedURLException e) {
            siteURL = PlatformConfiguration.getInstallURL();
        }
        IPlatformConfiguration.ISiteEntry defaultSite = this.createSiteEntry(siteURL, defaultPolicy);
        return defaultSite;
    }

    private void resetInitializationConfiguration(URL url) throws IOException {
        if (!PlatformConfiguration.supportsDetection(url)) {
            return;
        }
        URL resolved = PlatformConfiguration.resolvePlatformURL(url);
        File initCfg = new File(resolved.getFile().replace('/', File.separatorChar));
        File initDir = initCfg.getParentFile();
        this.resetInitializationLocation(initDir);
    }

    private void resetInitializationLocation(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                this.resetInitializationLocation(list[i]);
            }
            list[i].delete();
        }
    }

    private boolean getConfigurationLock(URL url) {
        if (this.configurationInWorkspace(url)) {
            return false;
        }
        if (!url.getProtocol().equals("file")) {
            return false;
        }
        PlatformConfiguration.verifyPath(url);
        String cfgName = url.getFile().replace('/', File.separatorChar);
        String lockName = cfgName + CONFIG_FILE_LOCK_SUFFIX;
        this.cfgLockFile = new File(lockName);
        if (this.cfgLockFile.exists()) {
            this.cfgLockFile.delete();
        }
        try {
            this.cfgLockFileRAF = new RandomAccessFile(this.cfgLockFile, LINK_READ_WRITE);
            this.cfgLockFileRAF.writeByte(0);
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private void clearConfigurationLock() {
        try {
            if (this.cfgLockFileRAF != null) {
                this.cfgLockFileRAF.close();
                this.cfgLockFileRAF = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cfgLockFile != null) {
            this.cfgLockFile.delete();
            this.cfgLockFile = null;
        }
    }

    private boolean configurationInWorkspace(URL url) {
        return true;
    }

    private void computeChangeStamp() {
        this.computeFeaturesChangeStamp();
        this.computePluginsChangeStamp();
        this.changeStamp = this.featuresChangeStamp ^ this.pluginsChangeStamp;
        this.changeStampIsValid = true;
    }

    private void computeFeaturesChangeStamp() {
        if (this.featuresChangeStampIsValid) {
            return;
        }
        long result = 0L;
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        for (int i = 0; i < sites.length; ++i) {
            result ^= sites[i].getFeaturesChangeStamp();
        }
        this.featuresChangeStamp = result;
        this.featuresChangeStampIsValid = true;
    }

    private void computePluginsChangeStamp() {
        if (this.pluginsChangeStampIsValid) {
            return;
        }
        long result = 0L;
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        for (int i = 0; i < sites.length; ++i) {
            result ^= sites[i].getPluginsChangeStamp();
        }
        this.pluginsChangeStamp = result;
        this.pluginsChangeStampIsValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void configureExternalLinks() {
        URL linkURL = PlatformConfiguration.getInstallURL();
        if (!PlatformConfiguration.supportsDetection(linkURL)) {
            return;
        }
        try {
            linkURL = new URL(linkURL, "links/");
        }
        catch (MalformedURLException e) {
            if (DEBUG) {
                PlatformConfiguration.debug("Unable to obtain link URL");
            }
            return;
        }
        File linkDir = new File(linkURL.getFile());
        File[] links = linkDir.listFiles();
        if (links == null || links.length == 0) {
            if (DEBUG) {
                PlatformConfiguration.debug("No links detected in " + linkURL.toExternalForm());
            }
            return;
        }
        for (int i = 0; i < links.length; ++i) {
            if (links[i].isDirectory()) continue;
            if (DEBUG) {
                PlatformConfiguration.debug("Link file " + links[i].getAbsolutePath());
            }
            Properties props = new Properties();
            FileInputStream is = null;
            is = new FileInputStream(links[i]);
            props.load(is);
            this.configureExternalLinkSites(links[i], props);
            Object var9_9 = null;
            if (is == null) continue;
            try {
                is.close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e) {
                    if (DEBUG) {
                        PlatformConfiguration.debug("   unable to load link file " + e);
                    }
                    var9_9 = null;
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void configureExternalLinkSites(File linkFile, Properties props) {
        URL siteURL;
        String link;
        String path = props.getProperty(LINK_PATH);
        if (path == null) {
            if (DEBUG) {
                PlatformConfiguration.debug("   no path definition");
            }
            return;
        }
        boolean updateable = true;
        IPlatformConfiguration.ISitePolicy linkSitePolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        if (path.startsWith("r ")) {
            updateable = false;
            link = path.substring(2).trim();
        } else {
            link = path.startsWith("rw ") ? path.substring(3).trim() : path;
        }
        try {
            if (!link.endsWith(File.separator)) {
                link = link + File.separator;
            }
            File target = new File(link + ECLIPSE);
            link = "file:" + target.getAbsolutePath().replace(File.separatorChar, '/');
            if (!link.endsWith("/")) {
                link = link + "/";
            }
            siteURL = new URL(link);
        }
        catch (MalformedURLException e) {
            if (DEBUG) {
                PlatformConfiguration.debug("  bad URL " + e);
            }
            return;
        }
        SiteEntry linkSite = (SiteEntry)this.externalLinkSites.get(siteURL);
        if (linkSite != null) {
            linkSite.updateable = updateable;
            linkSite.linkFileName = linkFile.getAbsolutePath();
        } else {
            linkSite = (SiteEntry)this.createSiteEntry(siteURL, linkSitePolicy);
            linkSite.updateable = updateable;
            linkSite.linkFileName = linkFile.getAbsolutePath();
        }
        this.configureSite(linkSite);
        if (DEBUG) {
            PlatformConfiguration.debug("   " + (updateable ? "R/W -> " : "R/O -> ") + siteURL.toString());
        }
    }

    private void updateConfigurationFromPlugins(URL file) throws IOException {
        URL[] pluginPath = PlatformConfigurationUtils.getPluginPath(file);
        if (pluginPath == null || pluginPath.length == 0) {
            return;
        }
        PlatformConfiguration tempConfig = new PlatformConfiguration(null);
        for (int i = 0; i < pluginPath.length; ++i) {
            IPlatformConfiguration.ISitePolicy policy;
            URL siteURL;
            String pluginPortion;
            block11: {
                String sitePortion;
                int ix;
                String entry = pluginPath[i].toExternalForm();
                if (entry.endsWith("/")) {
                    ix = PlatformConfiguration.findEntrySeparator(entry, 2);
                    sitePortion = entry.substring(0, ix + 1);
                    pluginPortion = entry.substring(ix + 1);
                    if (!pluginPortion.equals("plugins/")) continue;
                    pluginPortion = null;
                } else {
                    ix = PlatformConfiguration.findEntrySeparator(entry, 3);
                    sitePortion = entry.substring(0, ix + 1);
                    pluginPortion = entry.substring(ix + 1);
                }
                if (ix == -1) continue;
                siteURL = null;
                try {
                    siteURL = new URL(sitePortion);
                    if (!siteURL.getProtocol().equals("file")) break block11;
                    File sf = new File(siteURL.getFile());
                    String sfn = sf.getAbsolutePath().replace(File.separatorChar, '/');
                    if (!sfn.endsWith("/")) {
                        sfn = sfn + "/";
                    }
                    siteURL = new URL("file:" + sfn);
                }
                catch (MalformedURLException e) {
                    continue;
                }
            }
            IPlatformConfiguration.ISiteEntry site = tempConfig.findConfiguredSite(siteURL);
            if (site == null) {
                policy = pluginPortion == null ? tempConfig.createSitePolicy(1, null) : tempConfig.createSitePolicy(0, new String[]{pluginPortion});
                site = tempConfig.createSiteEntry(siteURL, policy);
                tempConfig.configureSite(site);
                continue;
            }
            policy = site.getSitePolicy();
            if (policy.getType() == 1) continue;
            if (pluginPortion == null) {
                policy = tempConfig.createSitePolicy(1, null);
            } else {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(policy.getList()));
                list.add(pluginPortion);
                policy = tempConfig.createSitePolicy(0, list.toArray(new String[0]));
            }
            site.setSitePolicy(policy);
        }
        IPlatformConfiguration.ISiteEntry[] tempSites = tempConfig.getConfiguredSites();
        for (int i = 0; i < tempSites.length; ++i) {
            this.configureSite(tempSites[i], true);
        }
    }

    private void validateSites() {
        SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
        for (int i = 0; i < list.length; ++i) {
            File siteRoot;
            URL siteURL = list[i].getResolvedURL();
            if (!PlatformConfiguration.supportsDetection(siteURL) || (siteRoot = new File(siteURL.getFile().replace('/', File.separatorChar))).exists()) continue;
            this.unconfigureSite(list[i]);
            if (!DEBUG) continue;
            PlatformConfiguration.debug("Site " + siteURL + " does not exist ... removing from configuration");
        }
    }

    private void copyInitializedState(URL source, String target, String dir) {
        try {
            if (!source.getProtocol().equals("file")) {
                return;
            }
            this.copy(new File(source.getFile()), new File(target), dir);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copy(File srcDir, File tgtDir, String extraPath) throws IOException {
        block24: {
            FileOutputStream os;
            FileInputStream is;
            File src = new File(srcDir, extraPath);
            File tgt = new File(tgtDir, extraPath);
            if (src.isDirectory()) {
                tgt.mkdir();
                String[] list = src.list();
                if (list == null) {
                    return;
                }
                for (int i = 0; i < list.length; ++i) {
                    this.copy(srcDir, tgtDir, extraPath + File.separator + list[i]);
                }
            } else {
                IOException e222;
                block22: {
                    is = null;
                    os = null;
                    is = new FileInputStream(src);
                    os = new FileOutputStream(tgt);
                    byte[] buff = new byte[1024];
                    int count = is.read(buff);
                    while (count != -1) {
                        os.write(buff, 0, count);
                        count = is.read(buff);
                    }
                    Object var11_13 = null;
                    if (is == null) break block22;
                    try {
                        is.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e222) {}
                }
            }
            break block24;
            {
                catch (IOException e) {
                    IOException e222;
                    Object var11_14 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var11_15 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void load(URL url) throws IOException {
        String stamp;
        if (url == null) {
            throw new IOException("Unable to load URL");
        }
        Properties props = null;
        IOException originalException = null;
        try {
            props = this.loadProperties(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                props = this.loadProperties(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException e2) {
                try {
                    props = this.loadProperties(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException e3) {
                    throw originalException;
                }
            }
        }
        String v = props.getProperty("version");
        if (!VERSION.equals(v)) {
            this.resetUpdateManagerState(url);
            throw new IOException("Bad version:" + v);
        }
        this.defaultFeature = this.loadAttribute(props, "feature.default.id", null);
        String flag = this.loadAttribute(props, CFG_TRANSIENT, null);
        if (flag != null) {
            this.transientConfig = flag.equals("true");
        }
        if ((stamp = this.loadAttribute(props, CFG_FEATURE_STAMP, null)) != null) {
            try {
                this.lastFeaturesChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String[] ids = this.getBootstrapPluginIdentifiers();
        for (int i = 0; i < ids.length; ++i) {
            this.bootPlugins.put(ids[i], this.loadAttribute(props, "bootstrap." + ids[i], null));
        }
        IPlatformConfiguration.IFeatureEntry fe = this.loadFeatureEntry(props, "feature.0", null);
        int i = 1;
        while (fe != null) {
            this.configureFeatureEntry(fe);
            fe = this.loadFeatureEntry(props, "feature." + i, null);
            ++i;
        }
        SiteEntry root = (SiteEntry)this.getRootSite();
        String rootUrlString = root.getURL().toExternalForm();
        SiteEntry se = (SiteEntry)this.loadSite(props, "site.0", null);
        int i2 = 1;
        while (se != null) {
            if (cmdFirstUse && rootUrlString.equals(se.getURL().toExternalForm())) {
                se = root;
            }
            if (!se.isExternallyLinkedSite()) {
                this.configureSite(se);
            } else {
                this.externalLinkSites.put(se.getURL(), se);
            }
            se = (SiteEntry)this.loadSite(props, "site." + i2, null);
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadProperties(URL url, String suffix) throws IOException {
        if (suffix != null && !suffix.equals("")) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + suffix);
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            props.load(is);
            if (!EOF.equals(props.getProperty(EOF))) {
                throw new IOException("Unable to load");
            }
            Object var6_5 = null;
            if (is == null) return props;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return props;
        }
        catch (IOException e) {}
        return props;
    }

    private IPlatformConfiguration.ISiteEntry loadSite(Properties props, String name, IPlatformConfiguration.ISiteEntry dflt) {
        String linkname;
        String flag;
        String[] policyList;
        int policyType;
        String urlString = this.loadAttribute(props, name + "." + CFG_URL, null);
        if (urlString == null) {
            return dflt;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return dflt;
        }
        String typeString = this.loadAttribute(props, name + "." + CFG_POLICY, null);
        if (typeString == null) {
            policyType = 1;
            policyList = DEFAULT_POLICY_LIST;
        } else {
            int i;
            for (i = 0; i < CFG_POLICY_TYPE.length && !typeString.equals(CFG_POLICY_TYPE[i]); ++i) {
            }
            if (i >= CFG_POLICY_TYPE.length) {
                policyType = 1;
                policyList = DEFAULT_POLICY_LIST;
            } else {
                policyType = i;
                policyList = this.loadListAttribute(props, name + "." + CFG_LIST, new String[0]);
            }
        }
        IPlatformConfiguration.ISitePolicy sp = this.createSitePolicy(policyType, policyList);
        SiteEntry site = (SiteEntry)this.createSiteEntry(url, sp);
        String stamp = this.loadAttribute(props, name + "." + CFG_FEATURE_STAMP, null);
        if (stamp != null) {
            try {
                site.lastFeaturesChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((stamp = this.loadAttribute(props, name + "." + CFG_PLUGIN_STAMP, null)) != null) {
            try {
                site.lastPluginsChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((flag = this.loadAttribute(props, name + "." + CFG_UPDATEABLE, null)) != null) {
            if (flag.equals("true")) {
                site.updateable = true;
            } else {
                site.updateable = false;
            }
        }
        if ((linkname = this.loadAttribute(props, name + "." + CFG_LINK_FILE, null)) != null && !linkname.equals("")) {
            site.linkFileName = linkname.replace('/', File.separatorChar);
        }
        return site;
    }

    private IPlatformConfiguration.IFeatureEntry loadFeatureEntry(Properties props, String name, IPlatformConfiguration.IFeatureEntry dflt) {
        String pluginIdentifier;
        String id = this.loadAttribute(props, name + "." + "id", null);
        if (id == null) {
            return dflt;
        }
        String version = this.loadAttribute(props, name + "." + "version", null);
        String pluginVersion = this.loadAttribute(props, name + "." + CFG_FEATURE_ENTRY_PLUGIN_VERSION, null);
        if (pluginVersion == null) {
            pluginVersion = version;
        }
        if ((pluginIdentifier = this.loadAttribute(props, name + "." + CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, null)) == null) {
            pluginIdentifier = id;
        }
        String application = this.loadAttribute(props, name + "." + CFG_FEATURE_ENTRY_APPLICATION, null);
        ArrayList<URL> rootList = new ArrayList<URL>();
        String rootString = this.loadAttribute(props, name + "." + CFG_FEATURE_ENTRY_ROOT + ".0", null);
        int i = 1;
        while (rootString != null) {
            try {
                URL rootEntry = new URL(rootString);
                rootList.add(rootEntry);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            rootString = this.loadAttribute(props, name + "." + CFG_FEATURE_ENTRY_ROOT + "." + i, null);
            ++i;
        }
        URL[] roots = rootList.toArray(new URL[0]);
        boolean primary = false;
        String flag = this.loadAttribute(props, name + "." + CFG_FEATURE_ENTRY_PRIMARY, null);
        if (flag != null && flag.equals("true")) {
            primary = true;
        }
        return this.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, roots);
    }

    private String[] loadListAttribute(Properties props, String name, String[] dflt) {
        ArrayList list = new ArrayList();
        String value = this.loadAttribute(props, name + ".0", null);
        if (value == null) {
            return dflt;
        }
        int i = 1;
        while (value != null) {
            this.loadListAttributeSegment(list, value);
            value = this.loadAttribute(props, name + "." + i, null);
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private void loadListAttributeSegment(ArrayList list, String value) {
        if (value == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.add(token);
        }
    }

    private String loadAttribute(Properties props, String name, String dflt) {
        String prop = props.getProperty(name);
        if (prop == null) {
            return dflt;
        }
        return prop.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadInitializationAttributes() {
        block18: {
            url = PlatformConfiguration.getInstallURL();
            initProps = new Properties();
            is = null;
            try {
                block17: {
                    initURL = new URL(url, "install.ini");
                    is = initURL.openStream();
                    initProps.load(is);
                    if (!PlatformConfiguration.DEBUG) break block17;
                    PlatformConfiguration.debug("Defaults from " + initURL.toExternalForm());
                }
                var6_6 = null;
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var5_12) {
                var6_8 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var5_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block18;
                catch (IOException e) {
                    var6_7 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        if ((initId = this.loadAttribute(initProps, "feature.default.id", null)) != null) {
            application = this.loadAttribute(initProps, "feature.default.application", null);
            initPluginId = this.loadAttribute(initProps, "feature.default.plugin.id", null);
            if (initPluginId == null) {
                initPluginId = initId;
            }
            if ((fe = this.findConfiguredFeatureEntry(initId)) == null) {
                PlatformConfiguration.cmdFirstUse = true;
                fe = this.createFeatureEntry(initId, null, initPluginId, null, true, application, null);
            } else {
                fe = this.createFeatureEntry(initId, fe.getFeatureVersion(), fe.getFeaturePluginIdentifier(), fe.getFeaturePluginVersion(), fe.canBePrimary(), application, fe.getFeatureRootURLs());
            }
            this.configureFeatureEntry(fe);
            this.defaultFeature = initId;
            if (PlatformConfiguration.DEBUG) {
                PlatformConfiguration.debug("    Default primary feature: " + this.defaultFeature);
                if (application != null) {
                    PlatformConfiguration.debug("    Default application    : " + application);
                }
            }
        }
    }

    private void write(PrintWriter w) {
        w.println("# " + new Date().toString());
        this.writeAttribute(w, "version", VERSION);
        if (this.transientConfig) {
            this.writeAttribute(w, CFG_TRANSIENT, "true");
        }
        w.println("");
        this.writeAttribute(w, CFG_STAMP, Long.toString(this.getChangeStamp()));
        this.writeAttribute(w, CFG_FEATURE_STAMP, Long.toString(this.getFeaturesChangeStamp()));
        this.writeAttribute(w, CFG_PLUGIN_STAMP, Long.toString(this.getPluginsChangeStamp()));
        String[] ids = this.getBootstrapPluginIdentifiers();
        for (int i = 0; i < ids.length; ++i) {
            String location = (String)this.bootPlugins.get(ids[i]);
            if (location == null) continue;
            this.writeAttribute(w, "bootstrap." + ids[i], location);
        }
        w.println("");
        this.writeAttribute(w, "feature.default.id", this.defaultFeature);
        IPlatformConfiguration.IFeatureEntry[] feats = this.getConfiguredFeatureEntries();
        for (int i = 0; i < feats.length; ++i) {
            this.writeFeatureEntry(w, "feature." + Integer.toString(i), feats[i]);
        }
        SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
        for (int i = 0; i < list.length; ++i) {
            this.writeSite(w, "site." + Integer.toString(i), list[i]);
        }
        this.writeAttribute(w, EOF, EOF);
    }

    private void writeSite(PrintWriter w, String id, SiteEntry entry) {
        w.println("");
        this.writeAttribute(w, id + "." + CFG_URL, entry.getURL().toString());
        this.writeAttribute(w, id + "." + CFG_STAMP, Long.toString(entry.getChangeStamp()));
        this.writeAttribute(w, id + "." + CFG_FEATURE_STAMP, Long.toString(entry.getFeaturesChangeStamp()));
        this.writeAttribute(w, id + "." + CFG_PLUGIN_STAMP, Long.toString(entry.getPluginsChangeStamp()));
        this.writeAttribute(w, id + "." + CFG_UPDATEABLE, entry.updateable ? "true" : "false");
        if (entry.linkFileName != null && !entry.linkFileName.trim().equals("")) {
            this.writeAttribute(w, id + "." + CFG_LINK_FILE, entry.linkFileName.trim().replace(File.separatorChar, '/'));
        }
        int type = entry.getSitePolicy().getType();
        String typeString = CFG_POLICY_TYPE_UNKNOWN;
        try {
            typeString = CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.writeAttribute(w, id + "." + CFG_POLICY, typeString);
        this.writeListAttribute(w, id + "." + CFG_LIST, entry.getSitePolicy().getList());
    }

    private void writeFeatureEntry(PrintWriter w, String id, IPlatformConfiguration.IFeatureEntry entry) {
        w.println("");
        this.writeAttribute(w, id + "." + "id", entry.getFeatureIdentifier());
        if (entry.canBePrimary()) {
            this.writeAttribute(w, id + "." + CFG_FEATURE_ENTRY_PRIMARY, "true");
        }
        this.writeAttribute(w, id + "." + "version", entry.getFeatureVersion());
        if (entry.getFeatureVersion() != null && !entry.getFeatureVersion().equals(entry.getFeaturePluginVersion())) {
            this.writeAttribute(w, id + "." + CFG_FEATURE_ENTRY_PLUGIN_VERSION, entry.getFeaturePluginVersion());
        }
        if (entry.getFeatureIdentifier() != null && !entry.getFeatureIdentifier().equals(entry.getFeaturePluginIdentifier())) {
            this.writeAttribute(w, id + "." + CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, entry.getFeaturePluginIdentifier());
        }
        this.writeAttribute(w, id + "." + CFG_FEATURE_ENTRY_APPLICATION, entry.getFeatureApplication());
        URL[] roots = entry.getFeatureRootURLs();
        for (int i = 0; i < roots.length; ++i) {
            this.writeAttribute(w, id + "." + CFG_FEATURE_ENTRY_ROOT + "." + i, roots[i].toExternalForm());
        }
    }

    private void writeListAttribute(PrintWriter w, String id, String[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        String value = "";
        int listLen = 0;
        int listIndex = 0;
        for (int i = 0; i < list.length; ++i) {
            value = listLen != 0 ? value + "," : "";
            value = value + list[i];
            if (++listLen < 10) continue;
            this.writeAttribute(w, id + "." + Integer.toString(listIndex++), value);
            listLen = 0;
        }
        if (listLen != 0) {
            this.writeAttribute(w, id + "." + Integer.toString(listIndex), value);
        }
    }

    private void writeAttribute(PrintWriter w, String id, String value) {
        if (value == null || value.trim().equals("")) {
            return;
        }
        w.println(id + "=" + this.escapedValue(value));
    }

    private String escapedValue(String value) {
        StringBuffer buf = new StringBuffer(value.length() * 2);
        for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            if (character == '\\' || character == '\t' || character == '\r' || character == '\n' || character == '\f') {
                buf.append('\\');
                buf.append(character);
                continue;
            }
            if (character < ' ' || character > '~') {
                buf.append('\\');
                buf.append('u');
                buf.append(HEX[character >> 12 & 0xF]);
                buf.append(HEX[character >> 8 & 0xF]);
                buf.append(HEX[character >> 4 & 0xF]);
                buf.append(HEX[character & 0xF]);
                continue;
            }
            buf.append(character);
        }
        return buf.toString();
    }

    private static String[] checkForFeatureChanges(String[] args, PlatformConfiguration cfg) {
        String actual;
        String original = cfg.getApplicationIdentifierInternal();
        if (original.equals(actual = cfg.getApplicationIdentifier())) {
            return args;
        }
        int newArgCnt = cmdFirstUse ? 3 : 2;
        String[] newArgs = new String[args.length + newArgCnt];
        newArgs[0] = CMD_APPLICATION;
        newArgs[1] = original;
        if (cmdFirstUse) {
            newArgs[2] = CMD_FIRSTUSE;
        }
        System.arraycopy(args, 0, newArgs, newArgCnt, args.length);
        if (DEBUG) {
            PlatformConfiguration.debug("triggering reconciliation ...");
        }
        return newArgs;
    }

    private static String[] checkForNewUpdates(IPlatformConfiguration cfg, String[] args) {
        try {
            URL markerURL = new URL(cfg.getConfigurationLocation(), CHANGES_MARKER);
            File marker = new File(markerURL.getFile());
            if (!marker.exists()) {
                return args;
            }
            marker.delete();
            String[] newArgs = new String[args.length + 1];
            newArgs[0] = CMD_NEW_UPDATES;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return newArgs;
        }
        catch (MalformedURLException e) {
            return args;
        }
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(CMD_FIRSTUSE)) {
                cmdFirstUse = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_UPDATE)) {
                cmdUpdate = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_NO_UPDATE)) {
                cmdNoUpdate = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_INITIALIZE)) {
                cmdInitialize = true;
                continue;
            }
            if (args[i].equalsIgnoreCase(CMD_DEV)) {
                cmdDev = true;
                continue;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
                continue;
            }
            if (i == args.length - 1 || args[i + 1].startsWith("-")) continue;
            String arg = args[++i];
            if (args[i - 1].equalsIgnoreCase(CMD_CONFIGURATION)) {
                found = true;
                cmdConfiguration = arg;
            }
            if (args[i - 1].equalsIgnoreCase(CMD_FEATURE)) {
                found = true;
                cmdFeature = arg;
            }
            if (args[i - 1].equalsIgnoreCase(CMD_APPLICATION)) {
                found = true;
                if (cmdApplication == null) {
                    cmdApplication = arg;
                }
            }
            if (args[i - 1].equalsIgnoreCase(CMD_PLUGINS)) {
                found = true;
                try {
                    if (cmdPlugins == null) {
                        cmdPlugins = new URL(arg);
                    }
                }
                catch (MalformedURLException e) {
                    try {
                        cmdPlugins = new URL("file:" + arg.replace(File.separatorChar, '/'));
                    }
                    catch (MalformedURLException e2) {
                        throw e;
                    }
                }
            }
            if (!found) continue;
            configArgs[configArgIndex++] = i - 1;
            configArgs[configArgIndex++] = i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            if (i == configArgs[configArgIndex]) {
                ++configArgIndex;
                continue;
            }
            passThruArgs[j++] = args[i];
        }
        return passThruArgs;
    }

    private static int findEntrySeparator(String pathEntry, int cnt) {
        for (int i = pathEntry.length() - 1; i >= 0; --i) {
            if (pathEntry.charAt(i) != '/' || --cnt != 0) continue;
            return i;
        }
        return -1;
    }

    private static boolean supportsDetection(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return true;
        }
        if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url);
            }
            catch (IOException e) {
                return false;
            }
            return resolved.getProtocol().equals("file");
        }
        return false;
    }

    private static void verifyPath(URL url) {
        File dir;
        String protocol = url.getProtocol();
        String path = null;
        if (protocol.equals("file")) {
            path = url.getFile();
        } else if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url);
                if (resolved.getProtocol().equals("file")) {
                    path = resolved.getFile();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (path != null && (dir = new File(path).getParentFile()) != null) {
            dir.mkdirs();
        }
    }

    private static URL resolvePlatformURL(URL url) throws IOException {
        if (url.getProtocol().equals("platform")) {
            URLConnection connection = url.openConnection();
            url = connection instanceof PlatformURLConnection ? ((PlatformURLConnection)connection).getResolvedURL() : PlatformConfiguration.getInstallURL();
        }
        return url;
    }

    private static void debug(String s) {
        System.out.println("PlatformConfig: " + s);
    }

    private void resetUpdateManagerState(URL url) throws IOException {
        if (!PlatformConfiguration.supportsDetection(url)) {
            return;
        }
        URL resolved = PlatformConfiguration.resolvePlatformURL(url);
        File initCfg = new File(resolved.getFile().replace('/', File.separatorChar));
        File initDir = initCfg.getParentFile();
        if (initDir == null || !initDir.exists() || !initDir.isDirectory()) {
            return;
        }
        String temp = initCfg.getName() + ".metadata";
        File UMDir = new File(initDir, temp + '/');
        if (UMDir == null || !UMDir.exists() || !UMDir.isDirectory()) {
            return;
        }
        Date now = new Date();
        boolean renamed = UMDir.renameTo(new File(initDir, temp + now.getTime() + '/'));
        if (!renamed) {
            this.resetInitializationLocation(UMDir);
        }
    }

    private static URL getInstallURL() {
        return installURL;
    }

    private URL getDefaultStateLocation() throws IOException {
        URL installURL = PlatformConfiguration.getInstallURL();
        File installDir = new File(installURL.getFile());
        if ("file".equals(installURL.getProtocol()) && installDir.canWrite()) {
            if (DEBUG) {
                PlatformConfiguration.debug("Using the installation directory.");
            }
            return installURL;
        }
        if (DEBUG) {
            PlatformConfiguration.debug("Using the user.home location.");
        }
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            String appVersion;
            Properties props = new Properties();
            props.load(new FileInputStream(eclipseProduct));
            String appId = props.getProperty("id");
            if (appId == null || appId.trim().length() == 0) {
                appId = ECLIPSE;
            }
            if ((appVersion = props.getProperty("version")) == null || appVersion.trim().length() == 0) {
                appVersion = "";
            }
            appName = appName + File.separator + appId + "_" + appVersion;
        }
        String userHome = System.getProperty("user.home");
        File configDir = new File(userHome, appName);
        configDir.mkdirs();
        return configDir.toURL();
    }

    public static class BootDescriptor {
        private String id;
        private String version;
        private String[] libs;
        private URL dir;

        public BootDescriptor(String id, String version, String[] libs, URL dir) {
            this.id = id;
            this.version = version;
            this.libs = libs;
            this.dir = dir;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String[] getLibraries() {
            return this.libs;
        }

        public URL getPluginDirectoryURL() {
            return this.dir;
        }
    }

    public static class Parser {
        private ArrayList elements = new ArrayList();

        public Parser(File file) {
            try {
                this.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Parser(URL url) {
            try {
                this.load(url.openStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public HashMap getElement(Selector selector) {
            if (selector == null) {
                return null;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                String elementName;
                int j;
                String element = (String)this.elements.get(i);
                if (!selector.select(element)) continue;
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (j = 0; j < element.length() && !Character.isWhitespace(element.charAt(j)); ++j) {
                }
                if (j >= element.length()) {
                    elementName = element;
                } else {
                    elementName = element.substring(0, j);
                    element = element.substring(j);
                    StringTokenizer t = new StringTokenizer(element, "=\"");
                    boolean isKey = true;
                    String key = "";
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken().trim();
                        if (token.equals("")) continue;
                        if (isKey) {
                            key = token;
                            isKey = false;
                            continue;
                        }
                        attributes.put(key, token);
                        isKey = true;
                    }
                }
                if (!selector.select(elementName, attributes)) continue;
                attributes.put("<element>", elementName);
                return attributes;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void load(InputStream is) {
            block11: {
                if (is == null) {
                    return;
                }
                xml = new StringBuffer(4096);
                iobuf = new char[4096];
                r = null;
                try {
                    try {
                        r = new InputStreamReader(is);
                        len = r.read(iobuf, 0, iobuf.length);
                        while (len != -1) {
                            xml.append(iobuf, 0, len);
                            len = r.read(iobuf, 0, iobuf.length);
                        }
                        var7_8 = null;
                        if (r == null) break block11;
                    }
                    catch (Exception e) {
                        var7_9 = null;
                        if (r == null) return;
                        try {
                            r.close();
                            return;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable var6_14) {
                    var7_10 = null;
                    if (r == null) throw var6_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 102->110)] { 
lbl33:
                    // 1 sources

                    r.close();
                    throw var6_14;
lbl35:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var6_14;
                }
                try {}
                catch (IOException e) {}
                r.close();
            }
            xmlString = xml.toString();
            t = new StringTokenizer(xmlString, "<>");
            while (t.hasMoreTokens() != false) {
                token = t.nextToken().trim();
                if (token.equals("")) continue;
                this.elements.add(token);
            }
        }
    }

    public static interface Selector {
        public boolean select(String var1);

        public boolean select(String var1, HashMap var2);
    }

    public class FeatureEntry
    implements IPlatformConfiguration.IFeatureEntry {
        private String id;
        private String version;
        private String pluginVersion;
        private String application;
        private URL[] root;
        private boolean primary;
        private String pluginIdentifier;

        private FeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            this.id = id;
            this.version = version;
            this.pluginVersion = pluginVersion;
            this.pluginIdentifier = pluginIdentifier;
            this.primary = primary;
            this.application = application;
            this.root = root == null ? new URL[]{} : root;
        }

        private FeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
            this(id, version, id, pluginVersion, primary, application, root);
        }

        public String getFeatureIdentifier() {
            return this.id;
        }

        public String getFeatureVersion() {
            return this.version;
        }

        public String getFeaturePluginVersion() {
            return this.pluginVersion;
        }

        public String getFeatureApplication() {
            return this.application;
        }

        public URL[] getFeatureRootURLs() {
            return this.root;
        }

        public boolean canBePrimary() {
            return this.primary;
        }

        public String getFeaturePluginIdentifier() {
            return this.pluginIdentifier;
        }
    }

    public class SitePolicy
    implements IPlatformConfiguration.ISitePolicy {
        private int type;
        private String[] list;

        private SitePolicy() {
        }

        private SitePolicy(int type, String[] list) {
            if (type != 0 && type != 1) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.list = list == null ? new String[0] : list;
        }

        public int getType() {
            return this.type;
        }

        public String[] getList() {
            return this.list;
        }

        public synchronized void setList(String[] list) {
            this.list = list == null ? new String[0] : list;
        }
    }

    public class SiteEntry
    implements IPlatformConfiguration.ISiteEntry {
        private URL url;
        private URL resolvedURL;
        private IPlatformConfiguration.ISitePolicy policy;
        private boolean updateable = true;
        private ArrayList features;
        private ArrayList plugins;
        private PlatformConfiguration parent;
        private long changeStamp;
        private boolean changeStampIsValid = false;
        private long lastFeaturesChangeStamp;
        private long featuresChangeStamp;
        private boolean featuresChangeStampIsValid = false;
        private long lastPluginsChangeStamp;
        private long pluginsChangeStamp;
        private boolean pluginsChangeStampIsValid = false;
        private String linkFileName = null;

        private SiteEntry() {
        }

        private SiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy, PlatformConfiguration parent) {
            if (url == null) {
                throw new IllegalArgumentException();
            }
            if (policy == null) {
                throw new IllegalArgumentException();
            }
            if (parent == null) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            this.policy = policy;
            this.parent = parent;
            this.features = null;
            this.plugins = null;
            this.resolvedURL = this.url;
            if (url.getProtocol().equals("platform")) {
                try {
                    this.resolvedURL = PlatformConfiguration.resolvePlatformURL(url);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        public URL getURL() {
            return this.url;
        }

        public IPlatformConfiguration.ISitePolicy getSitePolicy() {
            return this.policy;
        }

        public synchronized void setSitePolicy(IPlatformConfiguration.ISitePolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException();
            }
            this.policy = policy;
        }

        public String[] getFeatures() {
            return this.getDetectedFeatures();
        }

        public String[] getPlugins() {
            IPlatformConfiguration.ISitePolicy policy = this.getSitePolicy();
            if (policy.getType() == 0) {
                return policy.getList();
            }
            if (policy.getType() == 1) {
                ArrayList<String> detectedPlugins = new ArrayList<String>(Arrays.asList(this.getDetectedPlugins()));
                String[] excludedPlugins = policy.getList();
                for (int i = 0; i < excludedPlugins.length; ++i) {
                    if (!detectedPlugins.contains(excludedPlugins[i])) continue;
                    detectedPlugins.remove(excludedPlugins[i]);
                }
                return detectedPlugins.toArray(new String[0]);
            }
            return new String[0];
        }

        public long getChangeStamp() {
            if (!this.changeStampIsValid) {
                this.computeChangeStamp();
            }
            return this.changeStamp;
        }

        public long getFeaturesChangeStamp() {
            if (!this.featuresChangeStampIsValid) {
                this.computeFeaturesChangeStamp();
            }
            return this.featuresChangeStamp;
        }

        public long getPluginsChangeStamp() {
            if (!this.pluginsChangeStampIsValid) {
                this.computePluginsChangeStamp();
            }
            return this.pluginsChangeStamp;
        }

        public boolean isUpdateable() {
            return this.updateable;
        }

        public boolean isNativelyLinked() {
            return this.isExternallyLinkedSite();
        }

        private String[] detectFeatures() {
            this.changeStampIsValid = false;
            this.featuresChangeStampIsValid = false;
            this.parent.changeStampIsValid = false;
            this.parent.featuresChangeStampIsValid = false;
            this.features = new ArrayList();
            if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
                return new String[0];
            }
            File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File root = new File(siteRoot, PlatformConfiguration.FEATURES);
            String[] list = root.list();
            for (int i = 0; list != null && i < list.length; ++i) {
                String path = list[i] + File.separator + PlatformConfiguration.FEATURE_XML;
                File plugin = new File(root, path);
                if (!plugin.exists()) continue;
                this.features.add("features/" + path.replace(File.separatorChar, '/'));
            }
            if (DEBUG) {
                PlatformConfiguration.debug(this.resolvedURL.toString() + " located  " + this.features.size() + " feature(s)");
            }
            return this.features.toArray(new String[0]);
        }

        private String[] detectPlugins() {
            this.changeStampIsValid = false;
            this.pluginsChangeStampIsValid = false;
            this.parent.changeStampIsValid = false;
            this.parent.pluginsChangeStampIsValid = false;
            this.plugins = new ArrayList();
            if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
                return new String[0];
            }
            File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar) + PlatformConfiguration.PLUGINS);
            String[] list = root.list();
            for (int i = 0; list != null && i < list.length; ++i) {
                String path = list[i] + File.separator + PlatformConfiguration.PLUGIN_XML;
                File plugin = new File(root, path);
                if (!plugin.exists() && !(plugin = new File(root, path = list[i] + File.separator + PlatformConfiguration.FRAGMENT_XML)).exists()) continue;
                this.plugins.add("plugins/" + path.replace(File.separatorChar, '/'));
            }
            if (DEBUG) {
                PlatformConfiguration.debug(this.resolvedURL.toString() + " located  " + this.plugins.size() + " plugin(s)");
            }
            return this.plugins.toArray(new String[0]);
        }

        private synchronized String[] getDetectedFeatures() {
            if (this.features == null) {
                return this.detectFeatures();
            }
            return this.features.toArray(new String[0]);
        }

        private synchronized String[] getDetectedPlugins() {
            if (this.plugins == null) {
                return this.detectPlugins();
            }
            return this.plugins.toArray(new String[0]);
        }

        private URL getResolvedURL() {
            return this.resolvedURL;
        }

        private void computeChangeStamp() {
            this.computeFeaturesChangeStamp();
            this.computePluginsChangeStamp();
            this.changeStamp = (long)this.resolvedURL.hashCode() ^ this.featuresChangeStamp ^ this.pluginsChangeStamp;
            this.changeStampIsValid = true;
        }

        private synchronized void computeFeaturesChangeStamp() {
            if (this.featuresChangeStampIsValid) {
                return;
            }
            long start = 0L;
            if (DEBUG) {
                start = new Date().getTime();
            }
            String[] features = this.getFeatures();
            this.featuresChangeStamp = this.computeStamp(features);
            this.featuresChangeStampIsValid = true;
            if (DEBUG) {
                long end = new Date().getTime();
                PlatformConfiguration.debug(this.resolvedURL.toString() + " feature stamp: " + this.featuresChangeStamp + (this.featuresChangeStamp == this.lastFeaturesChangeStamp ? " [no changes]" : " [was " + this.lastFeaturesChangeStamp + "]") + " in " + (end - start) + "ms");
            }
        }

        private synchronized void computePluginsChangeStamp() {
            if (this.pluginsChangeStampIsValid) {
                return;
            }
            long start = 0L;
            if (DEBUG) {
                start = new Date().getTime();
            }
            String[] plugins = this.getPlugins();
            this.pluginsChangeStamp = this.computeStamp(plugins);
            this.pluginsChangeStampIsValid = true;
            if (DEBUG) {
                long end = new Date().getTime();
                PlatformConfiguration.debug(this.resolvedURL.toString() + " plugin stamp: " + this.pluginsChangeStamp + (this.pluginsChangeStamp == this.lastPluginsChangeStamp ? " [no changes]" : " [was " + this.lastPluginsChangeStamp + "]") + " in " + (end - start) + "ms");
            }
        }

        private long computeStamp(String[] targets) {
            long result = 0L;
            if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
                for (int i = 0; i < targets.length; ++i) {
                    result ^= (long)targets[i].hashCode();
                }
                if (DEBUG) {
                    PlatformConfiguration.debug("*WARNING* computing stamp using URL hashcodes only");
                }
            } else {
                File rootFile;
                String rootPath = this.resolvedURL.getFile().replace('/', File.separatorChar);
                if (!rootPath.endsWith(File.separator)) {
                    rootPath = rootPath + File.separator;
                }
                if ((rootFile = new File(rootPath)).exists()) {
                    File f = null;
                    for (int i = 0; i < targets.length; ++i) {
                        f = new File(rootFile, targets[i]);
                        if (!f.exists()) continue;
                        result ^= (long)f.getAbsolutePath().hashCode() ^ f.lastModified() ^ f.length();
                    }
                }
            }
            return result;
        }

        private boolean isExternallyLinkedSite() {
            return this.linkFileName != null && !this.linkFileName.trim().equals("");
        }

        private synchronized void refresh() {
            this.lastFeaturesChangeStamp = this.featuresChangeStamp;
            this.lastPluginsChangeStamp = this.pluginsChangeStamp;
            this.changeStampIsValid = false;
            this.featuresChangeStampIsValid = false;
            this.pluginsChangeStampIsValid = false;
            this.features = null;
            this.plugins = null;
        }
    }
}

