/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class PDEStateHelper {
    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEStateHelper.getImportedBundles(root);
        BundleDescription[] required = PDEStateHelper.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEStateHelper.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEStateHelper.getImportedByFragments(root);
        BundleDescription[] required = PDEStateHelper.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEStateHelper.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        for (int i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved()) continue;
            PDEStateHelper.merge(importedByFragments, PDEStateHelper.getImportedBundles(fragments[i]));
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        for (int i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved()) continue;
            PDEStateHelper.merge(importedByFragments, PDEStateHelper.getRequiredBundles(fragments[i]));
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List source, BundleDescription[] toAdd) {
        for (int i = 0; i < toAdd.length; ++i) {
            if (source.contains(toAdd[i])) continue;
            source.add(toAdd[i]);
        }
    }

    public static String[] getClasspath(Dictionary manifest) {
        String fullClasspath = (String)manifest.get("Bundle-ClassPath");
        String[] result = new String[]{};
        try {
            if (fullClasspath != null) {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath);
                result = new String[classpathEntries.length];
                for (int i = 0; i < classpathEntries.length; ++i) {
                    result[i] = classpathEntries[i].getValue();
                }
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return result;
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        PackageSpecification[] packages = root.getPackages();
        ArrayList<BundleDescription> resolvedImported = new ArrayList<BundleDescription>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i].isExported() || !packages[i].isResolved() || resolvedImported.contains(packages[i].getSupplier())) continue;
            resolvedImported.add(packages[i].getSupplier());
        }
        BundleDescription[] result = new BundleDescription[resolvedImported.size()];
        return resolvedImported.toArray(result);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        BundleSpecification[] required = root.getRequiredBundles();
        ArrayList<BundleDescription> resolvedRequired = new ArrayList<BundleDescription>(required.length);
        for (int i = 0; i < required.length; ++i) {
            if (!required[i].isResolved() || resolvedRequired.contains(required[i].getSupplier())) continue;
            resolvedRequired.add(required[i].getSupplier());
        }
        BundleDescription[] result = new BundleDescription[resolvedRequired.size()];
        return resolvedRequired.toArray(result);
    }
}

