/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.Messages;

public class DialogBookmarkFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;

    public DialogBookmarkFilter(Shell parentShell, BookmarkFilter filter) {
        super(parentShell, filter);
    }

    protected void createAttributesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        this.descriptionGroup = new DescriptionGroup(composite);
    }

    protected void updateFilterFromUI() {
        BookmarkFilter filter = (BookmarkFilter)this.getFilter();
        filter.setContains(this.descriptionGroup.getContains());
        filter.setDescription(this.descriptionGroup.getDescription().trim());
        super.updateFilterFromUI();
    }

    protected void updateUIFromFilter() {
        BookmarkFilter filter = (BookmarkFilter)this.getFilter();
        this.descriptionGroup.setContains(filter.getContains());
        this.descriptionGroup.setDescription(filter.getDescription());
        super.updateUIFromFilter();
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.descriptionGroup.updateEnablement();
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        super.resetPressed();
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = Messages.getString("filtersDialog.contains");
        private String doesNotContain = Messages.getString("filtersDialog.doesNotContain");

        public DescriptionGroup(Composite parent) {
            this.descriptionLabel = new Label(parent, 0);
            this.descriptionLabel.setFont(parent.getFont());
            this.descriptionLabel.setText(Messages.getString("filtersDialog.descriptionLabel"));
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener(DialogBookmarkFilter.this.selectionListener);
            this.combo.addTraverseListener(new TraverseListener(this){
                private final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.description = new Text(parent, 2052);
            this.description.setFont(parent.getFont());
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.description.setLayoutData((Object)data);
            this.description.addModifyListener(new ModifyListener(this, DialogBookmarkFilter.this){
                private final /* synthetic */ DialogBookmarkFilter val$this$0;
                private final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void modifyText(ModifyEvent e) {
                    DescriptionGroup.access$000(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean value) {
            if (value) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String text) {
            if (text == null) {
                this.description.setText("");
            } else {
                this.description.setText(text);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement() {
            this.descriptionLabel.setEnabled(DialogBookmarkFilter.this.isFilterEnabled());
            this.combo.setEnabled(DialogBookmarkFilter.this.isFilterEnabled());
            this.description.setEnabled(DialogBookmarkFilter.this.isFilterEnabled());
        }

        static /* synthetic */ DialogBookmarkFilter access$000(DescriptionGroup x0) {
            return x0.DialogBookmarkFilter.this;
        }
    }
}

