/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkPropertiesDialog;

class EditBookmarkAction
extends BookmarkAction {
    private IMarker marker;

    protected EditBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.getString("Properties.text"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.bookmark_properties_action_context");
        this.setEnabled(false);
    }

    public void run() {
        if (this.marker != null) {
            this.editBookmark();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.marker = null;
        this.setEnabled(false);
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (!(o instanceof IMarker)) {
            return;
        }
        IMarker selectedMarker = (IMarker)o;
        IResource resource = selectedMarker.getResource();
        if (resource instanceof IFile) {
            this.marker = selectedMarker;
            this.setEnabled(true);
        }
    }

    private void editBookmark() {
        IFile file = (IFile)this.marker.getResource();
        try {
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BookmarkPropertiesDialog dialog = new BookmarkPropertiesDialog(EditBookmarkAction.this.getView().getSite().getShell());
                    dialog.setMarker(EditBookmarkAction.this.marker);
                    dialog.open();
                }
            }, null);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(null, e.getStatus());
        }
    }
}

