/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ResourceTransfer
extends ByteArrayTransfer {
    private static final ResourceTransfer instance = new ResourceTransfer();
    private static final String TYPE_NAME = "resource-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = ResourceTransfer.registerType((String)TYPE_NAME);
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();

    private ResourceTransfer() {
    }

    public static ResourceTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IResource[])) {
            return;
        }
        IResource[] resources = (IResource[])data;
        int resourceCount = resources.length;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(resourceCount);
            for (int i = 0; i < resources.length; ++i) {
                this.writeResource(dataOut, resources[i]);
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IResource[] results = new IResource[count];
            for (int i = 0; i < count; ++i) {
                results[i] = this.readResource(in);
            }
            return results;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IResource readResource(DataInputStream dataIn) throws IOException {
        int type = dataIn.readInt();
        String path = dataIn.readUTF();
        switch (type) {
            case 2: {
                return this.workspace.getRoot().getFolder((IPath)new Path(path));
            }
            case 1: {
                return this.workspace.getRoot().getFile((IPath)new Path(path));
            }
            case 4: {
                return this.workspace.getRoot().getProject(path);
            }
        }
        throw new IllegalArgumentException("Unknown resource type in ResourceTransfer.readResource");
    }

    private void writeResource(DataOutputStream dataOut, IResource resource) throws IOException {
        dataOut.writeInt(resource.getType());
        dataOut.writeUTF(resource.getFullPath().toString());
    }
}

