/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class PropertyParser
extends DefaultHandler
implements LexicalHandler {
    private static SAXParser parser;
    private static SAXParserFactory parserFactory;
    private IResource parseResource = null;
    int x = this.initializeParser();

    private int initializeParser() {
        try {
            parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            try {
                parserFactory.setFeature("http://xml.org/sax/features/string-interning", true);
                parserFactory.setValidating(false);
            }
            catch (SAXException e) {
                IDEWorkbenchPlugin.log("Problem initializing parser", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Problem initializing parser", (Throwable)e));
            }
            parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log("Problem initializing parser", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Problem initializing parser", (Throwable)e));
        }
        return 1;
    }

    public synchronized void parseResource(IResource resource) throws Exception {
        block7: {
            if (resource == null) {
                return;
            }
            this.parseResource = resource;
            IPath location = resource.getLocation();
            if (location == null) {
                return;
            }
            File file = location.toFile();
            if (file.length() == 0L) {
                long modTime = this.parseResource.getModificationStamp();
                QualifiedName modKey = new QualifiedName("org.eclipse.ui.ide", "xmlLastMod");
                try {
                    this.parseResource.setPersistentProperty(modKey, new Long(modTime).toString());
                }
                catch (CoreException c) {
                    IDEWorkbenchPlugin.log("Problem parsing element", c.getStatus());
                }
                return;
            }
            try {
                parser.parse(file, (DefaultHandler)this);
            }
            catch (SAXException s) {
                if (s.getMessage().equals("PropertyParser stop")) break block7;
                IDEWorkbenchPlugin.log("Problem parsing file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, "Problem parsing file", (Throwable)s));
            }
        }
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
        long modTime = this.parseResource.getModificationStamp();
        QualifiedName modKey = new QualifiedName("org.eclipse.ui.ide", "xmlLastMod");
        try {
            this.parseResource.setPersistentProperty(modKey, new Long(modTime).toString());
        }
        catch (CoreException c) {
            IDEWorkbenchPlugin.log("Problem parsing element", c.getStatus());
        }
        String propertyName = "xmlFirstTag";
        QualifiedName key = new QualifiedName("org.eclipse.ui.ide", propertyName);
        try {
            this.parseResource.setPersistentProperty(key, elementName);
        }
        catch (CoreException c) {
            IDEWorkbenchPlugin.log("Problem parsing element", c.getStatus());
        }
        throw new SAXException("PropertyParser stop");
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (systemId == null) {
            return;
        }
        QualifiedName qname = new QualifiedName("org.eclipse.ui.ide", "xmlDTDName");
        try {
            this.parseResource.setPersistentProperty(qname, systemId);
        }
        catch (CoreException c) {
            IDEWorkbenchPlugin.log("Problem parsing dtd element", c.getStatus());
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }
}

