/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private Shell shell;
    private boolean deleteContent = false;
    private boolean forceOutOfSyncDelete = false;

    public DeleteResourceAction(Shell shell) {
        super(IDEWorkbenchMessages.getString("DeleteResourceAction.text"));
        this.setToolTipText(IDEWorkbenchMessages.getString("DeleteResourceAction.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    private boolean canDelete(IResource[] resources) {
        if (!this.containsOnlyProjects(resources) && !this.containsOnlyNonProjects(resources)) {
            return false;
        }
        if (resources.length == 0) {
            return false;
        }
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (!resource.isPhantom()) continue;
            return false;
        }
        return true;
    }

    private boolean containsLinkedResource(IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (!resource.isLinked()) continue;
            return true;
        }
        return false;
    }

    private boolean containsOnlyNonProjects(IResource[] resources) {
        int types = this.getSelectedResourceTypes(resources);
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    private boolean containsOnlyProjects(IResource[] resources) {
        int types = this.getSelectedResourceTypes(resources);
        return types == 4;
    }

    private boolean confirmDelete(IResource[] resources) {
        if (this.containsOnlyProjects(resources)) {
            return this.confirmDeleteProjects(resources);
        }
        return this.confirmDeleteNonProjects(resources);
    }

    private boolean confirmDeleteNonProjects(IResource[] resources) {
        String msg;
        String title;
        if (resources.length == 1) {
            title = IDEWorkbenchMessages.getString("DeleteResourceAction.title1");
            IResource resource = resources[0];
            msg = resource.isLinked() ? IDEWorkbenchMessages.format("DeleteResourceAction.confirmLinkedResource1", new Object[]{resource.getName()}) : IDEWorkbenchMessages.format("DeleteResourceAction.confirm1", new Object[]{resource.getName()});
        } else {
            title = IDEWorkbenchMessages.getString("DeleteResourceAction.titleN");
            msg = this.containsLinkedResource(resources) ? IDEWorkbenchMessages.format("DeleteResourceAction.confirmLinkedResourceN", new Object[]{new Integer(resources.length)}) : IDEWorkbenchMessages.format("DeleteResourceAction.confirmN", new Object[]{new Integer(resources.length)});
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)msg);
    }

    private boolean confirmDeleteProjects(IResource[] resources) {
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.shell, resources);
        int code = dialog.open();
        this.deleteContent = dialog.getDeleteContent();
        return code == 0;
    }

    private void delete(IResource[] resourcesToDelete, IProgressMonitor monitor) throws CoreException {
        ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
        this.forceOutOfSyncDelete = false;
        monitor.beginTask("", resourcesToDelete.length);
        for (int i = 0; i < resourcesToDelete.length; ++i) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                this.delete(resourcesToDelete[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                continue;
            }
            catch (CoreException e) {
                exceptions.add(e);
            }
        }
        int exceptionCount = exceptions.size();
        if (exceptionCount == 1) {
            throw (CoreException)((Object)exceptions.get(0));
        }
        if (exceptionCount > 1) {
            MultiStatus multi = new MultiStatus("org.eclipse.ui.ide", 0, IDEWorkbenchMessages.getString("DeleteResourceAction.deletionExceptionMessage"), (Throwable)new Exception());
            for (int i = 0; i < exceptionCount; ++i) {
                CoreException exception = (CoreException)((Object)exceptions.get(0));
                IStatus status = exception.getStatus();
                multi.add((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), (Throwable)exception));
            }
            throw new CoreException((IStatus)multi);
        }
        monitor.done();
    }

    private void delete(IResource resourceToDelete, IProgressMonitor monitor) throws CoreException {
        boolean force = false;
        try {
            if (resourceToDelete.getType() == 4) {
                IProject project = (IProject)resourceToDelete;
                project.delete(this.deleteContent, force, monitor);
            } else {
                resourceToDelete.delete(2, monitor);
            }
        }
        catch (CoreException exception) {
            if (resourceToDelete.getType() == 1) {
                IStatus[] children = exception.getStatus().getChildren();
                if (children.length == 1 && children[0].getCode() == 274) {
                    if (this.forceOutOfSyncDelete) {
                        resourceToDelete.delete(3, monitor);
                    } else {
                        int result = this.queryDeleteOutOfSync(resourceToDelete);
                        if (result == 2) {
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 4) {
                            this.forceOutOfSyncDelete = true;
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                throw exception;
            }
            throw exception;
        }
    }

    private IResource[] getSelectedResourcesArray() {
        List selection = this.getSelectedResources();
        IResource[] resources = new IResource[selection.size()];
        selection.toArray(resources);
        return resources;
    }

    private int getSelectedResourceTypes(IResource[] resources) {
        int types = 0;
        for (int i = 0; i < resources.length; ++i) {
            types |= resources[i].getType();
        }
        return types;
    }

    public void run() {
        IResource[] resources = this.getSelectedResourcesArray();
        if (!this.confirmDelete(resources)) {
            return;
        }
        final IResource[] resourcesToDelete = this.getResourcesToDelete(resources);
        if (resourcesToDelete.length == 0) {
            return;
        }
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    DeleteResourceAction.this.delete(resourcesToDelete, monitor);
                }
            };
            new ProgressMonitorJobsDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                CoreException exception = (CoreException)t;
                IStatus status = exception.getStatus();
                IStatus[] children = status.getChildren();
                boolean outOfSyncError = false;
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].getCode() != 274) continue;
                    outOfSyncError = true;
                    break;
                }
                IDEWorkbenchPlugin.log(MessageFormat.format("Exception in {0}.run: {1}", ((Object)((Object)this)).getClass().getName(), t), status);
                if (outOfSyncError) {
                    ErrorDialog.openError((Shell)this.shell, (String)IDEWorkbenchMessages.getString("DeleteResourceAction.errorTitle"), (String)IDEWorkbenchMessages.getString("DeleteResourceAction.outOfSyncError"), (IStatus)status);
                } else {
                    ErrorDialog.openError((Shell)this.shell, (String)IDEWorkbenchMessages.getString("DeleteResourceAction.errorTitle"), null, (IStatus)status);
                }
            } else {
                IDEWorkbenchPlugin.log(MessageFormat.format("Exception in {0}.run: {1}", ((Object)((Object)this)).getClass().getName(), t));
                MessageDialog.openError((Shell)this.shell, (String)IDEWorkbenchMessages.getString("DeleteResourceAction.messageTitle"), (String)IDEWorkbenchMessages.format("DeleteResourceAction.internalError", new Object[]{t.getMessage()}));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IResource[] getResourcesToDelete(IResource[] resources) {
        if (this.containsOnlyProjects(resources) && !this.deleteContent) {
            return resources;
        }
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.shell, IDEWorkbenchMessages.getString("DeleteResourceAction.title1"), IDEWorkbenchMessages.getString("DeleteResourceAction.readOnlyQuestion"));
        return checker.checkReadOnlyResources(resources);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete(this.getSelectedResourcesArray());
    }

    private int queryDeleteOutOfSync(IResource resource) {
        final MessageDialog dialog = new MessageDialog(this.shell, IDEWorkbenchMessages.getString("DeleteResourceAction.messageTitle"), null, IDEWorkbenchMessages.format("DeleteResourceAction.outOfSyncQuestion", new Object[]{resource.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        if (result == 2) {
            return 3;
        }
        return 1;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private IResource[] projects;
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            private final /* synthetic */ DeleteProjectDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$002(this.this$0, button == DeleteProjectDialog.access$100(this.this$0));
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, IResource[] projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = projects;
        }

        static String getTitle(IResource[] projects) {
            if (projects.length == 1) {
                return IDEWorkbenchMessages.getString("DeleteResourceAction.titleProject1");
            }
            return IDEWorkbenchMessages.getString("DeleteResourceAction.titleProjectN");
        }

        static String getMessage(IResource[] projects) {
            if (projects.length == 1) {
                IProject project = (IProject)projects[0];
                return IDEWorkbenchMessages.format("DeleteResourceAction.confirmProject1", new Object[]{project.getName()});
            }
            return IDEWorkbenchMessages.format("DeleteResourceAction.confirmProjectN", new Object[]{new Integer(projects.length)});
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            IProject project;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = this.projects.length == 1 ? ((project = (IProject)this.projects[0]) == null || project.getLocation() == null ? IDEWorkbenchMessages.getString("DeleteResourceAction.deleteContentsN") : IDEWorkbenchMessages.format("DeleteResourceAction.deleteContents1", new Object[]{project.getLocation().toOSString()})) : IDEWorkbenchMessages.getString("DeleteResourceAction.deleteContentsN");
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = IDEWorkbenchMessages.getString("DeleteResourceAction.doNotDeleteContents");
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ boolean access$002(DeleteProjectDialog x0, boolean x1) {
            x0.deleteContent = x1;
            return x0.deleteContent;
        }

        static /* synthetic */ Button access$100(DeleteProjectDialog x0) {
            return x0.radio1;
        }
    }
}

