/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class CopyFilesAndFoldersOperation {
    private MultiStatus errorStatus;
    private Shell parentShell;
    private boolean canceled = false;
    private boolean alwaysOverwrite = false;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;

    static IPath getAutoNewNameFor(IPath originalName, IWorkspace workspace) {
        int counter = 1;
        String resourceName = originalName.lastSegment();
        IPath leadupSegment = originalName.removeLastSegments(1);
        while (true) {
            String nameSegment = counter > 1 ? IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.copyNameTwoArgs", new Object[]{new Integer(counter), resourceName}) : IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.copyNameOneArg", new Object[]{resourceName});
            IPath pathToTry = leadupSegment.append(nameSegment);
            if (!workspace.getRoot().exists(pathToTry)) {
                return pathToTry;
            }
            ++counter;
        }
    }

    public CopyFilesAndFoldersOperation(Shell shell) {
        this.parentShell = shell;
    }

    protected boolean canPerformAutoRename() {
        return true;
    }

    protected String getDeepCheckQuestion(IResource source) {
        return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.deepCopyQuestion", new Object[]{source.getFullPath().makeRelative()});
    }

    IStatus checkExist(String[] names) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        for (int i = 0; i < names.length; ++i) {
            Path path = new Path(names[i]);
            File file = path.toFile();
            if (file == null || file.exists()) continue;
            String message = IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.resourceDeleted", new Object[]{file.getName()});
            Status status = new Status(4, "org.eclipse.ui", 0, message, null);
            multiStatus.add((IStatus)status);
        }
        return multiStatus;
    }

    IStatus checkExist(IResource[] resources) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        for (int i = 0; i < resources.length; ++i) {
            File file;
            IResource resource = resources[i];
            if (resource == null) continue;
            IPath location = resource.getLocation();
            String message = null;
            if (location != null && !(file = location.toFile()).exists()) {
                message = resource.isLinked() ? IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.missingLinkTarget", new Object[]{resource.getName()}) : IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.resourceDeleted", new Object[]{resource.getName()});
            }
            if (message == null) continue;
            Status status = new Status(4, "org.eclipse.ui", 0, message, null);
            multiStatus.add((IStatus)status);
        }
        return multiStatus;
    }

    private int checkOverwrite(final Shell shell, final IResource source, final IResource destination) {
        final int[] result = new int[1];
        Runnable query = new Runnable(){

            public void run() {
                String message;
                int[] resultId = new int[]{2, 4, 3, 1};
                String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                if (destination.getType() == 2) {
                    if (CopyFilesAndFoldersOperation.this.homogenousResources(source, destination)) {
                        message = IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.overwriteMergeQuestion", new Object[]{destination.getFullPath().makeRelative()});
                    } else {
                        message = destination.isLinked() ? IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.overwriteNoMergeLinkQuestion", new Object[]{destination.getFullPath().makeRelative()}) : IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.overwriteNoMergeNoLinkQuestion", new Object[]{destination.getFullPath().makeRelative()});
                        resultId = new int[]{2, 3, 1};
                        labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                } else {
                    message = IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.overwriteQuestion", new Object[]{destination.getFullPath().makeRelative()});
                }
                MessageDialog dialog = new MessageDialog(shell, IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.resourceExists"), null, message, 3, labels, 0);
                dialog.open();
                result[0] = resultId[dialog.getReturnCode()];
            }
        };
        shell.getDisplay().syncExec(query);
        return result[0];
    }

    private void collectExistingReadonlyFiles(IPath destinationPath, IResource[] copyResources, ArrayList existing) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < copyResources.length; ++i) {
            IFile sourceFile;
            IResource source = copyResources[i];
            IPath newDestinationPath = destinationPath.append(source.getName());
            IResource newDestination = workspaceRoot.findMember(newDestinationPath);
            if (newDestination == null) continue;
            IFolder folder = this.getFolder(newDestination);
            if (folder != null) {
                IFolder sourceFolder = this.getFolder(source);
                if (sourceFolder == null) continue;
                try {
                    this.collectExistingReadonlyFiles(newDestinationPath, sourceFolder.members(), existing);
                }
                catch (CoreException exception) {
                    this.recordError(exception);
                }
                continue;
            }
            IFile file = this.getFile(newDestination);
            if (file == null) continue;
            if (file.isReadOnly()) {
                existing.add(file);
            }
            if (!this.getValidateConflictSource() || (sourceFile = this.getFile(source)) == null) continue;
            existing.add(sourceFile);
        }
    }

    protected void copy(IResource[] resources, IPath destination, IProgressMonitor subMonitor) throws CoreException {
        for (int i = 0; i < resources.length; ++i) {
            IResource source = resources[i];
            IPath destinationPath = destination.append(source.getName());
            IWorkspace workspace = source.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (source.getType() == 2 && existing != null) {
                if (this.homogenousResources(source, existing)) {
                    IResource[] children = ((IContainer)source).members();
                    this.copy(children, destinationPath, subMonitor);
                    continue;
                }
                this.delete(existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                continue;
            }
            if (existing != null) {
                if (this.homogenousResources(source, existing)) {
                    this.copyExisting(source, existing, subMonitor);
                } else {
                    this.delete(existing, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                    source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
                }
            } else {
                source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
            }
            subMonitor.worked(1);
            if (!subMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    private void copyExisting(IResource source, IResource existing, IProgressMonitor subMonitor) throws CoreException {
        IFile sourceFile;
        IFile existingFile = this.getFile(existing);
        if (existingFile != null && (sourceFile = this.getFile(source)) != null) {
            existingFile.setContents(sourceFile.getContents(), 2, (IProgressMonitor)new SubProgressMonitor(subMonitor, 0));
        }
    }

    public IResource[] copyResources(final IResource[] resources, IContainer destination) {
        final IPath destinationPath = destination.getFullPath();
        final IResource[][] copiedResources = new IResource[1][0];
        IStatus resourceStatus = this.checkExist(resources);
        if (resourceStatus.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.parentShell, (String)this.getProblemsTitle(), null, (IStatus)resourceStatus);
            return copiedResources[0];
        }
        String errorMsg = this.validateDestination(destination, resources);
        if (errorMsg != null) {
            this.displayError(errorMsg);
            return copiedResources[0];
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                IResource[] copyResources = resources;
                monitor.beginTask("", 100);
                monitor.setTaskName(CopyFilesAndFoldersOperation.this.getOperationTitle());
                monitor.worked(10);
                boolean copyWithAutoRename = false;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (root.exists(destinationPath)) {
                    IContainer container = (IContainer)root.findMember(destinationPath);
                    if (CopyFilesAndFoldersOperation.this.isDestinationSameAsSource(copyResources, container) && CopyFilesAndFoldersOperation.this.canPerformAutoRename()) {
                        copyWithAutoRename = true;
                    } else {
                        if ((copyResources = CopyFilesAndFoldersOperation.this.validateNoNameCollisions(container, copyResources, monitor)) == null) {
                            if (CopyFilesAndFoldersOperation.this.canceled) {
                                return;
                            }
                            CopyFilesAndFoldersOperation.this.displayError(IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.nameCollision"));
                            return;
                        }
                        if (!CopyFilesAndFoldersOperation.this.validateEdit(container, copyResources)) {
                            return;
                        }
                    }
                }
                CopyFilesAndFoldersOperation.this.errorStatus = null;
                if (copyResources.length > 0) {
                    if (copyWithAutoRename) {
                        CopyFilesAndFoldersOperation.this.performCopyWithAutoRename(copyResources, destinationPath, monitor);
                    } else {
                        CopyFilesAndFoldersOperation.this.performCopy(copyResources, destinationPath, monitor);
                    }
                }
                copiedResources[0] = copyResources;
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.parentShell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return copiedResources[0];
        }
        catch (InvocationTargetException e) {
            Platform.getPlugin((String)"org.eclipse.ui").getLog().log(StatusUtil.newStatus(4, MessageFormat.format("Exception in {0}.performCopy(): {1}", this.getClass().getName(), e.getTargetException()), null));
            this.displayError(IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.internalError", new Object[]{e.getTargetException().getMessage()}));
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.parentShell, (String)this.getProblemsTitle(), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
        return copiedResources[0];
    }

    public void copyFiles(final String[] fileNames, IContainer destination) {
        this.alwaysOverwrite = false;
        IStatus fileStatus = this.checkExist(fileNames);
        if (fileStatus.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.parentShell, (String)this.getProblemsTitle(), null, (IStatus)fileStatus);
            return;
        }
        String errorMsg = this.validateImportDestination(destination, fileNames);
        if (errorMsg != null) {
            this.displayError(errorMsg);
            return;
        }
        final IPath destinationPath = destination.getFullPath();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (root.exists(destinationPath)) {
                    IContainer container = (IContainer)root.findMember(destinationPath);
                    CopyFilesAndFoldersOperation.this.performFileImport(CopyFilesAndFoldersOperation.this.getFiles(fileNames), container, monitor);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.parentShell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return;
        }
        catch (InvocationTargetException e) {
            Platform.getPlugin((String)"org.eclipse.ui").getLog().log(StatusUtil.newStatus(4, MessageFormat.format("Exception in {0}.performCopy(): {1}", this.getClass().getName(), e.getTargetException()), null));
            this.displayError(IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.internalError", new Object[]{e.getTargetException().getMessage()}));
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.parentShell, (String)this.getProblemsTitle(), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    IResource createLinkedResourceHandle(IContainer destination, IResource source) {
        IWorkspace workspace = destination.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IPath linkPath = destination.getFullPath().append(source.getName());
        Object linkHandle = source.getType() == 2 ? workspaceRoot.getFolder(linkPath) : workspaceRoot.getFile(linkPath);
        return linkHandle;
    }

    boolean delete(IResource resource, IProgressMonitor monitor) throws CoreException {
        boolean force = false;
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            try {
                project.delete(true, force, monitor);
            }
            catch (CoreException e) {
                this.recordError(e);
                return false;
            }
        }
        int flags = 2;
        if (force) {
            flags |= 1;
        }
        try {
            resource.delete(flags, monitor);
        }
        catch (CoreException e) {
            this.recordError(e);
            return false;
        }
        return true;
    }

    private void displayError(final String message) {
        this.parentShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)CopyFilesAndFoldersOperation.this.parentShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)message);
            }
        });
    }

    protected IFile getFile(IResource resource) {
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        if (resource instanceof IAdaptable) {
            return (IFile)resource.getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = CopyFilesAndFoldersOperation.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
        }
        return null;
    }

    protected File[] getFiles(String[] fileNames) {
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    protected IFolder getFolder(IResource resource) {
        if (resource instanceof IFolder) {
            return (IFolder)resource;
        }
        if (resource instanceof IAdaptable) {
            return (IFolder)resource.getAdapter(class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = CopyFilesAndFoldersOperation.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder);
        }
        return null;
    }

    private IPath getNewNameFor(final IPath originalName, final IWorkspace workspace) {
        final IResource resource = workspace.getRoot().findMember(originalName);
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        final String[] returnValue = new String[]{""};
        this.parentShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                IInputValidator validator = new IInputValidator(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String isValid(String string) {
                        if (5.access$900(this.this$1).getName().equals(string)) {
                            return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.nameMustBeDifferent");
                        }
                        IStatus status = 5.access$1000(this.this$1).validateName(string, 5.access$900(this.this$1).getType());
                        if (!status.isOK()) {
                            return status.getMessage();
                        }
                        if (5.access$1000(this.this$1).getRoot().exists(5.access$1100(this.this$1).append(string))) {
                            return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.nameExists");
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(CopyFilesAndFoldersOperation.this.parentShell, IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.inputDialogTitle"), IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.inputDialogMessage", new String[]{resource.getName()}), CopyFilesAndFoldersOperation.getAutoNewNameFor(originalName, workspace).lastSegment().toString(), validator);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }

            static /* synthetic */ IResource access$900(5 x0) {
                return x0.resource;
            }

            static /* synthetic */ IWorkspace access$1000(5 x0) {
                return x0.workspace;
            }

            static /* synthetic */ IPath access$1100(5 x0) {
                return x0.prefix;
            }
        });
        if (returnValue[0] == null) {
            throw new OperationCanceledException();
        }
        return prefix.append(returnValue[0]);
    }

    protected String getOperationTitle() {
        return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.operationTitle");
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.problemMessage");
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.copyFailedTitle");
    }

    protected boolean getValidateConflictSource() {
        return false;
    }

    protected boolean homogenousResources(IResource source, IResource destination) {
        boolean isSourceLinked = source.isLinked();
        boolean isDestinationLinked = destination.isLinked();
        return isSourceLinked && isDestinationLinked || !isSourceLinked && !isDestinationLinked;
    }

    private boolean isAccessible(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return ((IProject)resource).isOpen();
            }
        }
        return false;
    }

    boolean isDestinationSameAsSource(IResource[] sourceResources, IContainer destination) {
        IPath destinationLocation = destination.getLocation();
        for (int i = 0; i < sourceResources.length; ++i) {
            IResource sourceResource = sourceResources[i];
            if (sourceResource.getParent().equals(destination)) {
                return true;
            }
            if (destinationLocation == null) continue;
            IPath sourceLocation = sourceResource.getLocation();
            IPath destinationResource = destinationLocation.append(sourceResource.getName());
            if (sourceLocation == null || !sourceLocation.isPrefixOf(destinationResource)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performCopy(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        try {
            ContainerGenerator generator = new ContainerGenerator(destination);
            generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 75);
            this.copy(resources, destination, (IProgressMonitor)subMonitor);
        }
        catch (CoreException e) {
            this.recordError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.done();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performCopyWithAutoRename(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            ContainerGenerator generator = new ContainerGenerator(destination);
            generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 75);
            subMonitor.beginTask(this.getOperationTitle(), resources.length);
            for (int i = 0; i < resources.length; ++i) {
                IResource source = resources[i];
                IPath destinationPath = destination.append(source.getName());
                if (workspace.getRoot().exists(destinationPath)) {
                    destinationPath = this.getNewNameFor(destinationPath, workspace);
                }
                if (destinationPath != null) {
                    try {
                        source.copy(destinationPath, 32, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 0));
                    }
                    catch (CoreException e) {
                        this.recordError(e);
                        boolean bl = false;
                        monitor.done();
                        return bl;
                    }
                }
                subMonitor.worked(1);
                if (!subMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        catch (CoreException e) {
            this.recordError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.done();
        }
        return true;
    }

    private void performFileImport(File[] files, IContainer target, IProgressMonitor monitor) {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                if (CopyFilesAndFoldersOperation.this.alwaysOverwrite) {
                    return "ALL";
                }
                String[] returnCode = new String[]{"CANCEL"};
                String msg = IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.overwriteQuestion", new Object[]{pathString});
                String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                CopyFilesAndFoldersOperation.this.parentShell.getDisplay().syncExec(new Runnable(this, msg, options, returnCode){
                    private final /* synthetic */ String val$msg;
                    private final /* synthetic */ String[] val$options;
                    private final /* synthetic */ String[] val$returnCode;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$msg = val$msg;
                        this.val$options = val$options;
                        this.val$returnCode = val$returnCode;
                    }

                    public void run() {
                        MessageDialog dialog = new MessageDialog(CopyFilesAndFoldersOperation.access$800(7.access$1300(this.this$1)), IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.question"), null, this.val$msg, 3, this.val$options, 0);
                        dialog.open();
                        int returnVal = dialog.getReturnCode();
                        String[] returnCodes = new String[]{"YES", "ALL", "NO", "CANCEL"};
                        this.val$returnCode[0] = returnVal == -1 ? "CANCEL" : returnCodes[returnVal];
                    }
                });
                if (returnCode[0] == "ALL") {
                    CopyFilesAndFoldersOperation.this.alwaysOverwrite = true;
                } else if (returnCode[0] == "CANCEL") {
                    CopyFilesAndFoldersOperation.this.canceled = true;
                }
                return returnCode[0];
            }

            static /* synthetic */ CopyFilesAndFoldersOperation access$1300(7 x0) {
                return x0.CopyFilesAndFoldersOperation.this;
            }
        };
        ImportOperation op = new ImportOperation(target.getFullPath(), null, FileSystemStructureProvider.INSTANCE, query, Arrays.asList(files));
        op.setContext(this.parentShell);
        op.setCreateContainerStructure(false);
        try {
            op.run(monitor);
        }
        catch (InterruptedException e) {
            return;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                final IStatus status = ((CoreException)e.getTargetException()).getStatus();
                this.parentShell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.parentShell, (String)IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.importErrorDialogTitle"), null, (IStatus)status);
                    }
                });
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log(StatusUtil.newStatus(4, MessageFormat.format("Exception in {0}.performFileImport(): {1}", this.getClass().getName(), e.getTargetException()), null));
                this.displayError(IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.internalError", new Object[]{e.getTargetException().getMessage()}));
            }
            return;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            if (this.errorStatus == null) {
                this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), null);
            }
            this.errorStatus.merge(status);
        }
    }

    private void recordError(CoreException error) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), (Throwable)error);
        }
        this.errorStatus.merge(error.getStatus());
    }

    public String validateDestination(IContainer destination, IResource[] sourceResources) {
        if (!this.isAccessible((IResource)destination)) {
            return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.destinationAccessError");
        }
        String destinationMessage = this.validateDestinationLocation(destination);
        if (destinationMessage != null) {
            return destinationMessage;
        }
        IContainer firstParent = null;
        IPath destinationLocation = destination.getLocation();
        for (int i = 0; i < sourceResources.length; ++i) {
            IResource sourceResource = sourceResources[i];
            if (firstParent == null) {
                firstParent = sourceResource.getParent();
            } else if (!firstParent.equals(sourceResource.getParent())) {
                return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.parentNotEqual");
            }
            IPath sourceLocation = sourceResource.getLocation();
            if (sourceLocation == null) {
                if (sourceResource.isLinked()) {
                    return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.missingPathVariable", new Object[]{sourceResource.getName()});
                }
                return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.resourceDeleted", new Object[]{sourceResource.getName()});
            }
            if (sourceLocation.equals(destinationLocation)) {
                return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.sameSourceAndDest", new Object[]{sourceResource.getName()});
            }
            if (sourceLocation.isPrefixOf(destinationLocation)) {
                return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.destinationDescendentError");
            }
            String linkedResourceMessage = this.validateLinkedResource(destination, sourceResource);
            if (linkedResourceMessage == null) continue;
            return linkedResourceMessage;
        }
        return null;
    }

    private String validateDestinationLocation(IContainer destination) {
        IPath destinationLocation = destination.getLocation();
        if (destinationLocation == null) {
            if (destination.isLinked()) {
                return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.missingPathVariable", new Object[]{destination.getName()});
            }
            return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.resourceDeleted", new Object[]{destination.getName()});
        }
        return null;
    }

    private boolean validateEdit(IContainer destination, IResource[] sourceResources) {
        ArrayList copyFiles = new ArrayList();
        this.collectExistingReadonlyFiles(destination.getFullPath(), sourceResources, copyFiles);
        if (copyFiles.size() > 0) {
            IFile[] files = copyFiles.toArray(new IFile[copyFiles.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(files, (Object)this.parentShell);
            this.canceled = !status.isOK();
            return status.isOK();
        }
        return true;
    }

    public String validateImportDestination(IContainer destination, String[] sourceNames) {
        if (!this.isAccessible((IResource)destination)) {
            return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.destinationAccessError");
        }
        String destinationMessage = this.validateDestinationLocation(destination);
        if (destinationMessage != null) {
            return destinationMessage;
        }
        IPath destinationPath = destination.getLocation();
        File destinationFile = destinationPath.toFile();
        for (int i = 0; i < sourceNames.length; ++i) {
            Path sourcePath = new Path(sourceNames[i]);
            File sourceFile = sourcePath.toFile();
            File sourceParentFile = sourcePath.removeLastSegments(1).toFile();
            if (sourceFile == null) continue;
            if (destinationFile.compareTo(sourceFile) == 0 || sourceParentFile != null && destinationFile.compareTo(sourceParentFile) == 0) {
                return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.importSameSourceAndDest", new Object[]{sourceFile.getName()});
            }
            IPath destinationParent = destinationPath.removeLastSegments(1);
            while (!destinationParent.isEmpty() && !destinationParent.isRoot()) {
                destinationFile = destinationParent.toFile();
                if (sourceFile.compareTo(destinationFile) == 0) {
                    return IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.destinationDescendentError");
                }
                destinationParent = destinationParent.removeLastSegments(1);
            }
        }
        return null;
    }

    private String validateLinkedResource(IContainer destination, IResource source) {
        IResource linkHandle;
        if (!source.isLinked()) {
            return null;
        }
        IWorkspace workspace = destination.getWorkspace();
        IStatus locationStatus = workspace.validateLinkLocation(linkHandle = this.createLinkedResourceHandle(destination, source), source.getRawLocation());
        if (locationStatus.getSeverity() == 4) {
            return locationStatus.getMessage();
        }
        IPath sourceLocation = source.getLocation();
        if (!source.getProject().equals(destination.getProject()) && source.getType() == 2 && sourceLocation != null) {
            try {
                IResource[] members = destination.members();
                for (int j = 0; j < members.length; ++j) {
                    if (!sourceLocation.equals(members[j].getLocation()) || !source.getName().equals(members[j].getName())) continue;
                    return IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.sameSourceAndDest", new Object[]{source.getName()});
                }
            }
            catch (CoreException exception) {
                this.displayError(IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.internalError", new Object[]{exception.getMessage()}));
            }
        }
        return null;
    }

    private IResource[] validateNoNameCollisions(IContainer destination, IResource[] sourceResources, IProgressMonitor monitor) {
        IPath destinationPath;
        int i;
        ArrayList<IResource> copyItems = new ArrayList<IResource>();
        IWorkspaceRoot workspaceRoot = destination.getWorkspace().getRoot();
        int overwrite = 3;
        for (i = 0; i < sourceResources.length; ++i) {
            IResource sourceResource = sourceResources[i];
            destinationPath = destination.getFullPath().append(sourceResource.getName());
            final IPath sourcePath = sourceResource.getFullPath();
            IResource newResource = workspaceRoot.findMember(destinationPath);
            if (newResource == null || !destinationPath.isPrefixOf(sourcePath)) continue;
            Runnable notice = new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)CopyFilesAndFoldersOperation.this.parentShell, (String)IDEWorkbenchMessages.getString("CopyFilesAndFoldersOperation.overwriteProblemTitle"), (String)IDEWorkbenchMessages.format("CopyFilesAndFoldersOperation.overwriteProblem", new Object[]{destinationPath, sourcePath}));
                }
            };
            this.parentShell.getDisplay().syncExec(notice);
            this.canceled = true;
            return null;
        }
        for (i = 0; i < sourceResources.length; ++i) {
            IResource source = sourceResources[i];
            destinationPath = destination.getFullPath().append(source.getName());
            IResource newResource = workspaceRoot.findMember(destinationPath);
            if (newResource != null) {
                if (overwrite != 4 || newResource.getType() == 2 && !this.homogenousResources(source, (IResource)destination)) {
                    overwrite = this.checkOverwrite(this.parentShell, source, newResource);
                }
                if (overwrite == 2 || overwrite == 4) {
                    copyItems.add(source);
                    continue;
                }
                if (overwrite != 1) continue;
                this.canceled = true;
                return null;
            }
            copyItems.add(source);
        }
        return copyItems.toArray(new IResource[copyItems.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

