/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.internal.PDE;

public class CompilerFlags {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int IGNORE = 2;
    public static final int MARKER = 0;
    public static final int BOOLEAN = 1;
    public static final int STRING = 2;
    public static final int PLUGIN_FLAGS = 0;
    public static final int SCHEMA_FLAGS = 1;
    public static final int FEATURE_FLAGS = 2;
    public static final int SITE_FLAGS = 3;
    public static final String P_UNRESOLVED_IMPORTS = "compilers.p.unresolved-import";
    public static final String P_UNRESOLVED_EX_POINTS = "compilers.p.unresolved-ex-points";
    public static final String P_UNKNOWN_ELEMENT = "compilers.p.unknown-element";
    public static final String P_UNKNOWN_ATTRIBUTE = "compilers.p.unknown-attribute";
    public static final String P_ILLEGAL_ATT_VALUE = "compilers.p.illegal-att-value";
    public static final String P_UNKNOWN_CLASS = "compilers.p.unknown-class";
    public static final String P_UNKNOWN_RESOURCE = "compilers.p.unknown-resource";
    public static final String P_NO_REQUIRED_ATT = "compilers.p.no-required-att";
    public static final String S_CREATE_DOCS = "compilers.s.create-docs";
    public static final String S_DOC_FOLDER = "compilers.s.doc-folder";
    public static final String S_OPEN_TAGS = "compilers.s.open-tags";
    public static final String S_FORBIDDEN_END_TAGS = "compilers.s.forbidden-end-tags";
    public static final String S_OPTIONAL_END_TAGS = "compilers.s.optional-end-tags";
    public static final String F_UNRESOLVED_PLUGINS = "compilers.f.unresolved-plugins";
    public static final String F_UNRESOLVED_FEATURES = "compilers.f.unresolved-features";
    private static final String[][] flags = new String[][]{{"compilers.p.unresolved-import", "compilers.p.unresolved-ex-points", "compilers.p.unknown-element", "compilers.p.unknown-attribute", "compilers.p.illegal-att-value", "compilers.p.unknown-class", "compilers.p.unknown-resource", "compilers.p.no-required-att"}, {"compilers.s.create-docs", "compilers.s.doc-folder", "compilers.s.open-tags", "compilers.s.forbidden-end-tags", "compilers.s.optional-end-tags"}, {"compilers.f.unresolved-plugins", "compilers.f.unresolved-features"}, new String[0]};

    public static int getFlagType(String flagId) {
        if (flagId.equals(S_CREATE_DOCS)) {
            return 1;
        }
        if (flagId.equals(S_DOC_FOLDER)) {
            return 2;
        }
        return 0;
    }

    public static int getFlag(String flagId) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getInt(flagId);
    }

    public static boolean getBoolean(String flagId) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getBoolean(flagId);
    }

    public static String getString(String flagId) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getString(flagId);
    }

    public static int getDefaultFlag(String flagId) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getDefaultInt(flagId);
    }

    public static String getDefaultString(String flagId) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getDefaultString(flagId);
    }

    public static boolean getDefaultBoolean(String flagId) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        return pref.getDefaultBoolean(flagId);
    }

    public static void setFlag(String flagId, int value) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setValue(flagId, value);
    }

    public static void setBoolean(String flagId, boolean value) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setValue(flagId, value);
    }

    public static void setString(String flagId, String value) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setValue(flagId, value);
    }

    public static void initializeDefaults() {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        pref.setDefault(P_UNRESOLVED_IMPORTS, 1);
        pref.setDefault(P_UNRESOLVED_EX_POINTS, 1);
        pref.setDefault(P_UNKNOWN_ELEMENT, 1);
        pref.setDefault(P_UNKNOWN_ATTRIBUTE, 1);
        pref.setDefault(P_ILLEGAL_ATT_VALUE, 1);
        pref.setDefault(P_UNKNOWN_CLASS, 2);
        pref.setDefault(P_UNKNOWN_RESOURCE, 2);
        pref.setDefault(P_NO_REQUIRED_ATT, 1);
        pref.setDefault(S_CREATE_DOCS, false);
        pref.setDefault(S_DOC_FOLDER, "doc");
        pref.setDefault(S_OPEN_TAGS, 1);
        pref.setDefault(S_FORBIDDEN_END_TAGS, 1);
        pref.setDefault(S_OPTIONAL_END_TAGS, 2);
        pref.setDefault(F_UNRESOLVED_PLUGINS, 1);
        pref.setDefault(F_UNRESOLVED_FEATURES, 1);
    }

    public static boolean isGroupActive(int group) {
        Preferences pref = PDE.getDefault().getPluginPreferences();
        String[] flagIds = CompilerFlags.getFlags(group);
        for (int i = 0; i < flagIds.length; ++i) {
            String flagId = flagIds[i];
            if (pref.getInt(flagId) == 2) continue;
            return true;
        }
        return false;
    }

    public static String[] getFlags(int group) {
        return flags[group];
    }

    public static void save() {
        PDE.getDefault().savePluginPreferences();
    }
}

