/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class TestSearchEngine {
    private List searchMethod(IProgressMonitor pm, IJavaSearchScope scope) throws CoreException {
        ArrayList typesFound = new ArrayList(200);
        this.searchMethod(typesFound, scope, pm);
        return typesFound;
    }

    private List searchMethod(List v, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws CoreException {
        JUnitSearchResultCollector requestor = new JUnitSearchResultCollector(v);
        SearchPattern suitePattern = SearchPattern.createPattern((String)"suite() Test", (int)1, (int)0, (int)8);
        SearchPattern testPattern = SearchPattern.createPattern((String)"test*() void", (int)1, (int)0, (int)10);
        SearchPattern pattern = SearchPattern.createOrPattern((SearchPattern)suitePattern, (SearchPattern)testPattern);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(pattern, participants, scope, (SearchRequestor)requestor, progressMonitor);
        return v;
    }

    public static IType[] findTests(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindTests(elements, result, pm);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] findTests(final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindTests(elements, result, pm);
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doFindTests(Object[] elements, Set result, IProgressMonitor pm) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(JUnitMessages.getString("TestSearchEngine.message.searching"), nElements);
        try {
            for (int i = 0; i < nElements; ++i) {
                try {
                    TestSearchEngine.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                }
                catch (CoreException e) {
                    JUnitPlugin.log(e.getStatus());
                }
                if (!pm.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            pm.done();
        }
    }

    private static void collectTypes(Object element, IProgressMonitor pm, Set result) throws CoreException {
        element = TestSearchEngine.computeScope(element);
        while (element instanceof IJavaElement && !(element instanceof ICompilationUnit) && element instanceof ISourceReference) {
            if (element instanceof IType && (TestSearchEngine.hasSuiteMethod((IType)element) || TestSearchEngine.isTestType((IType)element))) {
                result.add(element);
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!TestSearchEngine.hasSuiteMethod(types[i]) && !TestSearchEngine.isTestType(types[i])) continue;
                result.add(types[i]);
            }
        } else if (element instanceof IJavaElement) {
            List found = TestSearchEngine.searchSuiteMethods(pm, (IJavaElement)element);
            result.addAll(found);
        }
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    private static List searchSuiteMethods(IProgressMonitor pm, IJavaElement element) throws CoreException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element}, (int)3);
        TestSearchEngine searchEngine = new TestSearchEngine();
        return searchEngine.searchMethod(pm, scope);
    }

    public static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (method == null || !method.exists()) {
            return false;
        }
        return Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags()) && Flags.isPublic((int)method.getDeclaringType().getFlags());
    }

    private static boolean isTestType(IType type) throws JavaModelException {
        if (Flags.isAbstract((int)type.getFlags())) {
            return false;
        }
        if (!Flags.isPublic((int)type.getFlags())) {
            return false;
        }
        IType[] interfaces = type.newSupertypeHierarchy(null).getAllSuperInterfaces(type);
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getFullyQualifiedName().equals("junit.framework.Test")) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestImplementor(IType type) throws JavaModelException {
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] superInterfaces = typeHier.getAllInterfaces();
        for (int i = 0; i < superInterfaces.length; ++i) {
            if (!superInterfaces[i].getFullyQualifiedName().equals("junit.framework.Test")) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestOrTestSuite(IType type) throws JavaModelException {
        return TestSearchEngine.hasSuiteMethod(type) || TestSearchEngine.isTestType(type);
    }

    private class JUnitSearchResultCollector
    extends SearchRequestor {
        List fList;
        Set fFailed = new HashSet();
        Set fMatches = new HashSet();

        public JUnitSearchResultCollector(List list) {
            this.fList = list;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            IType declaringType = method.getDeclaringType();
            if (this.fMatches.contains(declaringType) || this.fFailed.contains(declaringType)) {
                return;
            }
            if (!TestSearchEngine.hasSuiteMethod(declaringType) && !TestSearchEngine.isTestType(declaringType)) {
                this.fFailed.add(declaringType);
                return;
            }
            this.fMatches.add(declaringType);
        }

        public void endReporting() {
            this.fList.addAll(this.fMatches);
        }
    }
}

