/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class RepositoryProviderOperation
extends CVSOperation {
    private IResource[] resources;

    public RepositoryProviderOperation(IWorkbenchPart part, IResource[] resources) {
        super(part);
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        Map table = this.getProviderMapping(this.getResources());
        Set keySet = table.keySet();
        monitor.beginTask(null, keySet.size() * 1000);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
            List list = (List)table.get(provider);
            IResource[] providerResources = list.toArray(new IResource[list.size()]);
            ISchedulingRule rule = this.getSchedulingRule(provider);
            try {
                Platform.getJobManager().beginRule(rule, monitor);
                monitor.setTaskName(this.getTaskName(provider));
                this.execute(provider, providerResources, (IProgressMonitor)subMonitor);
            }
            finally {
                Platform.getJobManager().endRule(rule);
            }
        }
    }

    protected abstract String getTaskName(CVSTeamProvider var1);

    protected ISchedulingRule getSchedulingRule(CVSTeamProvider provider) {
        return provider.getProject();
    }

    private Map getProviderMapping(IResource[] resources) {
        HashMap<RepositoryProvider, ArrayList<IResource>> result = new HashMap<RepositoryProvider, ArrayList<IResource>>();
        for (int i = 0; i < resources.length; ++i) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)CVSProviderPlugin.getTypeId());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
        }
        return result;
    }

    protected IResource[] getResources() {
        return this.resources;
    }

    protected void setResources(IResource[] resources) {
        this.resources = resources;
    }

    protected abstract void execute(CVSTeamProvider var1, IResource[] var2, IProgressMonitor var3) throws CVSException, InterruptedException;

    protected ICVSResource[] getCVSArguments(IResource[] resources) {
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        for (int i = 0; i < cvsResources.length; ++i) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
        }
        return cvsResources;
    }

    protected String[] getStringArguments(IResource[] resources) throws CVSException {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            IPath cvsPath = resources[i].getFullPath().removeFirstSegments(1);
            if (cvsPath.segmentCount() == 0) {
                arguments.add(".");
                continue;
            }
            arguments.add(cvsPath.toString());
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public ICVSResource[] getCVSResources() {
        ICVSResource[] cvsResources = new ICVSResource[this.resources.length];
        for (int i = 0; i < this.resources.length; ++i) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)this.resources[i]);
        }
        return cvsResources;
    }

    protected ICVSRepositoryLocation getRemoteLocation(CVSTeamProvider provider) throws CVSException {
        CVSWorkspaceRoot workspaceRoot = provider.getCVSWorkspaceRoot();
        return workspaceRoot.getRemoteLocation();
    }

    protected ICVSFolder getLocalRoot(CVSTeamProvider provider) throws CVSException {
        CVSWorkspaceRoot workspaceRoot = provider.getCVSWorkspaceRoot();
        return workspaceRoot.getLocalRoot();
    }

    protected void updateWorkspaceSubscriber(CVSTeamProvider provider, ICVSResource[] resources, IProgressMonitor monitor) {
        CVSWorkspaceSubscriber s = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
        monitor.beginTask(null, 100 * resources.length);
        for (int i = 0; i < resources.length; ++i) {
            ICVSResource resource = resources[i];
            if (resource.isFolder()) {
                try {
                    s.updateRemote(provider, (ICVSFolder)resource, Policy.subMonitorFor(monitor, 100));
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
                continue;
            }
            monitor.worked(100);
        }
    }
}

