/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RLog;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogListener;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryLocationOperation;
import org.eclipse.ui.IWorkbenchPart;

public class RemoteLogOperation
extends RepositoryLocationOperation {
    private RLog rlog = new RLog();
    private Map entries = new HashMap();
    private Map allEntries = new HashMap();
    private CVSTag tag1;
    private CVSTag tag2;

    public RemoteLogOperation(IWorkbenchPart part, ICVSRemoteResource[] remoteResources) {
        this(part, remoteResources, null, null);
    }

    public RemoteLogOperation(IWorkbenchPart part, ICVSRemoteResource[] remoteResources, CVSTag tag1, CVSTag tag2) {
        super(part, remoteResources);
        this.tag1 = tag1;
        this.tag2 = tag2;
    }

    public ILogEntry getLogEntry(ICVSRemoteResource resource) {
        return (ILogEntry)this.entries.get(resource);
    }

    public ILogEntry[] getLogEntries(ICVSRemoteResource resource) {
        return (ILogEntry[])this.allEntries.get(resource);
    }

    public void clearEntriesFor(ICVSRemoteResource resource) {
        this.entries.remove(resource);
        this.allEntries.remove(resource);
    }

    public void clearEntries() {
        this.entries.clear();
        this.allEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(ICVSRepositoryLocation location, ICVSRemoteResource[] remoteResources, IProgressMonitor monitor) throws CVSException {
        Command.LocalOption[] localOptions;
        monitor.beginTask(Policy.bind("RemoteLogOperation.0", location.getHost()), 100);
        Session s = new Session(location, CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()));
        LogListener listener = new LogListener();
        ICVSRemoteResource[] remotes = remoteResources;
        if (this.tag1 != null && this.tag2 != null) {
            localOptions = new Command.LocalOption[]{RLog.NO_TAGS, RLog.makeTagOption((CVSTag)this.tag1, (CVSTag)this.tag2)};
        } else {
            localOptions = new Command.LocalOption[]{RLog.NO_TAGS};
            ArrayList<ICVSRemoteResource> unCachedRemotes = new ArrayList<ICVSRemoteResource>();
            for (int i = 0; i < remoteResources.length; ++i) {
                ICVSRemoteResource r = remoteResources[i];
                if (this.entries.get(r) != null) continue;
                unCachedRemotes.add(r);
            }
            remotes = unCachedRemotes.toArray(new ICVSRemoteResource[unCachedRemotes.size()]);
        }
        if (remotes.length > 0) {
            try {
                s.open(Policy.subMonitorFor(monitor, 10));
                IStatus status = this.rlog.execute(s, Command.NO_GLOBAL_OPTIONS, localOptions, (ICVSResource[])remotes, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90));
                this.collectStatus(status);
            }
            finally {
                s.close();
            }
            for (int i = 0; i < remotes.length; ++i) {
                ICVSRemoteResource resource = remotes[i];
                if (resource.isContainer()) continue;
                ICVSRemoteFile file = (ICVSRemoteFile)resource;
                ILogEntry entry = listener.getEntryFor(file);
                if (entry != null) {
                    this.entries.put(file, entry);
                }
                ILogEntry[] allLogs = listener.getEntriesFor(file);
                this.allEntries.put(file, allLogs);
            }
        }
    }

    protected String getTaskName() {
        return Policy.bind("RemoteLogOperation.1");
    }
}

