/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.model.CVSFileElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSResourceElement;
import org.eclipse.ui.PlatformUI;

public class CVSFolderElement
extends CVSResourceElement {
    private ICVSFolder folder;
    private boolean includeUnmanaged;

    public CVSFolderElement(ICVSFolder folder, boolean includeUnmanaged) {
        this.folder = folder;
        this.includeUnmanaged = includeUnmanaged;
    }

    public Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        ICVSResource[] children = this.folder.fetchChildren(monitor);
        Object[] elements = new CVSResourceElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            ICVSResource resource = children[i];
            elements[i] = resource.isFolder() ? new CVSFolderElement((ICVSFolder)resource, this.includeUnmanaged) : new CVSFileElement((ICVSFile)resource);
        }
        return elements;
    }

    public boolean isRemoteElement() {
        return true;
    }

    public String getLabel(Object o) {
        return this.folder.getName();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public Object getParent(Object o) {
        return new CVSFolderElement(this.folder.getParent(), this.includeUnmanaged);
    }

    public ICVSResource getCVSResource() {
        return this.folder;
    }
}

