/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;

class PseudoJavaChangeElement
extends ChangeElement {
    private IJavaElement fJavaElement;
    private List fChildren;

    public PseudoJavaChangeElement(ChangeElement parent, IJavaElement element) {
        super(parent);
        this.fJavaElement = element;
        Assert.isNotNull((Object)this.fJavaElement);
    }

    public IJavaElement getJavaElement() {
        return this.fJavaElement;
    }

    public Change getChange() {
        return null;
    }

    public ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        DefaultChangeElement element = this.getDefaultChangeElement();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewerDescriptor();
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        DefaultChangeElement element = this.getDefaultChangeElement();
        if (element != null) {
            Change change = element.getChange();
            if (change instanceof TextChange) {
                List edits = this.collectTextEditChanges();
                viewer.setInput(TextChangePreviewViewer.createInput(change, edits.toArray(new TextEditChangeGroup[edits.size()]), this.getTextRange()));
            }
        } else {
            viewer.setInput(null);
        }
    }

    public void setActive(boolean active) {
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            ChangeElement element = (ChangeElement)iter.next();
            element.setActive(active);
        }
    }

    public int getActive() {
        ChangeElement element;
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int result = ((ChangeElement)this.fChildren.get(0)).getActive();
        for (int i = 1; i < this.fChildren.size() && (result = ACTIVATION_TABLE[(element = (ChangeElement)this.fChildren.get(i)).getActive()][result]) != 1; ++i) {
        }
        return result;
    }

    public ChangeElement[] getChildren() {
        if (this.fChildren == null) {
            return EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new ChangeElement[this.fChildren.size()]);
    }

    public void addChild(TextEditChangeElement child) {
        this.doAddChild(child);
    }

    public void addChild(PseudoJavaChangeElement child) {
        this.doAddChild(child);
    }

    private void doAddChild(ChangeElement child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(child);
    }

    private DefaultChangeElement getDefaultChangeElement() {
        ChangeElement element;
        for (element = this.getParent(); !(element instanceof DefaultChangeElement) && element != null; element = element.getParent()) {
        }
        return (DefaultChangeElement)element;
    }

    private List collectTextEditChanges() {
        ArrayList<TextEditChangeGroup> result = new ArrayList<TextEditChangeGroup>(10);
        ChangeElement[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ChangeElement child = children[i];
            if (child instanceof TextEditChangeElement) {
                result.add(((TextEditChangeElement)child).getTextEditChange());
                continue;
            }
            if (!(child instanceof PseudoJavaChangeElement)) continue;
            result.addAll(((PseudoJavaChangeElement)child).collectTextEditChanges());
        }
        return result;
    }

    public IRegion getTextRange() throws CoreException {
        ISourceRange range = ((ISourceReference)this.fJavaElement).getSourceRange();
        return new Region(range.getOffset(), range.getLength());
    }
}

