/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XSizeHints;
import org.eclipse.swt.internal.motif.XWindowAttributes;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int focusProxy;
    boolean reparented;
    boolean realized;
    boolean configured;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    Control lastActive;
    Region region;
    static final byte[] WM_DELETE_WINDOW = Converter.wcsToMbcs(null, "WM_DELETE_WINDOW\u0000");
    static final byte[] _NET_WM_STATE = Converter.wcsToMbcs(null, "_NET_WM_STATE\u0000");
    static final byte[] _NET_WM_STATE_MAXIMIZED_VERT = Converter.wcsToMbcs(null, "_NET_WM_STATE_MAXIMIZED_VERT\u0000");
    static final byte[] _NET_WM_STATE_MAXIMIZED_HORZ = Converter.wcsToMbcs(null, "_NET_WM_STATE_MAXIMIZED_HORZ\u0000");

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0);
    }

    static int checkStyle(int style) {
        if (((style = Decorations.checkStyle(style)) & 0x4000) != 0) {
            style &= 0xFFFFFB0F;
        }
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public static Shell motif_new(Display display, int handle) {
        return new Shell(display, null, 8, handle);
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void adjustTrim() {
        if (OS.XtIsSubclass(this.shellHandle, OS.overrideShellWidgetClass())) {
            return;
        }
        int[] argList = new int[]{OS.XmNoverrideRedirect, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        if (argList[1] != 0) {
            return;
        }
        int shellWindow = OS.XtWindow(this.shellHandle);
        if (shellWindow == 0) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return;
        }
        int[] unused = new int[1];
        int[] rootWindow = new int[1];
        int[] parent = new int[1];
        int[] ptr = new int[1];
        int trimWindow = shellWindow;
        OS.XQueryTree(xDisplay, trimWindow, rootWindow, parent, ptr, unused);
        if (ptr[0] != 0) {
            OS.XFree(ptr[0]);
        }
        if (parent[0] == 0) {
            return;
        }
        while (parent[0] != rootWindow[0]) {
            trimWindow = parent[0];
            OS.XQueryTree(xDisplay, trimWindow, unused, parent, ptr, unused);
            if (ptr[0] != 0) {
                OS.XFree(ptr[0]);
            }
            if (parent[0] != 0) continue;
            return;
        }
        if (shellWindow == trimWindow) {
            return;
        }
        int[] trimBorder = new int[1];
        int[] trimWidth = new int[1];
        int[] trimHeight = new int[1];
        int[] trimX = new int[1];
        int[] trimY = new int[1];
        OS.XGetGeometry(xDisplay, trimWindow, unused, trimX, trimY, trimWidth, trimHeight, trimBorder, unused);
        int[] shellBorder = new int[1];
        int[] shellWidth = new int[1];
        int[] shellHeight = new int[1];
        OS.XGetGeometry(xDisplay, shellWindow, unused, unused, unused, shellWidth, shellHeight, shellBorder, unused);
        short[] inner_x = new short[1];
        short[] inner_y = new short[1];
        OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, inner_x, inner_y);
        int width = trimWidth[0] + trimBorder[0] * 2 - (shellWidth[0] + shellBorder[0] * 2);
        int height = trimHeight[0] + trimBorder[0] * 2 - (shellHeight[0] + shellBorder[0] * 2);
        int leftInset = inner_x[0] - trimX[0];
        int topInset = inner_y[0] - trimY[0];
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 0x4E0) != 0;
            hasResize = (this.style & 0x10) != 0;
            boolean bl = hasBorder = (this.style & 0x800) != 0;
        }
        if (hasTitle) {
            if (hasResize) {
                this.display.leftTitleResizeWidth = leftInset;
                this.display.rightTitleResizeWidth = width - leftInset;
                this.display.topTitleResizeHeight = topInset;
                this.display.bottomTitleResizeHeight = height - topInset;
                return;
            }
            if (hasBorder) {
                this.display.leftTitleBorderWidth = leftInset;
                this.display.rightTitleBorderWidth = width - leftInset;
                this.display.topTitleBorderHeight = topInset;
                this.display.bottomTitleBorderHeight = height - topInset;
                return;
            }
            this.display.leftTitleWidth = leftInset;
            this.display.rightTitleWidth = width - leftInset;
            this.display.topTitleHeight = topInset;
            this.display.bottomTitleHeight = height - topInset;
            return;
        }
        if (hasResize) {
            this.display.leftResizeWidth = leftInset;
            this.display.rightResizeWidth = width - leftInset;
            this.display.topResizeHeight = topInset;
            this.display.bottomResizeHeight = height - topInset;
            return;
        }
        if (hasBorder) {
            this.display.leftBorderWidth = leftInset;
            this.display.rightBorderWidth = width - leftInset;
            this.display.topBorderHeight = topInset;
            this.display.bottomBorderHeight = height - topInset;
            return;
        }
    }

    int borderHandle() {
        return this.handle;
    }

    void bringToTop(boolean force) {
        if (this.minimized) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.focusProxy != 0 ? this.focusProxy : this.shellHandle);
        if (xWindow == 0) {
            return;
        }
        if (!force) {
            int[] buffer1 = new int[1];
            int[] buffer2 = new int[1];
            OS.XGetInputFocus(xDisplay, buffer1, buffer2);
            if (buffer1[0] == 0) {
                return;
            }
            int handle = OS.XtWindowToWidget(xDisplay, buffer1[0]);
            if (handle == 0) {
                return;
            }
        }
        OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        if (!this.isEnabled()) {
            return;
        }
        Composite widget = this.parent;
        while (widget != null && !widget.getShell().isModal()) {
            widget = widget.parent;
        }
        if (widget == null) {
            Shell[] shells = this.getShells();
            for (int i = 0; i < shells.length; ++i) {
                Shell shell = shells[i];
                if (shell == this || !shell.isModal() || !shell.isVisible()) continue;
                shell.bringToTop(false);
                return;
            }
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int border = 0;
        if ((this.style & 0x818) == 0) {
            int[] argList = new int[]{OS.XmNborderWidth, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            border = argList[1];
        }
        trim.x -= this.trimLeft();
        trim.y -= this.trimTop();
        trim.width += this.trimWidth() + border * 2;
        trim.height += this.trimHeight() + this.imeHeight() + border * 2;
        return trim;
    }

    void createFocusProxy() {
        if (this.focusProxy != 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNx, -1, OS.XmNy, -1, OS.XmNwidth, 1, OS.XmNheight, 1};
        this.focusProxy = OS.XmCreateDrawingArea(this.scrolledHandle, null, argList, argList.length / 2);
        if (this.focusProxy == 0) {
            this.error(2);
        }
        OS.XtSetMappedWhenManaged(this.focusProxy, false);
        OS.XtManageChild(this.focusProxy);
        OS.XtSetMappedWhenManaged(this.focusProxy, true);
    }

    void createHandle(int index) {
        int[] argList3;
        int textHandle;
        int xDisplay;
        this.state |= 0xA;
        int decorations = 0;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x80) != 0) {
                decorations |= 0x20;
            }
            if ((this.style & 0x400) != 0) {
                decorations |= 0x40;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 4;
            }
            if ((this.style & 0x800) != 0) {
                decorations |= 2;
            }
            if ((this.style & 0x40) != 0) {
                decorations |= 0x10;
            }
            if ((this.style & 0x20) != 0) {
                decorations |= 8;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 2;
            }
        }
        int inputMode = 0;
        if ((this.style & 0x8000) != 0) {
            inputMode = 1;
        }
        if ((this.style & 0x10000) != 0) {
            inputMode = 3;
        }
        if ((this.style & 0x20000) != 0) {
            inputMode = 2;
        }
        byte[] buffer = new byte[]{32, 0, 0, 0};
        int ptr = OS.XtMalloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        int[] argList1 = new int[]{OS.XmNmwmInputMode, inputMode, OS.XmNmwmDecorations, decorations, OS.XmNoverrideRedirect, (this.style & 0x4000) != 0 ? 1 : 0, OS.XmNtitle, ptr};
        int orientations = 0x6000000;
        if ((this.style & ~orientations) == 0 || (this.style & 0x4008) != 0) {
            this.reparented = true;
        }
        byte[] appClass = this.display.appClass;
        if (this.parent == null && (this.style & 0x4000) == 0 && inputMode != 3) {
            xDisplay = this.display.xDisplay;
            int widgetClass = OS.topLevelShellWidgetClass();
            this.shellHandle = OS.XtAppCreateShell(this.display.appName, appClass, widgetClass, xDisplay, argList1, argList1.length / 2);
        } else {
            int widgetClass = OS.transientShellWidgetClass();
            int parentHandle = this.display.shellHandle;
            if (this.parent != null) {
                parentHandle = this.parent.handle;
            }
            this.shellHandle = OS.XtCreatePopupShell(appClass, widgetClass, parentHandle, argList1, argList1.length / 2);
        }
        OS.XtFree(ptr);
        if (this.shellHandle == 0) {
            this.error(2);
        }
        if (this.handle != 0) {
            OS.XtSetMappedWhenManaged(this.shellHandle, false);
            OS.XtRealizeWidget(this.shellHandle);
            OS.XtSetMappedWhenManaged(this.shellHandle, true);
            xDisplay = this.display.xDisplay;
            int xWindow = OS.XtWindow(this.shellHandle);
            if (xWindow == 0) {
                this.error(2);
            }
            OS.XReparentWindow(xDisplay, xWindow, this.handle, 0, 0);
            this.handle = 0;
        }
        this.createHandle(index, this.shellHandle, true);
        if ((this.style & 0x818) == 0) {
            int[] argList2 = new int[]{OS.XmNborderWidth, 1};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
        if ((this.style & 0x4000) == 0 && (textHandle = OS.XmCreateTextField(this.handle, null, argList3 = new int[]{OS.XmNtraversalOn, 0}, argList3.length / 2)) == 0) {
            this.error(2);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    void destroyWidget() {
        if (OS.XtIsRealized(this.shellHandle)) {
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtUnmapWidget(this.shellHandle);
            } else {
                OS.XtPopdown(this.shellHandle);
            }
        }
        super.destroyWidget();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.parent != null) {
            int[] argList = new int[]{OS.XmNoverrideRedirect, 0};
            OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
            Shell activeShell = this.display.getActiveShell();
            if (argList[1] != 0 || activeShell == this) {
                Shell shell = this.parent.getShell();
                shell.bringToTop(false);
            }
        }
        super.dispose();
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        this.enableHandle(enabled, this.shellHandle);
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public int getBorderWidth() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNborderWidth, 0};
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        return argList[1];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, root_x, root_y);
        if (this.reparented) {
            root_x[0] = (short)(root_x[0] - this.trimLeft());
            root_y[0] = (short)(root_y[0] - this.trimTop());
        }
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        int border = argList[5];
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        int width = argList[1] + trimWidth + border * 2;
        int height = argList[3] + trimHeight + border * 2;
        return new Rectangle(root_x[0], root_y[0], width, height);
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getLocation() {
        this.checkWidget();
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, root_x, root_y);
        if (this.reparented) {
            root_x[0] = (short)(root_x[0] - this.trimLeft());
            root_y[0] = (short)(root_y[0] - this.trimTop());
        }
        return new Point(root_x[0], root_y[0]);
    }

    public boolean getMaximized() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.shellHandle);
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow != 0) {
            int property = OS.XInternAtom(xDisplay, _NET_WM_STATE, true);
            int[] type = new int[1];
            int[] format = new int[1];
            int[] nitems = new int[1];
            int[] bytes_after = new int[1];
            int[] atoms = new int[1];
            OS.XGetWindowProperty(xDisplay, xWindow, property, 0, Integer.MAX_VALUE, false, 4, type, format, nitems, bytes_after, atoms);
            boolean result = false;
            if (type[0] != 0) {
                int maximizedHorz = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_HORZ, true);
                int maximizedVert = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_VERT, true);
                int[] atom = new int[1];
                for (int i = 0; i < nitems[0]; ++i) {
                    OS.memmove(atom, atoms[0] + i * 4, 4);
                    if (atom[0] != maximizedHorz && atom[0] != maximizedVert) continue;
                    result = true;
                    break;
                }
            }
            if (atoms[0] != 0) {
                OS.XFree(atoms[0]);
            }
            return result;
        }
        return super.getMaximized();
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell != this) continue;
            ++count;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        for (int i = 0; i < shells.length; ++i) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell != this) continue;
            result[index++] = shells[i];
        }
        return result;
    }

    public Point getSize() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        int border = argList[5];
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        int width = argList[1] + trimWidth + border * 2;
        int height = argList[3] + trimHeight + border * 2;
        return new Point(width, height);
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            return false;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return false;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return false;
        }
        XWindowAttributes attributes = new XWindowAttributes();
        OS.XGetWindowAttributes(xDisplay, xWindow, attributes);
        if (attributes.map_state == 2 && this.reparented) {
            return true;
        }
        int[] argList = new int[]{OS.XmNmappedWhenManaged, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        return this.minimized && attributes.map_state == 1 && argList[1] != 0;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtInsertEventHandler(this.shellHandle, 131072, false, windowProc, 28, 1);
        if (OS.XtIsSubclass(this.shellHandle, OS.overrideShellWidgetClass())) {
            return;
        }
        OS.XtInsertEventHandler(this.shellHandle, 0x200000, false, windowProc, 5, 1);
        int[] argList = new int[]{OS.XmNdeleteResponse, 2};
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay != 0) {
            int atom = OS.XmInternAtom(xDisplay, WM_DELETE_WINDOW, false);
            OS.XmAddWMProtocolCallback(this.shellHandle, atom, windowProc, 31);
        }
    }

    int imeHeight() {
        if (!OS.IsDBLocale) {
            return 0;
        }
        int[] argList1 = new int[]{OS.XmNheight, 0};
        OS.XtGetValues(this.shellHandle, argList1, argList1.length / 2);
        int[] argList2 = new int[]{OS.XmNheight, 0};
        OS.XtGetValues(this.scrolledHandle, argList2, argList2.length / 2);
        return argList1[1] - argList2[1];
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isModal() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNmwmInputMode, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        return argList[1] != -1 && argList[1] != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void manageChildren() {
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        super.manageChildren();
        int width = 0;
        int height = 0;
        if (OS.IsLinux) {
            Monitor monitor = this.getMonitor();
            Rectangle rect = monitor.getClientArea();
            width = rect.width * 5 / 8;
            height = rect.height * 5 / 8;
        } else {
            int xDisplay = OS.XtDisplay(this.shellHandle);
            if (xDisplay == 0) {
                return;
            }
            width = OS.XDisplayWidth(xDisplay, OS.XDefaultScreen(xDisplay)) * 5 / 8;
            height = OS.XDisplayHeight(xDisplay, OS.XDefaultScreen(xDisplay)) * 5 / 8;
        }
        OS.XtResizeWidget(this.shellHandle, width, height, 0);
    }

    public void open() {
        this.checkWidget();
        this.setVisible(true);
        if (!this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        int xCursor = this.cursor != null && !enabled ? this.cursor.handle : 0;
        this.propagateHandle(enabled, this.shellHandle, xCursor);
    }

    void realizeWidget() {
        if (this.realized) {
            return;
        }
        OS.XtRealizeWidget(this.shellHandle);
        this.realizeChildren();
        this.realized = true;
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell.isDisposed()) continue;
            shell.releaseResources();
        }
    }

    void releaseWidget() {
        this.releaseShells();
        super.releaseWidget();
        this.lastActive = null;
        this.region = null;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(27, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
    }

    void saveBounds() {
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, root_x, root_y);
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        this.oldX = root_x[0];
        this.oldY = root_y[0];
        this.oldWidth = argList[1];
        this.oldHeight = argList[3];
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        int i;
        int index;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int length = Math.min(activate.length, deactivate.length);
        for (index = 0; index < length && activate[index] == deactivate[index]; ++index) {
        }
        for (i = deactivate.length - 1; i >= index; --i) {
            if (deactivate[i].isDisposed()) continue;
            if (this.display.postFocusOut) {
                deactivate[i].postEvent(27);
                continue;
            }
            deactivate[i].sendEvent(27);
        }
        for (i = activate.length - 1; i >= index; --i) {
            if (activate[i].isDisposed()) continue;
            activate[i].sendEvent(26);
        }
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        if (resize) {
            width = Math.max(width - this.trimWidth(), 1);
            height = Math.max(height - this.trimHeight(), 1);
        }
        if (!this.reparented || !OS.XtIsRealized(this.shellHandle)) {
            return super.setBounds(x, y, width, height, move, resize);
        }
        if (move) {
            x += this.trimLeft();
            y += this.trimTop();
        }
        if (!this.configured) {
            this.saveBounds();
        }
        this.configured = true;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if (resize && this.redrawWindow != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            OS.XResizeWindow(xDisplay, this.redrawWindow, width, height);
        }
        if (move && resize) {
            OS.XtConfigureWidget(this.shellHandle, x, y, width, height, 0);
        } else {
            if (move) {
                OS.XtMoveWidget(this.shellHandle, x, y);
            }
            if (resize) {
                OS.XtResizeWidget(this.shellHandle, width, height, 0);
            }
        }
        if (resize && OS.IsLinux) {
            this.updateResizable(width, height);
        }
        if (isFocus) {
            this.caret.setFocus();
        }
        return move || resize;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled == this.getEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if (enabled && this == this.display.getActiveShell() && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (!OS.XtIsRealized(this.handle)) {
            this.realizeWidget();
        }
        int xDisplay = OS.XtDisplay(this.shellHandle);
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow != 0) {
            int property = OS.XInternAtom(xDisplay, _NET_WM_STATE, true);
            int maximizedHorz = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_HORZ, true);
            int maximizedVert = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_VERT, true);
            int[] atoms = new int[]{maximizedHorz, maximizedVert};
            OS.XChangeProperty(xDisplay, xWindow, property, 4, 32, 0, atoms, atoms.length);
        }
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (minimized == this.minimized) {
            return;
        }
        int[] argList = new int[]{OS.XmNiconic, 0, OS.XmNinitialState, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        if (argList[1] != 0 != this.minimized) {
            argList[1] = this.minimized ? 1 : 0;
            OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        }
        super.setMinimized(minimized);
        argList[1] = minimized ? 1 : 0;
        argList[3] = minimized ? 3 : 1;
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay != 0) {
            OS.XSync(xDisplay, false);
        }
        if (!minimized) {
            int[] argList2 = new int[]{OS.XmNmappedWhenManaged, 0};
            OS.XtGetValues(this.shellHandle, argList2, argList2.length / 2);
            if (argList2[1] != 0) {
                do {
                    this.display.update();
                } while (!this.isVisible());
                this.setActive();
            }
        }
    }

    void setParentTraversal() {
    }

    public void setRegion(Region region) {
        int xDisplay;
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        if (!OS.XtIsRealized(this.shellHandle)) {
            this.realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(this.shellHandle)) == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow == 0) {
            return;
        }
        if (region != null) {
            OS.XShapeCombineRegion(xDisplay, xWindow, 0, 0, 0, region.handle, 0);
        } else {
            OS.XShapeCombineMask(xDisplay, xWindow, 0, 0, 0, 0, 0);
        }
        this.region = region;
    }

    public void setText(String string) {
        byte[] buffer1;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        if (string.length() == 0) {
            string = " ";
        }
        byte[] buffer2 = buffer1 = Converter.wcsToMbcs(null, string, true);
        int length = buffer1.length - 1;
        if (length % 4 != 0) {
            buffer2 = new byte[(length + 3) / 4 * 4];
            System.arraycopy(buffer1, 0, buffer2, 0, length);
        }
        int ptr = OS.XtMalloc(buffer2.length + 1);
        OS.memmove(ptr, buffer2, buffer2.length);
        int[] argList = new int[]{OS.XmNtitle, ptr, OS.XmNiconName, ptr};
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        OS.XtFree(ptr);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.realizeWidget();
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.XtSetMappedWhenManaged(this.shellHandle, true);
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtMapWidget(this.shellHandle);
            } else {
                OS.XtPopup(this.shellHandle, 0);
            }
            do {
                this.display.update();
                if (!this.isDisposed()) continue;
                return;
            } while (!this.isVisible());
            this.adjustTrim();
            int mask = 98304;
            if ((this.style & mask) != 0) {
                OS.XUngrabPointer(this.display.xDisplay, 0);
            }
        } else {
            OS.XtSetMappedWhenManaged(this.shellHandle, false);
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtUnmapWidget(this.shellHandle);
            } else {
                OS.XtPopdown(this.shellHandle);
            }
            int xDisplay = OS.XtDisplay(this.shellHandle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.shellHandle);
            if (xWindow == 0) {
                return;
            }
            OS.XWithdrawWindow(xDisplay, xWindow, OS.XDefaultScreen(xDisplay));
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean above) {
        this.setZOrder(control, above, false);
    }

    int topHandle() {
        return this.shellHandle;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.topTitleResizeHeight + this.display.bottomTitleResizeHeight;
            }
            if (hasBorder) {
                return this.display.topTitleBorderHeight + this.display.bottomTitleBorderHeight;
            }
            return this.display.topTitleHeight + this.display.bottomTitleHeight;
        }
        if (hasResize) {
            return this.display.topResizeHeight + this.display.bottomResizeHeight;
        }
        if (hasBorder) {
            return this.display.topBorderHeight + this.display.bottomBorderHeight;
        }
        return 0;
    }

    int trimLeft() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.leftTitleResizeWidth;
            }
            if (hasBorder) {
                return this.display.leftTitleBorderWidth;
            }
            return this.display.leftTitleWidth;
        }
        if (hasResize) {
            return this.display.leftResizeWidth;
        }
        if (hasBorder) {
            return this.display.leftBorderWidth;
        }
        return 0;
    }

    int trimTop() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.topTitleResizeHeight;
            }
            if (hasBorder) {
                return this.display.topTitleBorderHeight;
            }
            return this.display.topTitleHeight;
        }
        if (hasResize) {
            return this.display.topResizeHeight;
        }
        if (hasBorder) {
            return this.display.topBorderHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.leftTitleResizeWidth + this.display.rightTitleResizeWidth;
            }
            if (hasBorder) {
                return this.display.leftTitleBorderWidth + this.display.rightTitleBorderWidth;
            }
            return this.display.leftTitleWidth + this.display.rightTitleWidth;
        }
        if (hasResize) {
            return this.display.leftResizeWidth + this.display.rightResizeWidth;
        }
        if (hasBorder) {
            return this.display.leftBorderWidth + this.display.rightBorderWidth;
        }
        return 0;
    }

    void updateResizable(int width, int height) {
        if (!OS.XtIsRealized(this.shellHandle)) {
            return;
        }
        if ((this.style & 0x10) == 0) {
            XSizeHints hints = new XSizeHints();
            hints.flags = 48;
            hints.min_width = hints.max_width = width;
            hints.min_height = hints.max_height = height;
            OS.XSetWMNormalHints(OS.XtDisplay(this.shellHandle), OS.XtWindow(this.shellHandle), hints);
        }
    }

    int WM_DELETE_WINDOW(int w, int client_data, int call_data) {
        this.closeWidget();
        return 0;
    }

    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 28);
        int handle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        if (handle != this.shellHandle) {
            return super.XFocusChange(w, client_data, call_data, continue_to_dispatch);
        }
        if (xEvent.mode != 0) {
            return 0;
        }
        if (xEvent.type == 9 && xEvent.detail == 2 && this.focusProxy != 0) {
            int xWindow = OS.XtWindow(this.focusProxy);
            int xDisplay = OS.XtDisplay(this.focusProxy);
            OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
        }
        block0 : switch (xEvent.detail) {
            case 3: 
            case 4: {
                switch (xEvent.type) {
                    case 9: {
                        if (this.display.postFocusOut) {
                            this.postEvent(26);
                            break block0;
                        }
                        this.sendEvent(26);
                        break block0;
                    }
                    case 10: {
                        if (this.display.postFocusOut) {
                            this.postEvent(27);
                            break block0;
                        }
                        this.sendEvent(27);
                    }
                }
            }
        }
        return 0;
    }

    int XStructureNotify(int w, int client_data, int call_data, int continue_to_dispatch) {
        XConfigureEvent xEvent = new XConfigureEvent();
        OS.memmove(xEvent, call_data, 52);
        int handle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        if (handle != this.shellHandle) {
            return super.XStructureNotify(w, client_data, call_data, continue_to_dispatch);
        }
        switch (xEvent.type) {
            case 21: {
                if (this.reparented) {
                    return 0;
                }
                this.reparented = true;
                short[] root_x = new short[1];
                short[] root_y = new short[1];
                OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, root_x, root_y);
                int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
                OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
                xEvent.x = root_x[0];
                xEvent.y = root_y[0];
                xEvent.width = argList[1];
                xEvent.height = argList[3];
                if (OS.IsLinux) {
                    this.updateResizable(xEvent.width, xEvent.height);
                }
            }
            case 22: {
                if (!this.reparented) {
                    return 0;
                }
                this.configured = false;
                if (this.oldX != xEvent.x || this.oldY != xEvent.y) {
                    this.sendEvent(10);
                }
                if (this.oldWidth != xEvent.width || this.oldHeight != xEvent.height) {
                    int xEvent1 = OS.XtMalloc(96);
                    this.display.resizeWindow = xEvent.window;
                    this.display.resizeWidth = xEvent.width;
                    this.display.resizeHeight = xEvent.height;
                    this.display.resizeCount = 0;
                    int checkResizeProc = this.display.checkResizeProc;
                    OS.XCheckIfEvent(xEvent.display, xEvent1, checkResizeProc, 0);
                    if (this.display.resizeCount == 0) {
                        this.sendEvent(11);
                        if (this.layout != null) {
                            this.layout(false);
                        }
                    }
                    OS.XtFree(xEvent1);
                }
                if (xEvent.x != 0) {
                    this.oldX = xEvent.x;
                }
                if (xEvent.y != 0) {
                    this.oldY = xEvent.y;
                }
                this.oldWidth = xEvent.width;
                this.oldHeight = xEvent.height;
                return 0;
            }
            case 18: {
                int[] argList = new int[]{OS.XmNmappedWhenManaged, 0};
                OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
                if (argList[1] != 0) {
                    this.minimized = true;
                    this.sendEvent(19);
                }
                return 0;
            }
            case 19: {
                if (this.minimized) {
                    this.minimized = false;
                    this.sendEvent(20);
                }
                return 0;
            }
        }
        return 0;
    }
}

