/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    int printContext;
    int xScreen;
    int xDrawable;
    int xtContext;
    Font defaultFont;
    boolean isGCCreated;
    static String APP_NAME = "SWT_Printer";

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.application_name == null) {
            data.application_name = APP_NAME;
        }
        if (data.application_class == null) {
            data.application_class = APP_NAME;
        }
        if (data.name == null || data.driver == null) {
            PrinterData defaultData = Printer.getDefaultPrinterData();
            if (defaultData == null) {
                SWT.error(2);
            }
            data.name = defaultData.name;
            data.driver = defaultData.driver;
        }
        return data;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData[] list = Printer.getEnvPrinterList();
        PrinterData defaultPrinter = Printer.getEnvDefaultPrinter(list);
        if (defaultPrinter != null) {
            return defaultPrinter;
        }
        if (list.length != 0) {
            return list[0];
        }
        return null;
    }

    static PrinterData getEnvDefaultPrinter(PrinterData[] serverList) {
        String[] printerNames = new String[]{"XPRINTER", "PDPRINTER", "LPDEST", "PRINTER"};
        for (int i = 0; i < printerNames.length; ++i) {
            int ptr = OS.getenv(Converter.wcsToMbcs(null, printerNames[i], true));
            if (ptr == 0) continue;
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            String defaultPrinter = new String(Converter.mbcsToWcs(null, buffer));
            int index = defaultPrinter.indexOf("@");
            if (index != -1) {
                String name = defaultPrinter.substring(0, index);
                String driver = defaultPrinter.substring(index + 1);
                return new PrinterData(driver, name);
            }
            for (int j = 0; j < serverList.length; ++j) {
                PrinterData printerData = serverList[j];
                if (!defaultPrinter.equals(printerData.name)) continue;
                return new PrinterData(printerData.driver, defaultPrinter);
            }
        }
        return null;
    }

    public static PrinterData[] getPrinterList() {
        PrinterData[] list = Printer.getEnvPrinterList();
        PrinterData data = Printer.getEnvDefaultPrinter(list);
        if (data == null) {
            return list;
        }
        for (int i = 0; i < list.length; ++i) {
            PrinterData printerData = list[i];
            if (!printerData.name.equals(data.name) || !printerData.driver.equals(data.driver)) continue;
            return list;
        }
        PrinterData[] newList = new PrinterData[list.length + 1];
        System.arraycopy(list, 0, newList, 1, list.length);
        newList[0] = data;
        return newList;
    }

    static PrinterData[] getEnvPrinterList() {
        String[] serverList = Printer.getXPServerList();
        PrinterData[] printerList = new PrinterData[]{};
        for (int i = 0; i < serverList.length; ++i) {
            PrinterData[] printers = Printer.getEnvPrinterList(serverList[i]);
            if (printers.length == 0) continue;
            PrinterData[] newPrinterList = new PrinterData[printerList.length + printers.length];
            System.arraycopy(printerList, 0, newPrinterList, 0, printerList.length);
            System.arraycopy(printers, 0, newPrinterList, printerList.length, printers.length);
            printerList = newPrinterList;
        }
        return printerList;
    }

    static PrinterData[] getEnvPrinterList(String server) {
        byte[] buffer = Converter.wcsToMbcs(null, server, true);
        int pdpy = OS.XOpenDisplay(buffer);
        if (pdpy == 0) {
            return new PrinterData[0];
        }
        int[] count = new int[1];
        int plist = OS.XpGetPrinterList(pdpy, null, count);
        int printerCount = count[0];
        if (plist == 0 || printerCount == 0) {
            OS.XCloseDisplay(pdpy);
            if (plist != 0) {
                OS.XpFreePrinterList(plist);
            }
            return new PrinterData[0];
        }
        int[] stringPointers = new int[printerCount * 2];
        OS.memmove(stringPointers, plist, printerCount * 2 * 4);
        PrinterData[] printerList = new PrinterData[printerCount];
        for (int i = 0; i < printerCount; ++i) {
            String name = "";
            int address = stringPointers[i * 2];
            if (address != 0) {
                int length = OS.strlen(address);
                buffer = new byte[length];
                OS.memmove(buffer, address, length);
                name = new String(Converter.mbcsToWcs(null, buffer));
            }
            printerList[i] = new PrinterData(server, name);
        }
        OS.XCloseDisplay(pdpy);
        OS.XpFreePrinterList(plist);
        return printerList;
    }

    static String[] getXPServerList() {
        byte[] name = Converter.wcsToMbcs(null, "XPSERVERLIST", true);
        int ptr = OS.getenv(name);
        String[] serversList = new String[]{};
        if (ptr != 0) {
            int length = OS.strlen(ptr);
            byte[] buffer1 = new byte[length];
            OS.memmove(buffer1, ptr, length);
            char[] buffer2 = Converter.mbcsToWcs(null, buffer1);
            for (int i = 0; i < buffer2.length; ++i) {
                if (buffer2[i] == ' ') continue;
                int start = i;
                while (++i < buffer2.length && buffer2[i] != ' ') {
                }
                String server = new String(buffer2, start, i - start);
                String[] newServerList = new String[serversList.length + 1];
                System.arraycopy(serversList, 0, newServerList, 0, serversList.length);
                newServerList[serversList.length] = server;
                serversList = newServerList;
            }
        }
        return serversList;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        byte[] displayName = null;
        byte[] appName = null;
        byte[] appClass = null;
        displayName = Converter.wcsToMbcs(null, this.data.driver, true);
        appName = Converter.wcsToMbcs(null, this.data.application_name, true);
        appClass = Converter.wcsToMbcs(null, this.data.application_class, true);
        this.xtContext = OS.XtCreateApplicationContext();
        if (this.xtContext == 0) {
            SWT.error(2);
        }
        this.xDisplay = OS.XtOpenDisplay(this.xtContext, displayName, appName, appClass, 0, 0, new int[]{0}, 0);
        if (this.xDisplay == 0) {
            OS.XtDestroyApplicationContext(this.xtContext);
            SWT.error(2);
        }
        this.setDPI = true;
    }

    protected void init() {
        super.init();
        byte[] buffer = Converter.wcsToMbcs(null, this.data.name, true);
        int[] count = new int[1];
        int plist = OS.XpGetPrinterList(this.xDisplay, buffer, count);
        if (plist != 0) {
            OS.XpFreePrinterList(plist);
        }
        if (count[0] == 0) {
            SWT.error(2);
        }
        this.printContext = OS.XpCreateContext(this.xDisplay, buffer);
        OS.XpSetContext(this.xDisplay, this.printContext);
        this.xScreen = OS.XpGetScreenOfContext(this.xDisplay, this.printContext);
        if (this.xScreen == 0) {
            SWT.error(2);
        }
        XRectangle rect = new XRectangle();
        short[] width = new short[1];
        short[] height = new short[1];
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, width, height, rect);
        this.xDrawable = OS.XCreateWindow(this.xDisplay, OS.XRootWindowOfScreen(this.xScreen), 0, 0, rect.width, rect.height, 0, 0, 0, 0, 0L, null);
        if (this.xDrawable == 0) {
            SWT.error(2);
        }
        Point dpi = this.getDPI();
        buffer = Converter.wcsToMbcs(null, "-*-courier-medium-r-*-*-*-120-" + dpi.x + "-" + dpi.y + "-*-*-iso8859-1", true);
        int fontListEntry = OS.XmFontListEntryLoad(this.xDisplay, buffer, 1, OS.XmFONTLIST_DEFAULT_TAG);
        if (fontListEntry == 0) {
            SWT.error(2);
        }
        int defaultFontList = OS.XmFontListAppendEntry(0, fontListEntry);
        OS.XmFontListEntryFree(new int[]{fontListEntry});
        this.defaultFont = Font.motif_new(this, defaultFontList);
    }

    protected void destroy() {
        if (this.xtContext != 0) {
            OS.XtDestroyApplicationContext(this.xtContext);
        }
    }

    public int internal_new_GC(GCData data) {
        int xGC;
        if (data != null) {
            int mask;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((data.style & (mask = 0x6000000)) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.display = this.xDisplay;
            data.drawable = this.xDrawable;
            data.font = this.defaultFont;
            data.colormap = OS.XDefaultColormapOfScreen(this.xScreen);
            int defaultGC = OS.XDefaultGCOfScreen(this.xScreen);
            if (defaultGC != 0) {
                XGCValues values = new XGCValues();
                OS.XGetGCValues(this.xDisplay, defaultGC, 12, values);
                data.foreground = values.foreground;
                data.background = values.background;
            }
            this.isGCCreated = true;
        }
        if ((xGC = OS.XCreateGC(this.xDisplay, this.xDrawable, 0, null)) == 0) {
            SWT.error(2);
        }
        return xGC;
    }

    public void internal_dispose_GC(int xGC, GCData data) {
        OS.XFreeGC(this.xDisplay, xGC);
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    public boolean startJob(String jobName) {
        this.checkDevice();
        byte[] buffer = Converter.wcsToMbcs(null, "*job-name: " + jobName, true);
        OS.XpSetAttributes(this.xDisplay, this.printContext, (byte)1, buffer, (byte)2);
        OS.XpStartJob(this.xDisplay, (byte)1);
        return true;
    }

    public void endJob() {
        this.checkDevice();
        OS.XpEndJob(this.xDisplay);
        OS.XFlush(this.xDisplay);
    }

    public void cancelJob() {
        this.checkDevice();
        OS.XpCancelJob(this.xDisplay, true);
    }

    public boolean startPage() {
        this.checkDevice();
        OS.XpStartPage(this.xDisplay, this.xDrawable);
        return true;
    }

    public void endPage() {
        this.checkDevice();
        OS.XpEndPage(this.xDisplay);
    }

    public Point getDPI() {
        this.checkDevice();
        byte[] buffer = Converter.wcsToMbcs(null, "default-printer-resolution", true);
        int pool = OS.XpGetOneAttribute(this.xDisplay, this.printContext, (byte)2, buffer);
        int length = OS.strlen(pool);
        buffer = new byte[length];
        OS.memmove(buffer, pool, length);
        OS.XtFree(pool);
        String resolution = new String(buffer, 0, buffer.length);
        int res = 300;
        if (resolution.length() == 0) {
            int n;
            buffer = Converter.wcsToMbcs(null, "printer-resolutions-supported", true);
            pool = OS.XpGetOneAttribute(this.xDisplay, this.printContext, (byte)4, buffer);
            length = OS.strlen(pool);
            buffer = new byte[length];
            OS.memmove(buffer, pool, length);
            OS.XtFree(pool);
            for (n = 0; !Compatibility.isWhitespace((char)buffer[n]) && n < buffer.length; ++n) {
            }
            resolution = new String(buffer, 0, n);
        }
        if (resolution.length() != 0) {
            try {
                res = Integer.parseInt(resolution);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return new Point(res, res);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        XRectangle rect = new XRectangle();
        short[] width = new short[1];
        short[] height = new short[1];
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, width, height, rect);
        return new Rectangle(0, 0, width[0], height[0]);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        XRectangle rect = new XRectangle();
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, new short[1], new short[1], rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkDevice();
        XRectangle rect = new XRectangle();
        short[] paperWidth = new short[1];
        short[] paperHeight = new short[1];
        OS.XpGetPageDimensions(this.xDisplay, this.printContext, paperWidth, paperHeight, rect);
        int hTrim = paperWidth[0] - rect.width;
        int vTrim = paperHeight[0] - rect.height;
        return new Rectangle(x - rect.x, y - rect.y, width + hTrim, height + vTrim);
    }

    public PrinterData getPrinterData() {
        return this.data;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.defaultFont;
    }

    protected void checkDevice() {
        if (this.xDisplay == 0) {
            SWT.error(45);
        }
    }

    protected void release() {
        super.release();
        if (this.defaultFont != null) {
            OS.XmFontListFree(this.defaultFont.handle);
            this.defaultFont.handle = 0;
            this.defaultFont = null;
        }
        if (this.printContext != 0) {
            OS.XpDestroyContext(this.xDisplay, this.printContext);
            this.printContext = 0;
        }
        if (this.xDrawable != 0) {
            OS.XDestroyWindow(this.xDisplay, this.xDrawable);
            this.xDrawable = 0;
        }
        this.xScreen = 0;
        this.data = null;
    }
}

