/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngLzBlockReader;

public class PngDecodingDataStream {
    PngIdatChunk currentChunk;
    PngChunkReader chunkReader;
    byte currentByte;
    int nextByteIndex;
    int nextBitIndex;
    PngLzBlockReader lzBlockReader;
    int adlerValue;
    static final int PRIME = 65521;
    static final int MAX_BIT = 7;

    PngDecodingDataStream(PngIdatChunk idatChunk, PngChunkReader chunkReader) {
        this.currentChunk = idatChunk;
        this.chunkReader = chunkReader;
        this.nextByteIndex = 0;
        this.nextBitIndex = 8;
        this.adlerValue = 1;
        this.lzBlockReader = new PngLzBlockReader(this);
        this.readCompressedDataHeader();
        this.lzBlockReader.readNextBlockHeader();
    }

    void assertImageDataAtEnd() {
        this.lzBlockReader.assertCompressedDataAtEnd();
    }

    int getNextIdatBits(int length) {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value |= this.getNextIdatBit() << i;
        }
        return value;
    }

    byte getNextIdatBit() {
        if (this.nextBitIndex > 7) {
            this.currentByte = this.getNextIdatByte();
            this.nextBitIndex = 0;
        }
        int mask = 1 << this.nextBitIndex;
        ++this.nextBitIndex;
        return (this.currentByte & mask) > 0 ? (byte)1 : 0;
    }

    private PngIdatChunk getNextChunk() {
        PngChunk chunk = this.chunkReader.readNextChunk();
        if (chunk == null) {
            this.error();
        }
        if (chunk.getChunkType() != 2) {
            this.error();
        }
        return (PngIdatChunk)chunk;
    }

    byte getNextIdatByte() {
        if (this.nextByteIndex > this.currentChunk.getLength() - 1) {
            this.currentChunk = this.getNextChunk();
            this.nextByteIndex = 0;
        }
        byte nextByte = this.currentChunk.getDataByteAtOffset(this.nextByteIndex);
        ++this.nextByteIndex;
        this.nextBitIndex = 8;
        return nextByte;
    }

    private void updateAdler(byte value) {
        int low = this.adlerValue & 0xFFFF;
        int high = this.adlerValue >> 16 & 0xFFFF;
        int valueInt = value & 0xFF;
        low = (low + valueInt) % 65521;
        high = (low + high) % 65521;
        this.adlerValue = high << 16 | low;
    }

    byte getNextDecodedByte() {
        byte nextDecodedByte = this.lzBlockReader.getNextByte();
        this.updateAdler(nextDecodedByte);
        return nextDecodedByte;
    }

    void error() {
        SWT.error(40);
    }

    private void readCompressedDataHeader() {
        int windowSizeHint;
        int compressionMethod;
        byte headerByte2;
        byte headerByte1 = this.getNextIdatByte();
        int number = (headerByte1 & 0xFF) << 8 | (headerByte2 = this.getNextIdatByte()) & 0xFF;
        if (number % 31 != 0) {
            this.error();
        }
        if ((compressionMethod = headerByte1 & 0xF) != 8) {
            this.error();
        }
        if ((windowSizeHint = (headerByte1 & 0xF0) >> 4) > 7) {
            this.error();
        }
        int windowSize = 1 << windowSizeHint + 8;
        this.lzBlockReader.setWindowSize(windowSize);
        int dictionary = headerByte2 & 0x20;
        if (dictionary != 0) {
            this.error();
        }
    }

    void checkAdler() {
        int storedAdler = (this.getNextIdatByte() & 0xFF) << 24 | (this.getNextIdatByte() & 0xFF) << 16 | (this.getNextIdatByte() & 0xFF) << 8 | this.getNextIdatByte() & 0xFF;
        if (storedAdler != this.adlerValue) {
            this.error();
        }
    }
}

