/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 10;
    CTabItem[] items = new CTabItem[0];
    int selectedIndex = -1;
    int firstIndex = -1;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Image bgImage;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    static Color borderColor;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 1;
    boolean showChevron = false;
    boolean showMin = false;
    Rectangle minRect = new Rectangle(0, 0, 0, 0);
    boolean minimized = false;
    int minImageState = 1;
    boolean showMax = false;
    Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    boolean maximized = false;
    int maxImageState = 1;
    Control topRight;
    Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    int topRightAlignment = 131072;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    int borderBottom = 0;
    int highlight_margin = 0;
    int highlight_header = 0;
    int[] curve;
    int curveWidth = 0;
    int curveIndent = 0;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    int[] toolTipEvents = new int[]{7, 32, 5, 3, 29};
    Listener toolTipListener;
    Shell toolTipShell;
    Label toolTipLabel;
    int insertionIndex = -2;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_SIZE = 16;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int BORDER1_COLOR = 18;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 20;
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int HOT = 2;
    static final int SELECTED = 3;
    static final RGB CLOSE_FILL;

    public CTabFolder(Composite parent, int style) {
        super(parent, CTabFolder.checkStyle(parent, style));
        int style2 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (style2 & 0x400) != 0;
        this.showClose = (style2 & 0x40) != 0;
        this.single = (style2 & 4) != 0;
        this.borderRight = (style & 0x800) != 0 ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        this.highlight_header = (style & 0x800000) != 0 ? 1 : 3;
        this.highlight_margin = (style & 0x800000) != 0 ? 0 : 2;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        borderColor = display.getSystemColor(18);
        this.initAccessible();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose();
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 32: {
                        CTabFolder.this.onMouseHover(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 29, 15, 16, 1, 8, 3, 7, 32, 5, 4, 9, 11, 31};
        for (int i = 0; i < folderEvents.length; ++i) {
            this.addListener(folderEvents[i], listener);
        }
        this.toolTipListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 32: {
                        if (CTabFolder.this.updateToolTip(event.x, event.y)) break;
                    }
                    case 3: 
                    case 7: {
                        CTabFolder.this.hideToolTip();
                    }
                }
            }
        };
    }

    static int checkStyle(Composite parent, int style) {
        int mask = 109053126;
        if (((style &= mask) & 0x80) != 0) {
            style = style & 0xFFFFFB7F | 0x80;
        }
        if ((style & 2) != 0) {
            style = style & 0xFFFFFFF9 | 2;
        }
        style |= 0x100000;
        String platform = SWT.getPlatform();
        if ("carbon".equals(platform) || "gtk".equals(platform)) {
            return style;
        }
        if ((style & 0x4000000) != 0) {
            return style;
        }
        if ((parent.getStyle() & 0x8000000) != 0 && (style & 0x2000000) == 0) {
            return style;
        }
        return style | 0x40000;
    }

    static void fillRegion(GC gc, Region region) {
        Region clipping = new Region();
        gc.getClipping(clipping);
        region.intersect(clipping);
        gc.setClipping(region);
        gc.fillRectangle(region.getBounds());
        gc.setClipping(clipping);
        clipping.dispose();
    }

    public void addCTabFolder2Listener(CTabFolder2Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] newListeners = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, newListeners, 0, this.folderListeners.length);
        this.folderListeners = newListeners;
        this.folderListeners[this.folderListeners.length - 1] = listener;
    }

    public void addCTabFolderListener(CTabFolderListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, this.tabListeners.length);
        this.tabListeners = newTabListeners;
        this.tabListeners[this.tabListeners.length - 1] = listener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void antialias(int[] shape, RGB lineRGB, RGB innerRGB, RGB outerRGB, GC gc) {
        Color color;
        int blue;
        int green;
        int red;
        RGB to;
        if (this.simple || "carbon".equals(SWT.getPlatform())) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (outerRGB != null) {
            int index = 0;
            boolean left = true;
            int oldY = this.onBottom ? 0 : this.getSize().y;
            int[] outer = new int[shape.length];
            for (int i = 0; i < shape.length / 2; ++i) {
                if (left && index + 3 < shape.length) {
                    left = this.onBottom ? oldY <= shape[index + 3] : oldY >= shape[index + 3];
                    oldY = shape[index + 1];
                }
                outer[index] = shape[index++] + (left ? -1 : 1);
                outer[index] = shape[index++];
            }
            RGB from = lineRGB;
            to = outerRGB;
            red = from.red + 2 * (to.red - from.red) / 3;
            green = from.green + 2 * (to.green - from.green) / 3;
            blue = from.blue + 2 * (to.blue - from.blue) / 3;
            color = new Color(this.getDisplay(), red, green, blue);
            gc.setForeground(color);
            gc.drawPolyline(outer);
            color.dispose();
        }
        if (innerRGB != null) {
            int[] inner = new int[shape.length];
            int index = 0;
            boolean left = true;
            int oldY = this.onBottom ? 0 : this.getSize().y;
            for (int i = 0; i < shape.length / 2; ++i) {
                if (left && index + 3 < shape.length) {
                    left = this.onBottom ? oldY <= shape[index + 3] : oldY >= shape[index + 3];
                    oldY = shape[index + 1];
                }
                inner[index] = shape[index++] + (left ? 1 : -1);
                inner[index] = shape[index++];
            }
            RGB from = lineRGB;
            to = innerRGB;
            red = from.red + 2 * (to.red - from.red) / 3;
            green = from.green + 2 * (to.green - from.green) / 3;
            blue = from.blue + 2 * (to.blue - from.blue) / 3;
            color = new Color(this.getDisplay(), red, green, blue);
            gc.setForeground(color);
            gc.drawPolyline(inner);
            color.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int minHeight;
        this.checkWidget();
        int tabW = 0;
        GC gc = new GC(this);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.single) {
                tabW = Math.max(tabW, this.items[i].preferredWidth(gc, true, false));
                continue;
            }
            tabW += this.items[i].preferredWidth(gc, i == this.selectedIndex, false);
        }
        gc.dispose();
        tabW += 3;
        if (this.showMax) {
            tabW += 16;
        }
        if (this.showMin) {
            tabW += 16;
        }
        if (this.single) {
            tabW += 24;
        }
        if (this.topRight != null) {
            tabW += this.topRight.computeSize((int)-1, (int)this.tabHeight).x;
        }
        if (!this.single && !this.simple) {
            tabW += this.curveWidth - 2 * this.curveIndent;
        }
        int controlW = 0;
        int controlH = 0;
        for (int i = 0; i < this.items.length; ++i) {
            Control control = this.items[i].getControl();
            if (control == null || control.isDisposed()) continue;
            Point size = control.computeSize(wHint, hHint);
            controlW = Math.max(controlW, size.x);
            controlH = Math.max(controlH, size.y);
        }
        int minWidth = Math.max(tabW, controlW);
        int n = minHeight = this.minimized ? 0 : controlH;
        if (minWidth == 0) {
            minWidth = 64;
        }
        if (minHeight == 0) {
            minHeight = 64;
        }
        if (wHint != -1) {
            minWidth = wHint;
        }
        if (hHint != -1) {
            minHeight = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, minWidth, minHeight);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.marginWidth - this.highlight_margin - this.borderLeft;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.marginWidth + 2 * this.highlight_margin;
        if (this.minimized) {
            int trimY = this.onBottom ? y - this.borderTop : y - this.highlight_header - this.tabHeight - this.borderTop;
            int trimHeight = this.borderTop + this.borderBottom + this.tabHeight + this.highlight_header;
            return new Rectangle(trimX, trimY, trimWidth, trimHeight);
        }
        int trimY = this.onBottom ? y - this.marginHeight - this.highlight_margin - this.borderTop : y - this.marginHeight - this.highlight_header - this.tabHeight - this.borderTop;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + this.highlight_header + this.highlight_margin;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createItem(CTabItem item, int index) {
        if (0 > index || index > this.getItemCount()) {
            SWT.error(6);
        }
        CTabItem[] newItems = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        item.parent = this;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        if (this.items.length == 1) {
            this.firstIndex = 0;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            if (item.isShowing()) {
                this.redraw();
            }
        }
    }

    void destroyItem(CTabItem item) {
        if (this.inDispose) {
            return;
        }
        int index = this.indexOf(item);
        if (index == -1) {
            return;
        }
        this.insertionIndex = -2;
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.selectedIndex = -1;
            this.firstIndex = 0;
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            if (this.fixedTabHeight == -1) {
                this.tabHeight = 0;
            }
            this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
            this.hideToolTip();
            this.redraw();
            return;
        }
        CTabItem[] newItems = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
        this.items = newItems;
        if (this.firstIndex == this.items.length) {
            --this.firstIndex;
        }
        if (this.selectedIndex == index) {
            Control control = item.getControl();
            this.selectedIndex = -1;
            this.setSelection(Math.max(0, index - 1), true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redraw();
    }

    void drawBackground(GC gc, int[] shape, boolean selected) {
        Color defaultBackground = selected ? this.selectionBackground : this.getBackground();
        Image image = selected ? this.selectionBgImage : this.bgImage;
        Color[] colors = selected ? this.selectionGradientColors : this.gradientColors;
        int[] percents = selected ? this.selectionGradientPercents : this.gradientPercents;
        boolean vertical = selected ? this.selectionGradientVertical : this.gradientVertical;
        Point size = this.getSize();
        int width = size.x;
        int height = this.tabHeight + this.highlight_header;
        int x = 0;
        if (this.borderLeft > 0) {
            ++x;
            width -= 2;
        }
        int y = this.onBottom ? size.y - this.borderBottom - height : this.borderTop;
        this.drawBackground(gc, shape, x, y, width, height, defaultBackground, image, colors, percents, vertical);
    }

    void drawBackground(GC gc, int[] shape, int x, int y, int width, int height, Color defaultBackground, Image image, Color[] colors, int[] percents, boolean vertical) {
        Region clipping = new Region();
        gc.getClipping(clipping);
        Region region = new Region();
        region.add(shape);
        region.intersect(clipping);
        gc.setClipping(region);
        if (image != null) {
            gc.setBackground(defaultBackground);
            gc.fillRectangle(x, y, width, height);
            Rectangle imageRect = image.getBounds();
            gc.drawImage(image, imageRect.x, imageRect.y, imageRect.width, imageRect.height, x, y, width, height);
        } else if (colors != null) {
            if (colors.length == 1) {
                Color background = colors[0] != null ? colors[0] : defaultBackground;
                gc.setBackground(background);
                gc.fillRectangle(x, y, width, height);
            } else if (vertical) {
                if (this.onBottom) {
                    Color lastColor;
                    int pos = 0;
                    if (percents[percents.length - 1] < 100) {
                        pos = percents[percents.length - 1] * height / 100;
                        gc.setBackground(defaultBackground);
                        gc.fillRectangle(x, y, width, pos);
                    }
                    if ((lastColor = colors[colors.length - 1]) == null) {
                        lastColor = defaultBackground;
                    }
                    for (int i = percents.length - 1; i >= 0; --i) {
                        gc.setForeground(lastColor);
                        lastColor = colors[i];
                        if (lastColor == null) {
                            lastColor = defaultBackground;
                        }
                        gc.setBackground(lastColor);
                        int gradientHeight = percents[i] * height / 100;
                        gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                        pos += gradientHeight;
                    }
                } else {
                    Color lastColor = colors[0];
                    if (lastColor == null) {
                        lastColor = defaultBackground;
                    }
                    int pos = 0;
                    for (int i = 0; i < percents.length; ++i) {
                        gc.setForeground(lastColor);
                        lastColor = colors[i + 1];
                        if (lastColor == null) {
                            lastColor = defaultBackground;
                        }
                        gc.setBackground(lastColor);
                        int gradientHeight = percents[i] * height / 100;
                        gc.fillGradientRectangle(x, y + pos, width, gradientHeight, true);
                        pos += gradientHeight;
                    }
                    if (pos < height) {
                        gc.setBackground(defaultBackground);
                        gc.fillRectangle(x, pos, width, height - pos + 1);
                    }
                }
            } else {
                y = 0;
                height = this.getSize().y;
                Color lastColor = colors[0];
                if (lastColor == null) {
                    lastColor = defaultBackground;
                }
                int pos = 0;
                for (int i = 0; i < percents.length; ++i) {
                    gc.setForeground(lastColor);
                    lastColor = colors[i + 1];
                    if (lastColor == null) {
                        lastColor = defaultBackground;
                    }
                    gc.setBackground(lastColor);
                    int gradientWidth = percents[i] * width / 100 - pos;
                    gc.fillGradientRectangle(x + pos, y, gradientWidth, height, false);
                    pos += gradientWidth;
                }
                if (pos < width) {
                    gc.setBackground(defaultBackground);
                    gc.fillRectangle(x + pos, y, width - pos, height);
                }
            }
        } else if ((this.getStyle() & 0x40000) != 0 || !defaultBackground.equals(this.getBackground())) {
            gc.setBackground(defaultBackground);
            gc.fillRectangle(x, y, width, height);
        }
        gc.setClipping(clipping);
        clipping.dispose();
        region.dispose();
    }

    void drawBody(Event event) {
        int height;
        GC gc = event.gc;
        Point size = this.getSize();
        if (!this.minimized) {
            int width = size.x - this.borderLeft - this.borderRight - 2 * this.highlight_margin;
            int height2 = size.y - this.borderTop - this.borderBottom - this.tabHeight - this.highlight_header - this.highlight_margin;
            if (this.highlight_margin > 0) {
                int x1;
                int[] shape = null;
                if (this.onBottom) {
                    x1 = this.borderLeft;
                    int y1 = this.borderTop;
                    int x2 = size.x - this.borderRight;
                    int y2 = size.y - this.borderBottom - this.tabHeight - this.highlight_header;
                    shape = new int[]{x1, y1, x2, y1, x2, y2, x2 - this.highlight_margin, y2, x2 - this.highlight_margin, y1 + this.highlight_margin, x1 + this.highlight_margin, y1 + this.highlight_margin, x1 + this.highlight_margin, y2, x1, y2};
                } else {
                    x1 = this.borderLeft;
                    int y1 = this.borderTop + this.tabHeight + this.highlight_header;
                    int x2 = size.x - this.borderRight;
                    int y2 = size.y - this.borderBottom;
                    shape = new int[]{x1, y1, x1 + this.highlight_margin, y1, x1 + this.highlight_margin, y2 - this.highlight_margin, x2 - this.highlight_margin, y2 - this.highlight_margin, x2 - this.highlight_margin, y1, x2, y1, x2, y2, x1, y2};
                }
                if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                    this.drawBackground(gc, shape, true);
                } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                    this.drawBackground(gc, shape, false);
                } else {
                    gc.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                    gc.fillPolygon(shape);
                }
            }
            if ((this.getStyle() & 0x40000) != 0) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(this.xClient - this.marginWidth, this.yClient - this.marginHeight, width, height2);
            }
        } else if ((this.getStyle() & 0x40000) != 0 && size.y > (height = this.borderTop + this.tabHeight + this.highlight_header + this.borderBottom)) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(0, height, size.x, size.y - height);
        }
        if (this.borderLeft > 0) {
            gc.setForeground(borderColor);
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.onBottom ? this.borderTop - 1 : this.borderTop + this.tabHeight;
            int y2 = this.onBottom ? size.y - this.tabHeight - this.borderBottom - 1 : size.y - this.borderBottom;
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(x2, y1, x2, y2);
            if (this.onBottom) {
                gc.drawLine(x1, y1, x2, y1);
            } else {
                gc.drawLine(x1, y2, x2, y2);
            }
        }
    }

    void drawChevron(GC gc) {
        int count;
        if (this.chevronRect.width == 0 || this.chevronRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        FontData fd = this.getFont().getFontData()[0];
        fd.setHeight(7);
        Font f = new Font((Device)display, fd);
        int fHeight = f.getFontData()[0].getHeight() * display.getDPI().y / 72;
        int indent = Math.max(2, (this.chevronRect.height - fHeight - 4) / 2);
        int x = this.chevronRect.x + 2;
        int y = this.chevronRect.y + indent;
        if (this.single) {
            count = this.selectedIndex == -1 ? this.items.length : this.items.length - 1;
        } else {
            int lastIndex = this.getLastIndex();
            count = Math.max(0, this.items.length - (lastIndex - this.firstIndex + 1));
        }
        switch (this.chevronImageState) {
            case 1: {
                Color chevronBorder = this.single ? this.getSelectionForeground() : this.getForeground();
                gc.setForeground(chevronBorder);
                gc.setFont(f);
                gc.drawLine(x, y, x + 2, y + 2);
                gc.drawLine(x + 2, y + 2, x, y + 4);
                gc.drawLine(x + 1, y, x + 3, y + 2);
                gc.drawLine(x + 3, y + 2, x + 1, y + 4);
                gc.drawLine(x + 4, y, x + 6, y + 2);
                gc.drawLine(x + 6, y + 2, x + 5, y + 4);
                gc.drawLine(x + 5, y, x + 7, y + 2);
                gc.drawLine(x + 7, y + 2, x + 4, y + 4);
                gc.drawString(String.valueOf(count), x + 7, y + 3, true);
                break;
            }
            case 2: {
                gc.setForeground(display.getSystemColor(17));
                gc.setBackground(display.getSystemColor(20));
                gc.setFont(f);
                gc.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gc.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gc.drawLine(x, y, x + 2, y + 2);
                gc.drawLine(x + 2, y + 2, x, y + 4);
                gc.drawLine(x + 1, y, x + 3, y + 2);
                gc.drawLine(x + 3, y + 2, x + 1, y + 4);
                gc.drawLine(x + 4, y, x + 6, y + 2);
                gc.drawLine(x + 6, y + 2, x + 5, y + 4);
                gc.drawLine(x + 5, y, x + 7, y + 2);
                gc.drawLine(x + 7, y + 2, x + 4, y + 4);
                gc.drawString(String.valueOf(count), x + 7, y + 3, true);
                break;
            }
            case 3: {
                gc.setForeground(display.getSystemColor(17));
                gc.setBackground(display.getSystemColor(20));
                gc.setFont(f);
                gc.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gc.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gc.drawLine(x + 1, y + 1, x + 3, y + 3);
                gc.drawLine(x + 3, y + 3, x + 1, y + 5);
                gc.drawLine(x + 2, y + 1, x + 4, y + 3);
                gc.drawLine(x + 4, y + 3, x + 2, y + 5);
                gc.drawLine(x + 5, y + 1, x + 7, y + 3);
                gc.drawLine(x + 7, y + 3, x + 6, y + 5);
                gc.drawLine(x + 6, y + 1, x + 8, y + 3);
                gc.drawLine(x + 8, y + 3, x + 5, y + 5);
                gc.drawString(String.valueOf(count), x + 8, y + 4, true);
            }
        }
        f.dispose();
    }

    void drawMaximize(GC gc) {
        if (this.maxRect.width == 0 || this.maxRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int x = this.maxRect.x + 3;
        int y = this.maxRect.y + 3;
        gc.setForeground(display.getSystemColor(17));
        gc.setBackground(display.getSystemColor(20));
        switch (this.maxImageState) {
            case 1: {
                if (!this.maximized) {
                    gc.fillRectangle(x, y, 9, 9);
                    gc.drawRectangle(x, y, 9, 9);
                    gc.drawLine(x + 1, y + 2, x + 8, y + 2);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 2: {
                gc.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gc.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gc.fillRectangle(x, y, 9, 9);
                    gc.drawRectangle(x, y, 9, 9);
                    gc.drawLine(x + 1, y + 2, x + 8, y + 2);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 3: {
                gc.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gc.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gc.fillRectangle(x + 1, y + 1, 9, 9);
                    gc.drawRectangle(x + 1, y + 1, 9, 9);
                    gc.drawLine(x + 2, y + 3, x + 9, y + 3);
                    break;
                }
                gc.fillRectangle(x + 1, y + 4, 5, 4);
                gc.fillRectangle(x + 3, y + 1, 5, 4);
                gc.drawRectangle(x + 1, y + 4, 5, 4);
                gc.drawRectangle(x + 3, y + 1, 5, 4);
                gc.drawLine(x + 4, y + 2, x + 7, y + 2);
                gc.drawLine(x + 2, y + 5, x + 5, y + 5);
            }
        }
    }

    void drawMinimize(GC gc) {
        if (this.minRect.width == 0 || this.minRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int x = this.minRect.x + 3;
        int y = this.minRect.y + 3;
        gc.setForeground(display.getSystemColor(17));
        gc.setBackground(display.getSystemColor(20));
        switch (this.minImageState) {
            case 1: {
                if (!this.minimized) {
                    gc.fillRectangle(x, y, 9, 3);
                    gc.drawRectangle(x, y, 9, 3);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 2: {
                gc.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gc.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gc.fillRectangle(x, y, 9, 3);
                    gc.drawRectangle(x, y, 9, 3);
                    break;
                }
                gc.fillRectangle(x, y + 3, 5, 4);
                gc.fillRectangle(x + 2, y, 5, 4);
                gc.drawRectangle(x, y + 3, 5, 4);
                gc.drawRectangle(x + 2, y, 5, 4);
                gc.drawLine(x + 3, y + 1, x + 6, y + 1);
                gc.drawLine(x + 1, y + 4, x + 4, y + 4);
                break;
            }
            case 3: {
                gc.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gc.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gc.fillRectangle(x + 1, y + 1, 9, 3);
                    gc.drawRectangle(x + 1, y + 1, 9, 3);
                    break;
                }
                gc.fillRectangle(x + 1, y + 4, 5, 4);
                gc.fillRectangle(x + 3, y + 1, 5, 4);
                gc.drawRectangle(x + 1, y + 4, 5, 4);
                gc.drawRectangle(x + 3, y + 1, 5, 4);
                gc.drawLine(x + 4, y + 2, x + 7, y + 2);
                gc.drawLine(x + 2, y + 5, x + 5, y + 5);
            }
        }
    }

    void drawTabArea(Event event) {
        int i;
        int index;
        int[] right;
        int[] left;
        GC gc = event.gc;
        Point size = this.getSize();
        int[] shape = null;
        if (this.tabHeight == 0) {
            int y2;
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.onBottom ? size.y - this.borderBottom - this.highlight_header - 1 : this.borderTop + this.highlight_header;
            int n = y2 = this.onBottom ? size.y - this.borderBottom : this.borderTop;
            if (this.borderLeft <= 0 || this.onBottom) {
                // empty if block
            }
            shape = new int[]{x1, y1, x1, --y2, x2, y2, x2, y1};
            if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                this.drawBackground(gc, shape, true);
            } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                this.drawBackground(gc, shape, false);
            } else {
                gc.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                gc.fillPolygon(shape);
            }
            if (this.borderLeft > 0) {
                gc.setForeground(borderColor);
                gc.drawPolyline(shape);
            }
            return;
        }
        int x = Math.max(0, this.borderLeft - 1);
        int y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop;
        int width = size.x - this.borderLeft - this.borderRight + 1;
        int height = this.tabHeight - 1;
        if (this.onBottom) {
            left = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
            right = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            shape = new int[left.length + right.length + 4];
            index = 0;
            shape[index++] = x;
            shape[index++] = y - this.highlight_header;
            for (i = 0; i < left.length / 2; ++i) {
                shape[index++] = x + left[2 * i];
                shape[index++] = y + height + left[2 * i + 1];
                if (this.borderLeft != 0) continue;
                int n = index - 1;
                shape[n] = shape[n] + 1;
            }
            for (i = 0; i < right.length / 2; ++i) {
                shape[index++] = x + width + right[2 * i];
                shape[index++] = y + height + right[2 * i + 1];
                if (this.borderLeft != 0) continue;
                int n = index - 1;
                shape[n] = shape[n] + 1;
            }
            shape[index++] = x + width;
            shape[index++] = y - this.highlight_header;
        } else {
            left = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
            right = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            shape = new int[left.length + right.length + 4];
            index = 0;
            shape[index++] = x;
            shape[index++] = y + height + this.highlight_header + 1;
            for (i = 0; i < left.length / 2; ++i) {
                shape[index++] = x + left[2 * i];
                shape[index++] = y + left[2 * i + 1];
            }
            for (i = 0; i < right.length / 2; ++i) {
                shape[index++] = x + width + right[2 * i];
                shape[index++] = y + right[2 * i + 1];
            }
            shape[index++] = x + width;
            shape[index++] = y + height + this.highlight_header + 1;
        }
        boolean bkSelected = this.single && this.selectedIndex != -1;
        this.drawBackground(gc, shape, bkSelected);
        Region r = new Region();
        r.add(new Rectangle(x, y, width + 1, height + 1));
        r.subtract(shape);
        gc.setBackground(this.getParent().getBackground());
        CTabFolder.fillRegion(gc, r);
        r.dispose();
        if (this.borderLeft > 0) {
            RGB outside = this.getParent().getBackground().getRGB();
            this.antialias(shape, borderColor.getRGB(), null, outside, gc);
            gc.setForeground(borderColor);
            gc.drawPolyline(shape);
        }
        if (!this.single) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                if (i2 == this.selectedIndex || !event.getBounds().intersects(this.items[i2].getBounds())) continue;
                this.items[i2].onPaint(gc, false);
            }
        }
        if (this.selectedIndex != -1) {
            CTabItem item = this.items[this.selectedIndex];
            item.onPaint(gc, true);
        } else {
            int x1 = this.borderLeft;
            int y1 = this.onBottom ? size.y - this.borderBottom - this.tabHeight - 1 : this.borderTop + this.tabHeight;
            int x2 = size.x - this.borderRight;
            gc.setForeground(borderColor);
            gc.drawLine(x1, y1, x2, y1);
        }
        if (this.items.length > 0) {
            this.drawChevron(gc);
            this.drawMinimize(gc);
            this.drawMaximize(gc);
        }
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderLeft == 1;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.minimized) {
            return new Rectangle(this.xClient, this.yClient, 0, 0);
        }
        Point size = this.getSize();
        int width = size.x - this.borderLeft - this.borderRight - 2 * this.marginWidth - 2 * this.highlight_margin;
        int height = size.y - this.borderTop - this.borderBottom - 2 * this.marginHeight - this.highlight_margin - this.highlight_header;
        return new Rectangle(this.xClient, this.yClient, width, height -= this.tabHeight);
    }

    public CTabItem getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            SWT.error(6);
        }
        return this.items[index];
    }

    public CTabItem getItem(Point pt) {
        if (this.items.length == 0) {
            return null;
        }
        Point size = this.getSize();
        if (size.x <= this.borderLeft + this.borderRight) {
            return null;
        }
        for (int index = this.firstIndex; index < this.items.length; ++index) {
            CTabItem item = this.items[index];
            Rectangle rect = item.getBounds();
            if (!rect.contains(pt)) continue;
            return item;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] tabItems = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    int getLastIndex() {
        if (this.single) {
            return this.selectedIndex;
        }
        if (this.items.length == 0) {
            return -1;
        }
        for (int i = this.firstIndex; i < this.items.length; ++i) {
            CTabItem item = this.items[i];
            if (item.isShowing()) continue;
            return i == this.firstIndex ? this.firstIndex : i - 1;
        }
        return this.items.length - 1;
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    int getRightItemEdge() {
        int x = this.getSize().x - this.borderRight - 3;
        if (this.showMin) {
            x -= 16;
        }
        if (this.showMax) {
            x -= 16;
        }
        if (this.showChevron) {
            x -= 24;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            x -= this.topRightRect.width + 3;
        }
        return x;
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFB7F;
        style |= this.onBottom ? 1024 : 128;
        style &= 0xFFFFFFF9;
        style |= this.single ? 4 : 2;
        if (this.borderLeft != 0) {
            style |= 0x800;
        }
        return style;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                int index;
                String name = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (index = (name = CTabFolder.this.items[childID].getText()).indexOf(38)) > 0) {
                    name = name.substring(0, index) + name.substring(index + 1);
                }
                e.result = name;
            }

            public void getHelp(AccessibleEvent e) {
                String help = null;
                int childID = e.childID;
                if (childID == -1) {
                    help = CTabFolder.this.getToolTipText();
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    help = CTabFolder.this.items[childID].getToolTipText();
                }
                e.result = help;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (text = CTabFolder.this.items[childID].getText()) != null && (mnemonic = CTabFolder.this.getMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CTabFolder.this.toControl(new Point(e.x, e.y));
                int childID = -2;
                for (int i = 0; i < CTabFolder.this.items.length; ++i) {
                    if (!CTabFolder.this.items[i].getBounds().contains(testPoint)) continue;
                    childID = i;
                    break;
                }
                if (childID == -2) {
                    Rectangle location = CTabFolder.this.getBounds();
                    location.height -= CTabFolder.this.getClientArea().height;
                    if (location.contains(testPoint)) {
                        childID = -1;
                    }
                }
                e.childID = childID;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = CTabFolder.this.getBounds();
                }
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    location = CTabFolder.this.items[childID].getBounds();
                }
                if (location != null) {
                    Point pt = CTabFolder.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = CTabFolder.this.items.length;
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                String action = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    action = "Switch";
                }
                e.result = action;
            }

            public void getFocus(AccessibleControlEvent e) {
                int childID = -2;
                if (CTabFolder.this.isFocusControl()) {
                    childID = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                e.childID = childID;
            }

            public void getRole(AccessibleControlEvent e) {
                int role = 0;
                int childID = e.childID;
                if (childID == -1) {
                    role = 60;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    role = 37;
                }
                e.detail = role;
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                int childID = e.childID;
                if (childID == -1) {
                    state = 0;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    state = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        state |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == childID) {
                        state |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            state |= 4;
                        }
                    }
                }
                e.detail = state;
            }

            public void getChildren(AccessibleControlEvent e) {
                Object[] children = new Object[CTabFolder.this.items.length];
                for (int i = 0; i < CTabFolder.this.items.length; ++i) {
                    children[i] = new Integer(i);
                }
                e.children = children;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int count = this.items.length;
                if (count == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int offset = event.keyCode == leadKey ? -1 : 1;
                int index = this.selectedIndex + offset;
                if (index < 0 || index >= count) {
                    return;
                }
                this.setSelection(index, true);
                this.forceFocus();
            }
        }
    }

    void onDispose() {
        this.inDispose = true;
        int length = this.items.length;
        for (int i = 0; i < length; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].dispose();
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
    }

    void onDragDetect(Event event) {
        boolean consume = false;
        if (this.chevronRect.contains(event.x, event.y) || this.minRect.contains(event.x, event.y) || this.maxRect.contains(event.x, event.y)) {
            consume = true;
        } else {
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].closeRect.contains(event.x, event.y)) continue;
                consume = true;
                break;
            }
        }
        if (consume) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event) {
        char key = event.character;
        for (int i = 0; i < this.items.length; ++i) {
            char mnemonic;
            if (this.items[i] == null || (mnemonic = this.getMnemonic(this.items[i].getText())) == '\u0000' || Character.toUpperCase(key) != Character.toUpperCase(mnemonic)) continue;
            this.setSelection(i, true);
            return true;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event e = new Event();
        e.item = this.getItem(new Point(event.x, event.y));
        if (e.item != null) {
            this.notifyListeners(14, e);
        }
    }

    void onMouseHover(Event event) {
        this.showToolTip(event.x, event.y);
    }

    void onMouse(Event event) {
        int x = event.x;
        int y = event.y;
        switch (event.type) {
            case 7: {
                if (this.minImageState != 1) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                for (int i = 0; i < this.items.length; ++i) {
                    CTabItem item = this.items[i];
                    if (i != this.selectedIndex && item.closeImageState != 0) {
                        item.closeImageState = 0;
                        this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    }
                    if (i != this.selectedIndex || item.closeImageState == 1) continue;
                    item.closeImageState = 1;
                    this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                }
                break;
            }
            case 3: {
                if (this.minRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.minImageState = 3;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    this.update();
                    return;
                }
                if (this.maxRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.maxImageState = 3;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.chevronImageState = this.chevronImageState != 2 ? 2 : 3;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                CTabItem item = null;
                if (this.single) {
                    Rectangle bounds;
                    if (this.selectedIndex != -1 && (bounds = this.items[this.selectedIndex].getBounds()).contains(x, y)) {
                        item = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i = 0; i < this.items.length; ++i) {
                        Rectangle bounds = this.items[i].getBounds();
                        if (!bounds.contains(x, y)) continue;
                        item = this.items[i];
                    }
                }
                if (item == null) break;
                if (item.closeRect.contains(x, y)) {
                    if (event.button != 1) {
                        return;
                    }
                    item.closeImageState = 3;
                    this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    this.update();
                    return;
                }
                int index = this.indexOf(item);
                if (item.isShowing()) {
                    this.setSelection(index, true);
                }
                return;
            }
            case 5: {
                boolean close = false;
                boolean minimize = false;
                boolean maximize = false;
                boolean chevron = false;
                if (this.minRect.contains(x, y)) {
                    minimize = true;
                    if (this.minImageState != 3 && this.minImageState != 2) {
                        this.minImageState = 2;
                        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    }
                }
                if (this.maxRect.contains(x, y)) {
                    maximize = true;
                    if (this.maxImageState != 3 && this.maxImageState != 2) {
                        this.maxImageState = 2;
                        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    }
                }
                if (this.chevronRect.contains(x, y)) {
                    chevron = true;
                    if (this.chevronImageState != 3 && this.chevronImageState != 2) {
                        this.chevronImageState = 2;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.minImageState != 1 && !minimize) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1 && !maximize) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1 && !chevron) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                for (int i = 0; i < this.items.length; ++i) {
                    CTabItem item = this.items[i];
                    close = false;
                    if (item.getBounds().contains(x, y)) {
                        close = true;
                        if (item.closeRect.contains(x, y)) {
                            if (item.closeImageState != 3 && item.closeImageState != 2) {
                                item.closeImageState = 2;
                                this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                            }
                        } else if (item.closeImageState != 1) {
                            item.closeImageState = 1;
                            this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                        }
                    }
                    if (i != this.selectedIndex && item.closeImageState != 0 && !close) {
                        item.closeImageState = 0;
                        this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                    }
                    if (i != this.selectedIndex || item.closeImageState == 1 || close) continue;
                    item.closeImageState = 1;
                    this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                }
                break;
            }
            case 4: {
                SWTEventListener listener;
                int j;
                if (event.button != 1) {
                    return;
                }
                if (this.chevronRect.contains(x, y)) {
                    boolean selected;
                    boolean bl = selected = this.chevronImageState == 3;
                    if (!selected) {
                        return;
                    }
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    e.x = this.chevronRect.x;
                    e.y = this.chevronRect.y;
                    e.width = this.chevronRect.width;
                    e.height = this.chevronRect.height;
                    e.doit = true;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        this.folderListeners[i].showList(e);
                    }
                    if (e.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                    Display display = this.getDisplay();
                    Point cursorLocation = display.getCursorLocation();
                    this.chevronImageState = this.chevronRect.contains(cursorLocation = display.map(null, (Control)this, cursorLocation)) ? 2 : 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    return;
                }
                if (this.minRect.contains(x, y)) {
                    boolean selected = this.minImageState == 3;
                    this.minImageState = 2;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    if (!selected) {
                        return;
                    }
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        if (this.minimized) {
                            this.folderListeners[i].restore(e);
                            continue;
                        }
                        this.folderListeners[i].minimize(e);
                    }
                    return;
                }
                if (this.maxRect.contains(x, y)) {
                    boolean selected = this.maxImageState == 3;
                    this.maxImageState = 2;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    if (!selected) {
                        return;
                    }
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        if (this.maximized) {
                            this.folderListeners[i].restore(e);
                            continue;
                        }
                        this.folderListeners[i].maximize(e);
                    }
                    return;
                }
                CTabItem item = null;
                if (this.single) {
                    Rectangle bounds;
                    if (this.selectedIndex != -1 && (bounds = this.items[this.selectedIndex].getBounds()).contains(x, y)) {
                        item = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i = 0; i < this.items.length; ++i) {
                        Rectangle bounds = this.items[i].getBounds();
                        if (!bounds.contains(x, y)) continue;
                        item = this.items[i];
                    }
                }
                if (item == null || !item.closeRect.contains(x, y)) break;
                boolean selected = item.closeImageState == 3;
                item.closeImageState = 2;
                this.redraw(item.closeRect.x, item.closeRect.y, item.closeRect.width, item.closeRect.height, false);
                if (!selected) {
                    return;
                }
                CTabFolderEvent e = new CTabFolderEvent(this);
                e.widget = this;
                e.time = event.time;
                e.item = item;
                e.doit = true;
                for (j = 0; j < this.folderListeners.length; ++j) {
                    listener = this.folderListeners[j];
                    listener.close(e);
                }
                for (j = 0; j < this.tabListeners.length; ++j) {
                    listener = this.tabListeners[j];
                    listener.itemClosed(e);
                }
                if (e.doit) {
                    item.dispose();
                }
                return;
            }
        }
    }

    boolean onPageTraversal(Event event) {
        int count = this.items.length;
        if (count == 0) {
            return false;
        }
        int index = this.selectedIndex;
        if (index == -1) {
            index = 0;
        } else {
            int offset = event.detail == 512 ? 1 : -1;
            index = (this.selectedIndex + offset + count) % count;
        }
        this.setSelection(index, true);
        return true;
    }

    void onPaint(Event event) {
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gc = event.gc;
        Font gcFont = gc.getFont();
        Color gcBackground = gc.getBackground();
        Color gcForeground = gc.getForeground();
        this.drawBody(event);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
        this.drawTabArea(event);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
    }

    void onResize() {
        Control control;
        if (this.updateItems()) {
            this.redrawTabs();
        }
        this.showSelection();
        Point size = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && size.y != this.oldSize.y) {
            this.redraw();
        } else {
            int x1 = Math.min(size.x, this.oldSize.x);
            if (size.x != this.oldSize.x) {
                x1 -= this.borderRight + this.highlight_margin;
            }
            if (!this.simple) {
                x1 -= 5;
            }
            int y1 = Math.min(size.y, this.oldSize.y);
            if (size.y != this.oldSize.y) {
                y1 -= this.borderBottom + this.highlight_margin;
            }
            int x2 = Math.max(size.x, this.oldSize.x);
            int y2 = Math.max(size.y, this.oldSize.y);
            this.redraw(0, y1, x2, y2 - y1, false);
            this.redraw(x1, 0, x2 - x1, y2, false);
        }
        this.oldSize = size;
        if (this.selectedIndex != -1 && (control = this.items[this.selectedIndex].getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
        }
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event);
                if (!event.doit) break;
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point size = this.getSize();
        if (this.onBottom) {
            this.redraw(0, size.y - this.borderBottom - this.tabHeight - this.highlight_header - 1, size.x, this.borderBottom + this.tabHeight + this.highlight_header + 1, false);
        } else {
            this.redraw(0, 0, size.x, this.borderTop + this.tabHeight + this.highlight_header + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.folderListeners.length; ++i) {
            if (listener != this.folderListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] newTabListeners = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.folderListeners, index + 1, newTabListeners, index, this.folderListeners.length - index - 1);
        this.folderListeners = newTabListeners;
    }

    public void removeCTabFolderListener(CTabFolderListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.tabListeners.length; ++i) {
            if (listener != this.tabListeners[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.tabListeners, index + 1, newTabListeners, index, this.tabListeners.length - index - 1);
        this.tabListeners = newTabListeners;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    void setBackground(Color[] colors, int[] percents, boolean vertical) {
        int i;
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            for (i = 0; i < percents.length; ++i) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i <= 0 || percents[i] >= percents[i - 1]) continue;
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
        }
        if (this.bgImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                int i2;
                boolean same = false;
                for (i2 = 0; i2 < this.gradientColors.length && (same = this.gradientColors[i2] == null ? colors[i2] == null : this.gradientColors[i2].equals(colors[i2])); ++i2) {
                }
                if (same) {
                    for (i2 = 0; i2 < this.gradientPercents.length; ++i2) {
                        boolean bl = same = this.gradientPercents[i2] == percents[i2];
                        if (!same) break;
                    }
                }
                if (same && this.gradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.bgImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground((Color)null);
        } else {
            this.gradientColors = new Color[colors.length];
            for (i = 0; i < colors.length; ++i) {
                this.gradientColors[i] = colors[i];
            }
            this.gradientPercents = new int[percents.length];
            for (i = 0; i < percents.length; ++i) {
                this.gradientPercents[i] = percents[i];
            }
            this.gradientVertical = vertical;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    void setBackground(Image image) {
        this.checkWidget();
        if (image == this.bgImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.bgImage = image;
        this.redraw();
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.borderLeft == 1 == show) {
            return;
        }
        this.borderRight = show ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        Rectangle rectBefore = this.getClientArea();
        this.updateItems();
        Rectangle rectAfter = this.getClientArea();
        if (!rectBefore.equals(rectAfter)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds() {
        int top;
        int right;
        int left;
        Point size = this.getSize();
        int oldX = this.maxRect.x;
        int oldY = this.maxRect.y;
        int oldWidth = this.maxRect.width;
        int oldHeight = this.maxRect.height;
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            this.maxRect.x = size.x - this.borderRight - 16 - 3;
            if (this.borderRight > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 16) / 2 : this.borderTop + (this.tabHeight - 16) / 2;
            this.maxRect.width = 16;
            this.maxRect.height = 16;
        }
        if (oldX != this.maxRect.x || oldWidth != this.maxRect.width || oldY != this.maxRect.y || oldHeight != this.maxRect.height) {
            left = Math.min(oldX, this.maxRect.x);
            right = Math.max(oldX + oldWidth, this.maxRect.x + this.maxRect.width);
            top = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left, top, right - left, this.tabHeight, false);
        }
        oldX = this.minRect.x;
        oldY = this.minRect.y;
        oldWidth = this.minRect.width;
        oldHeight = this.minRect.height;
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            this.minRect.x = size.x - this.borderRight - this.maxRect.width - 16 - 3;
            if (this.borderRight > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 16) / 2 : this.borderTop + (this.tabHeight - 16) / 2;
            this.minRect.width = 16;
            this.minRect.height = 16;
        }
        if (oldX != this.minRect.x || oldWidth != this.minRect.width || oldY != this.minRect.y || oldHeight != this.minRect.height) {
            left = Math.min(oldX, this.minRect.x);
            right = Math.max(oldX + oldWidth, this.minRect.x + this.minRect.width);
            top = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left, top, right - left, this.tabHeight, false);
        }
        oldX = this.topRightRect.x;
        oldY = this.topRightRect.y;
        oldWidth = this.topRightRect.width;
        oldHeight = this.topRightRect.height;
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    int rightEdge = size.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (this.single) {
                        if (this.items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = this.borderLeft + 3;
                            this.topRightRect.width = rightEdge - this.topRightRect.x;
                        } else {
                            CTabItem item = this.items[this.selectedIndex];
                            if (item.x + item.width + 7 + 24 >= rightEdge) break;
                            this.topRightRect.x = item.x + item.width + 7 + 24;
                            this.topRightRect.width = rightEdge - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (this.items.length == 0) {
                            this.topRightRect.x = this.borderLeft + 3;
                        } else {
                            CTabItem item = this.items[this.items.length - 1];
                            this.topRightRect.x = item.x + item.width;
                            if (!this.simple && this.items.length - 1 == this.selectedIndex) {
                                this.topRightRect.x += this.curveWidth - this.curveIndent;
                            }
                        }
                        this.topRightRect.width = Math.max(0, rightEdge - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point topRightSize = this.topRight.computeSize(-1, this.tabHeight);
                    int rightEdge = size.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    this.topRightRect.x = rightEdge - topRightSize.x;
                    this.topRightRect.width = topRightSize.x;
                    this.topRightRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        if (oldX != this.topRightRect.x || oldWidth != this.topRightRect.width || oldY != this.topRightRect.y || oldHeight != this.topRightRect.height) {
            // empty if block
        }
        oldX = this.chevronRect.x;
        oldY = this.chevronRect.y;
        oldWidth = this.chevronRect.width;
        oldHeight = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.single) {
            if (this.selectedIndex == -1 || this.items.length > 1) {
                this.chevronRect.width = 24;
                this.chevronRect.height = 16;
                int n = this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = size.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem item = this.items[this.selectedIndex];
                    int w = size.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        w -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(item.x + item.width + 3, w);
                }
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = 24;
            this.chevronRect.height = 16;
            int lastIndex = this.getLastIndex();
            CTabItem lastItem = this.items[lastIndex];
            int w = lastItem.x + lastItem.width + 3;
            if (!this.simple && lastIndex == this.selectedIndex) {
                w += this.curveWidth - 2 * this.curveIndent;
            }
            this.chevronRect.x = Math.min(w, this.getRightItemEdge());
            int n = this.chevronRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
        }
        if (oldX != this.chevronRect.x || oldWidth != this.chevronRect.width || oldY != this.chevronRect.y || oldHeight != this.chevronRect.height) {
            int left2 = Math.min(oldX, this.chevronRect.x);
            int right2 = Math.max(oldX + oldWidth, this.chevronRect.x + this.chevronRect.width);
            top = this.onBottom ? size.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(left2, top, right2 - left2, this.tabHeight, false);
        }
    }

    void setFirstItem(int index) {
        if (index < 0 || index > this.items.length - 1) {
            return;
        }
        if (index == this.firstIndex) {
            return;
        }
        this.firstIndex = index;
        this.setItemLocation();
        this.setButtonBounds();
        this.redrawTabs();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem item, boolean after) {
        this.checkWidget();
        int index = -1;
        if (item != null) {
            index = this.indexOf(item);
        }
        this.setInsertMark(index, after);
    }

    public void setInsertMark(int index, boolean after) {
        this.checkWidget();
        if (index < -1 || index >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation() {
        int y;
        boolean changed = false;
        if (this.items.length == 0) {
            return false;
        }
        Point size = this.getSize();
        int n = y = this.onBottom ? Math.max(this.borderBottom, size.y - this.borderBottom - this.tabHeight) : this.borderTop;
        if (this.single) {
            int defaultX = size.x + 10;
            for (int i = 0; i < this.items.length; ++i) {
                if (i == this.selectedIndex) {
                    CTabItem item = this.items[this.selectedIndex];
                    int oldX = item.x;
                    int oldY = item.y;
                    item.x = this.borderLeft;
                    item.y = y;
                    if (this.showClose || item.showClose) {
                        item.closeRect.x = this.borderLeft + 4;
                        int n2 = item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 16) / 2 : this.borderTop + (this.tabHeight - 16) / 2;
                    }
                    if (item.x == oldX && item.y == oldY) continue;
                    changed = true;
                    continue;
                }
                this.items[i].x = defaultX;
            }
        } else {
            int x = -1;
            for (int i = this.firstIndex - 1; i >= 0; --i) {
                CTabItem item = this.items[i];
                item.x = x -= item.width;
                item.y = y;
                item.closeRect.x = item.x + item.width - 16 - 4;
                item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 16) / 2 : this.borderTop + (this.tabHeight - 16) / 2;
            }
            x = 0;
            int rightItemEdge = this.getRightItemEdge();
            for (int i = this.firstIndex; i < this.items.length; ++i) {
                CTabItem item = this.items[i];
                if (item.x != x || item.y != y) {
                    changed = true;
                }
                item.x = x;
                item.y = y;
                if (i == this.selectedIndex) {
                    int edge = Math.min(item.x + item.width, rightItemEdge);
                    item.closeRect.x = edge - 4 - 16;
                } else {
                    item.closeRect.x = item.x + item.width - 4 - 16;
                }
                item.closeRect.y = this.onBottom ? size.y - this.borderBottom - this.tabHeight + (this.tabHeight - 16) / 2 : this.borderTop + (this.tabHeight - 16) / 2;
                x += item.width;
                if (this.simple || i != this.selectedIndex) continue;
                x += this.curveWidth - 2 * this.curveIndent;
            }
        }
        return changed;
    }

    boolean setItemSize() {
        int i;
        boolean changed = false;
        if (this.isDisposed()) {
            return changed;
        }
        this.showChevron = false;
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return changed;
        }
        this.xClient = this.borderLeft + this.marginWidth + this.highlight_margin;
        this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem tab = this.items[this.selectedIndex];
                GC gc = new GC(this);
                int width = tab.preferredWidth(gc, true, false);
                gc.dispose();
                width = Math.min(width, this.getRightItemEdge() - this.borderLeft);
                if (tab.height != this.tabHeight || tab.width != width) {
                    changed = true;
                    tab.shortenedText = null;
                    tab.shortenedTextWidth = 0;
                    tab.height = this.tabHeight;
                    tab.width = width;
                    tab.closeRect.height = 0;
                    tab.closeRect.width = 0;
                    if (this.showClose || tab.showClose) {
                        tab.closeRect.width = 16;
                        tab.closeRect.height = 16;
                    }
                }
            }
            return changed;
        }
        int[] widths = new int[this.items.length];
        widths = new int[this.items.length];
        GC gc = new GC(this);
        for (i = 0; i < this.items.length; ++i) {
            widths[i] = this.items[i].preferredWidth(gc, i == this.selectedIndex, false);
        }
        if (this.items.length > 0) {
            int totalWidth = 0;
            int tabAreaWidth = size.x - this.borderLeft - this.borderRight - 3;
            if (this.showMin) {
                tabAreaWidth -= 16;
            }
            if (this.showMax) {
                tabAreaWidth -= 16;
            }
            if (this.topRightAlignment == 131072 && this.topRight != null) {
                tabAreaWidth -= this.topRight.computeSize((int)-1, (int)-1).x + 3;
            }
            if (!this.simple) {
                tabAreaWidth -= this.curveWidth - 2 * this.curveIndent;
            }
            tabAreaWidth = Math.max(0, tabAreaWidth);
            int count = this.items.length;
            for (int i2 = 0; i2 < count; ++i2) {
                totalWidth += widths[i2];
            }
            if (totalWidth <= tabAreaWidth) {
                this.firstIndex = 0;
            } else {
                int i3;
                totalWidth = 0;
                int large = 0;
                int[] minWidths = new int[this.items.length];
                for (i3 = 0; i3 < count; ++i3) {
                    minWidths[i3] = this.items[i3].preferredWidth(gc, i3 == this.selectedIndex, true);
                    totalWidth += Math.min(widths[i3], minWidths[i3]);
                    if (widths[i3] <= minWidths[i3]) continue;
                    ++large;
                }
                if (totalWidth > tabAreaWidth) {
                    boolean bl = this.showChevron = this.items.length > 1;
                    if (this.showChevron) {
                        tabAreaWidth -= 24;
                    }
                    for (i3 = 0; i3 < count; ++i3) {
                        int minWidth = Math.min(tabAreaWidth, minWidths[i3]);
                        widths[i3] = Math.min(widths[i3], minWidth);
                    }
                } else {
                    int i4;
                    this.firstIndex = 0;
                    int extra = (tabAreaWidth - totalWidth) / large;
                    while (true) {
                        totalWidth = 0;
                        large = 0;
                        for (i4 = 0; i4 < count; ++i4) {
                            totalWidth += Math.min(widths[i4], minWidths[i4] + extra);
                            if (widths[i4] <= minWidths[i4] + extra) continue;
                            ++large;
                        }
                        if (totalWidth >= tabAreaWidth) {
                            --extra;
                            break;
                        }
                        if (large == 0 || tabAreaWidth - totalWidth < large) break;
                        ++extra;
                    }
                    for (i4 = 0; i4 < this.items.length; ++i4) {
                        widths[i4] = Math.min(widths[i4], minWidths[i4] + extra);
                    }
                }
            }
        }
        for (i = 0; i < this.items.length; ++i) {
            CTabItem tab = this.items[i];
            int width = widths[i];
            if (tab.height == this.tabHeight && tab.width == width) continue;
            changed = true;
            tab.shortenedText = null;
            tab.shortenedTextWidth = 0;
            tab.height = this.tabHeight;
            tab.width = width;
            tab.closeRect.height = 0;
            tab.closeRect.width = 0;
            if (!this.showClose && !tab.showClose || i != this.selectedIndex && !this.showUnselectedClose) continue;
            tab.closeRect.width = 16;
            tab.closeRect.height = 16;
        }
        gc.dispose();
        return changed;
    }

    void setLastIndex(int index) {
        if (!this.showChevron || this.single || index < 0 || index > this.items.length - 1) {
            return;
        }
        Point size = this.getSize();
        if (size.x <= 0) {
            return;
        }
        int maxWidth = this.getRightItemEdge() - this.borderLeft;
        if (!this.single && !this.simple) {
            maxWidth -= this.curveWidth - 2 * this.curveIndent;
        }
        int tabWidth = this.items[index].width;
        while (index > 0 && (tabWidth += this.items[index - 1].width) <= maxWidth) {
            --index;
        }
        if (this.firstIndex == index) {
            return;
        }
        this.firstIndex = index;
        this.setItemLocation();
        this.setButtonBounds();
        this.redrawTabs();
    }

    public void setMaximizeVisible(boolean visible) {
        this.checkWidget();
        if (this.showMax == visible) {
            return;
        }
        this.showMax = visible;
        this.updateItems();
        this.redraw();
    }

    public void setMaximized(boolean maximize) {
        this.checkWidget();
        if (this.maximized == maximize) {
            return;
        }
        if (maximize && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = maximize;
        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
    }

    public void setMinimizeVisible(boolean visible) {
        this.checkWidget();
        if (this.showMin == visible) {
            return;
        }
        this.showMin = visible;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean minimize) {
        this.checkWidget();
        if (this.minimized == minimize) {
            return;
        }
        if (minimize && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = minimize;
        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
    }

    public void setMinimumCharacters(int count) {
        this.checkWidget();
        if (count < 0) {
            SWT.error(6);
        }
        if (this.minChars == count) {
            return;
        }
        this.minChars = count;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setSelection(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        int index = this.indexOf(item);
        this.setSelection(index);
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (this.selectedIndex == index) {
            this.showItem(this.items[index]);
            return;
        }
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        if (oldIndex != -1) {
            this.items[oldIndex].closeImageState = 0;
        }
        this.items[this.selectedIndex].closeImageState = 1;
        Control control = this.items[index].control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (oldIndex != -1 && (control = this.items[oldIndex].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.updateItems();
        this.redraw();
    }

    void setSelection(int index, boolean notify) {
        int oldSelectedIndex = this.selectedIndex;
        this.setSelection(index);
        if (notify && this.selectedIndex != oldSelectedIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colors, int[] percents) {
        this.setSelectionBackground(colors, percents, false);
    }

    public void setSelectionBackground(Color[] colors, int[] percents, boolean vertical) {
        int i;
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            for (i = 0; i < percents.length; ++i) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i <= 0 || percents[i] >= percents[i - 1]) continue;
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colors != null && this.selectionGradientColors.length == colors.length) {
                int i2;
                boolean same = false;
                for (i2 = 0; i2 < this.selectionGradientColors.length && (same = this.selectionGradientColors[i2] == null ? colors[i2] == null : this.selectionGradientColors[i2].equals(colors[i2])); ++i2) {
                }
                if (same) {
                    for (i2 = 0; i2 < this.selectionGradientPercents.length; ++i2) {
                        boolean bl = same = this.selectionGradientPercents[i2] == percents[i2];
                        if (!same) break;
                    }
                }
                if (same && this.selectionGradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colors == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
        } else {
            this.selectionGradientColors = new Color[colors.length];
            for (i = 0; i < colors.length; ++i) {
                this.selectionGradientColors[i] = colors[i];
            }
            this.selectionGradientPercents = new int[percents.length];
            for (i = 0; i < percents.length; ++i) {
                this.selectionGradientPercents[i] = percents[i];
            }
            this.selectionGradientVertical = vertical;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
        }
        this.selectionBgImage = image;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSimple(boolean simple) {
        this.checkWidget();
        if (this.simple != simple) {
            this.simple = simple;
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            if (!rectBefore.equals(rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean single) {
        this.checkWidget();
        if (this.single != single) {
            this.single = single;
            if (!single) {
                for (int i = 0; i < this.items.length; ++i) {
                    if (i == this.selectedIndex || this.items[i].closeImageState != 1) continue;
                    this.items[i].closeImageState = 0;
                }
            }
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            if (!rectBefore.equals(rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTabHeight(int height) {
        this.checkWidget();
        if (height < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = height;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int position) {
        this.checkWidget();
        if (position != 128 && position != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (position == 1024)) {
            this.onBottom = position == 1024;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderRight;
            this.updateTabHeight(true);
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            if (!rectBefore.equals(rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int alignment) {
        this.checkWidget();
        if (alignment != 131072 && alignment != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        this.topRight = control;
        this.topRightAlignment = alignment;
        if (this.updateItems()) {
            this.redraw();
        }
    }

    public void setUnselectedCloseVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedClose == visible) {
            return;
        }
        this.showUnselectedClose = visible;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedImage == visible) {
            return;
        }
        this.showUnselectedImage = visible;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if (item.isShowing()) {
            return;
        }
        Point size = this.getSize();
        int index = this.indexOf(item);
        if (size.x <= this.borderLeft + this.borderRight || index < this.firstIndex) {
            this.setFirstItem(index);
        } else {
            this.setLastIndex(index);
        }
    }

    void showList(Rectangle rect) {
        if (this.items.length == 0) {
            return;
        }
        int lastIndex = this.getLastIndex();
        if (!this.single && this.firstIndex == 0 && lastIndex == this.items.length - 1) {
            return;
        }
        if (this.single && this.items.length == 1 && this.selectedIndex != -1) {
            return;
        }
        Menu menu = new Menu(this);
        String id = "CTabFolder_showList_Index";
        for (int i = 0; i < this.items.length; ++i) {
            if (this.single ? i == this.selectedIndex : i >= this.firstIndex && i <= lastIndex) continue;
            CTabItem tab = this.items[i];
            MenuItem item = new MenuItem(menu, 0);
            item.setText(tab.getText());
            item.setImage(tab.getImage());
            item.setData("CTabFolder_showList_Index", tab);
            item.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.widget;
                    int index = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                    CTabFolder.this.setSelection(index, true);
                }
            });
        }
        int x = rect.x;
        int y = rect.y + rect.height;
        Point location = this.getDisplay().map(this, null, x, y);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
        Display display = this.getDisplay();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void hideToolTip() {
        if (this.toolTipShell == null) {
            return;
        }
        for (int i = 0; i < this.toolTipEvents.length; ++i) {
            this.removeListener(this.toolTipEvents[i], this.toolTipListener);
        }
        this.toolTipShell.dispose();
        this.toolTipShell = null;
        this.toolTipLabel = null;
    }

    void showToolTip(int x, int y) {
        if (this.toolTipShell == null) {
            this.toolTipShell = new Shell(this.getShell(), 16384);
            this.toolTipLabel = new Label(this.toolTipShell, 0x1000000);
            Display display = this.toolTipShell.getDisplay();
            this.toolTipLabel.setForeground(display.getSystemColor(28));
            this.toolTipLabel.setBackground(display.getSystemColor(29));
            for (int i = 0; i < this.toolTipEvents.length; ++i) {
                this.addListener(this.toolTipEvents[i], this.toolTipListener);
            }
        }
        if (this.updateToolTip(x, y)) {
            this.toolTipShell.setVisible(true);
        } else {
            this.hideToolTip();
        }
    }

    boolean updateItems() {
        boolean changed = false;
        boolean oldShowChevron = this.showChevron;
        if (this.setItemSize()) {
            changed = true;
        }
        if (this.setItemLocation()) {
            changed = true;
        }
        if (this.items.length > 0) {
            CTabItem item = this.items[this.items.length - 1];
            if (item.x + item.width < this.getRightItemEdge()) {
                int first = this.firstIndex;
                this.setLastIndex(this.items.length - 1);
                if (first != this.firstIndex) {
                    changed = true;
                }
            }
        }
        this.setButtonBounds();
        if (this.selectedIndex != -1) {
            int top = this.firstIndex;
            this.showItem(this.items[this.selectedIndex]);
            if (top != this.firstIndex) {
                changed = true;
            }
        }
        if (this.showChevron != oldShowChevron) {
            changed = true;
        }
        if (changed && this.toolTipShell != null) {
            Point pt = this.getDisplay().getCursorLocation();
            pt = this.toControl(pt);
            if (!this.updateToolTip(pt.x, pt.y)) {
                this.hideToolTip();
            }
        }
        return changed;
    }

    boolean updateTabHeight(boolean force) {
        int d;
        int oldHeight = this.tabHeight;
        if (this.fixedTabHeight != -1) {
            this.tabHeight = this.fixedTabHeight == 0 ? 0 : this.fixedTabHeight + 1;
        } else {
            int tempHeight = 0;
            GC gc = new GC(this);
            for (int i = 0; i < this.items.length; ++i) {
                tempHeight = Math.max(tempHeight, this.items[i].preferredHeight(gc));
            }
            gc.dispose();
            this.tabHeight = tempHeight;
        }
        if (!force && this.tabHeight == oldHeight) {
            return false;
        }
        this.oldSize = null;
        if (this.onBottom) {
            d = this.tabHeight - 12;
            this.curve = new int[]{0, 13 + d, 0, 12 + d, 2, 12 + d, 3, 11 + d, 5, 11 + d, 6, 10 + d, 7, 10 + d, 9, 8 + d, 10, 8 + d, 11, 7 + d, 11 + d, 7, 12 + d, 6, 13 + d, 6, 15 + d, 4, 16 + d, 4, 17 + d, 3, 19 + d, 3, 20 + d, 2, 22 + d, 2, 23 + d, 1};
            this.curveWidth = 26 + d;
            this.curveIndent = this.curveWidth / 3;
        } else {
            d = this.tabHeight - 12;
            this.curve = new int[]{0, 0, 0, 1, 2, 1, 3, 2, 5, 2, 6, 3, 7, 3, 9, 5, 10, 5, 11, 6, 11 + d, 6 + d, 12 + d, 7 + d, 13 + d, 7 + d, 15 + d, 9 + d, 16 + d, 9 + d, 17 + d, 10 + d, 19 + d, 10 + d, 20 + d, 11 + d, 22 + d, 11 + d, 23 + d, 12 + d};
            this.curveWidth = 26 + d;
            this.curveIndent = this.curveWidth / 3;
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    String _getToolTip(int x, int y) {
        if (this.showMin && this.minRect.contains(x, y)) {
            return this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
        }
        if (this.showMax && this.maxRect.contains(x, y)) {
            return this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
        }
        if (this.showChevron && this.chevronRect.contains(x, y)) {
            return SWT.getMessage("SWT_ShowList");
        }
        CTabItem item = this.getItem(new Point(x, y));
        if (item == null) {
            return null;
        }
        if (!item.isShowing()) {
            return null;
        }
        if ((this.showClose || item.showClose) && item.closeRect.contains(x, y)) {
            return SWT.getMessage("SWT_Close");
        }
        return item.getToolTipText();
    }

    boolean updateToolTip(int x, int y) {
        String tooltip = this._getToolTip(x, y);
        if (tooltip == null) {
            return false;
        }
        if (tooltip.equals(this.toolTipLabel.getText())) {
            return true;
        }
        this.toolTipLabel.setText(tooltip);
        Point labelSize = this.toolTipLabel.computeSize(-1, -1);
        labelSize.x += 2;
        labelSize.y += 2;
        this.toolTipLabel.setSize(labelSize);
        this.toolTipShell.pack();
        Rectangle area = this.toolTipShell.getClientArea();
        this.toolTipLabel.setSize(area.width, area.height);
        Point cursorLocation = this.getDisplay().getCursorLocation();
        int cursorHeight = 21;
        Point size = this.toolTipShell.getSize();
        Rectangle rect = this.getMonitor().getBounds();
        Point pt = new Point(cursorLocation.x, cursorLocation.y + cursorHeight + 2);
        pt.x = Math.max(pt.x, rect.x);
        if (pt.x + size.x > rect.x + rect.width) {
            pt.x = rect.x + rect.width - size.x;
        }
        if (pt.y + size.y > rect.y + rect.height) {
            pt.y = cursorLocation.y - 2 - size.y;
        }
        this.toolTipShell.setLocation(pt);
        return true;
    }

    static {
        TOP_LEFT_CORNER = new int[]{0, 6, 1, 5, 1, 4, 4, 1, 5, 1, 6, 0};
        TOP_RIGHT_CORNER = new int[]{-6, 0, -5, 1, -4, 1, -1, 4, -1, 5, 0, 6};
        BOTTOM_LEFT_CORNER = new int[]{0, -6, 1, -5, 1, -4, 4, -1, 5, -1, 6, 0};
        BOTTOM_RIGHT_CORNER = new int[]{-6, 0, -5, -1, -4, -1, -1, -4, -1, -5, 0, -6};
        SIMPLE_TOP_LEFT_CORNER = new int[]{0, 2, 1, 1, 2, 0};
        SIMPLE_TOP_RIGHT_CORNER = new int[]{-2, 0, -1, 1, 0, 2};
        SIMPLE_BOTTOM_LEFT_CORNER = new int[]{0, -2, 1, -1, 2, 0};
        SIMPLE_BOTTOM_RIGHT_CORNER = new int[]{-2, 0, -1, -1, 0, -2};
        CLOSE_FILL = new RGB(252, 160, 160);
    }
}

