/*	$NetBSD: ether_calls.h,v 1.2 2025/10/12 23:41:42 thorpej Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	NetBSD: ether_calls,v 1.1 2025/10/12 23:41:08 thorpej Exp
 */

/*-
 * Copyright (c) 2025 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Device calls used by the Ethernet subsystem.
 */

#ifndef _ETHER_CALLS_H_
#define _ETHER_CALLS_H_

#include <sys/device.h>

#include <net/if_ether.h>

/*
 * ether-get-mac-address
 *
 * Retrieve the MAC address for the Ethernet interface associated
 * with the device handle.
 *
 * While it is common for platform device trees to provide the MAC
 * address in a property, some platforms may use single system-wide
 * MAC address in addition to interface-specific addresses, and the
 * rules about which one to use on a given interface are encoded into
 * the device tree itself, hence this hook.
 */
struct ether_get_mac_address_args {
	/* This buffer is assumed to be ETHER_ADDR_LEN bytes in size. */
	uint8_t *	enaddr;		/* OUT */
};

union ether_get_mac_address_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct ether_get_mac_address_args *args;
	} binding;
};

#define ETHER_GET_MAC_ADDRESS_STR "ether-get-mac-address"

#define ETHER_GET_MAC_ADDRESS(_args_) \
	&((const union ether_get_mac_address_binding){ \
		.binding.name = "ether-get-mac-address", \
		.binding.args = (_args_), \
	})

#endif /* _ETHER_CALLS_H_ */
