/*	$NetBSD: samsung,exynosautov920.h,v 1.1.1.1 2026/01/18 05:21:41 skrll Exp $	*/

/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2024 Samsung Electronics Co., Ltd.
 * Author: Sunyeal Hong <sunyeal.hong@samsung.com>
 *
 * Device Tree binding constants for ExynosAuto v920 clock controller.
 */

#ifndef _DT_BINDINGS_CLOCK_EXYNOSAUTOV920_H
#define _DT_BINDINGS_CLOCK_EXYNOSAUTOV920_H

/* CMU_TOP */
#define FOUT_SHARED0_PLL		1
#define FOUT_SHARED1_PLL		2
#define FOUT_SHARED2_PLL		3
#define FOUT_SHARED3_PLL		4
#define FOUT_SHARED4_PLL		5
#define FOUT_SHARED5_PLL		6
#define FOUT_MMC_PLL			7

/* MUX in CMU_TOP */
#define MOUT_SHARED0_PLL		8
#define MOUT_SHARED1_PLL		9
#define MOUT_SHARED2_PLL		10
#define MOUT_SHARED3_PLL		11
#define MOUT_SHARED4_PLL		12
#define MOUT_SHARED5_PLL		13
#define MOUT_MMC_PLL			14
#define MOUT_CLKCMU_CMU_BOOST		15
#define MOUT_CLKCMU_CMU_CMUREF		16
#define MOUT_CLKCMU_ACC_NOC		17
#define MOUT_CLKCMU_ACC_ORB		18
#define MOUT_CLKCMU_APM_NOC		19
#define MOUT_CLKCMU_AUD_CPU		20
#define MOUT_CLKCMU_AUD_NOC		21
#define MOUT_CLKCMU_CPUCL0_SWITCH	22
#define MOUT_CLKCMU_CPUCL0_CLUSTER	23
#define MOUT_CLKCMU_CPUCL0_DBG		24
#define MOUT_CLKCMU_CPUCL1_SWITCH	25
#define MOUT_CLKCMU_CPUCL1_CLUSTER	26
#define MOUT_CLKCMU_CPUCL2_SWITCH	27
#define MOUT_CLKCMU_CPUCL2_CLUSTER	28
#define MOUT_CLKCMU_DNC_NOC		29
#define MOUT_CLKCMU_DPTX_NOC		30
#define MOUT_CLKCMU_DPTX_DPGTC		31
#define MOUT_CLKCMU_DPTX_DPOSC		32
#define MOUT_CLKCMU_DPUB_NOC		33
#define MOUT_CLKCMU_DPUB_DSIM		34
#define MOUT_CLKCMU_DPUF0_NOC		35
#define MOUT_CLKCMU_DPUF1_NOC		36
#define MOUT_CLKCMU_DPUF2_NOC		37
#define MOUT_CLKCMU_DSP_NOC		38
#define MOUT_CLKCMU_G3D_SWITCH		39
#define MOUT_CLKCMU_G3D_NOCP		40
#define MOUT_CLKCMU_GNPU_NOC		41
#define MOUT_CLKCMU_HSI0_NOC		42
#define MOUT_CLKCMU_HSI1_NOC		43
#define MOUT_CLKCMU_HSI1_USBDRD		44
#define MOUT_CLKCMU_HSI1_MMC_CARD	45
#define MOUT_CLKCMU_HSI2_NOC		46
#define MOUT_CLKCMU_HSI2_NOC_UFS	47
#define MOUT_CLKCMU_HSI2_UFS_EMBD	48
#define MOUT_CLKCMU_HSI2_ETHERNET	49
#define MOUT_CLKCMU_ISP_NOC		50
#define MOUT_CLKCMU_M2M_NOC		51
#define MOUT_CLKCMU_M2M_JPEG		52
#define MOUT_CLKCMU_MFC_MFC		53
#define MOUT_CLKCMU_MFC_WFD		54
#define MOUT_CLKCMU_MFD_NOC		55
#define MOUT_CLKCMU_MIF_SWITCH		56
#define MOUT_CLKCMU_MIF_NOCP		57
#define MOUT_CLKCMU_MISC_NOC		58
#define MOUT_CLKCMU_NOCL0_NOC		59
#define MOUT_CLKCMU_NOCL1_NOC		60
#define MOUT_CLKCMU_NOCL2_NOC		61
#define MOUT_CLKCMU_PERIC0_NOC		62
#define MOUT_CLKCMU_PERIC0_IP		63
#define MOUT_CLKCMU_PERIC1_NOC		64
#define MOUT_CLKCMU_PERIC1_IP		65
#define MOUT_CLKCMU_SDMA_NOC		66
#define MOUT_CLKCMU_SNW_NOC		67
#define MOUT_CLKCMU_SSP_NOC		68
#define MOUT_CLKCMU_TAA_NOC		69

/* DIV in CMU_TOP */
#define DOUT_SHARED0_DIV1		70
#define DOUT_SHARED0_DIV2		71
#define DOUT_SHARED0_DIV3		72
#define DOUT_SHARED0_DIV4		73
#define DOUT_SHARED1_DIV1		74
#define DOUT_SHARED1_DIV2		75
#define DOUT_SHARED1_DIV3		76
#define DOUT_SHARED1_DIV4		77
#define DOUT_SHARED2_DIV1		78
#define DOUT_SHARED2_DIV2		79
#define DOUT_SHARED2_DIV3		80
#define DOUT_SHARED2_DIV4		81
#define DOUT_SHARED3_DIV1		82
#define DOUT_SHARED3_DIV2		83
#define DOUT_SHARED3_DIV3		84
#define DOUT_SHARED3_DIV4		85
#define DOUT_SHARED4_DIV1		86
#define DOUT_SHARED4_DIV2		87
#define DOUT_SHARED4_DIV3		88
#define DOUT_SHARED4_DIV4		89
#define DOUT_SHARED5_DIV1		90
#define DOUT_SHARED5_DIV2		91
#define DOUT_SHARED5_DIV3		92
#define DOUT_SHARED5_DIV4		93
#define DOUT_CLKCMU_CMU_BOOST		94
#define DOUT_CLKCMU_ACC_NOC		95
#define DOUT_CLKCMU_ACC_ORB		96
#define DOUT_CLKCMU_APM_NOC		97
#define DOUT_CLKCMU_AUD_CPU		98
#define DOUT_CLKCMU_AUD_NOC		99
#define DOUT_CLKCMU_CPUCL0_SWITCH	100
#define DOUT_CLKCMU_CPUCL0_CLUSTER	101
#define DOUT_CLKCMU_CPUCL0_DBG		102
#define DOUT_CLKCMU_CPUCL1_SWITCH	103
#define DOUT_CLKCMU_CPUCL1_CLUSTER	104
#define DOUT_CLKCMU_CPUCL2_SWITCH	105
#define DOUT_CLKCMU_CPUCL2_CLUSTER	106
#define DOUT_CLKCMU_DNC_NOC		107
#define DOUT_CLKCMU_DPTX_NOC		108
#define DOUT_CLKCMU_DPTX_DPGTC		109
#define DOUT_CLKCMU_DPTX_DPOSC		110
#define DOUT_CLKCMU_DPUB_NOC		111
#define DOUT_CLKCMU_DPUB_DSIM		112
#define DOUT_CLKCMU_DPUF0_NOC		113
#define DOUT_CLKCMU_DPUF1_NOC		114
#define DOUT_CLKCMU_DPUF2_NOC		115
#define DOUT_CLKCMU_DSP_NOC		116
#define DOUT_CLKCMU_G3D_SWITCH		117
#define DOUT_CLKCMU_G3D_NOCP		118
#define DOUT_CLKCMU_GNPU_NOC		119
#define DOUT_CLKCMU_HSI0_NOC		120
#define DOUT_CLKCMU_HSI1_NOC		121
#define DOUT_CLKCMU_HSI1_USBDRD		122
#define DOUT_CLKCMU_HSI1_MMC_CARD	123
#define DOUT_CLKCMU_HSI2_NOC		124
#define DOUT_CLKCMU_HSI2_NOC_UFS	125
#define DOUT_CLKCMU_HSI2_UFS_EMBD	126
#define DOUT_CLKCMU_HSI2_ETHERNET	127
#define DOUT_CLKCMU_ISP_NOC		128
#define DOUT_CLKCMU_M2M_NOC		129
#define DOUT_CLKCMU_M2M_JPEG		130
#define DOUT_CLKCMU_MFC_MFC		131
#define DOUT_CLKCMU_MFC_WFD		132
#define DOUT_CLKCMU_MFD_NOC		133
#define DOUT_CLKCMU_MIF_NOCP		134
#define DOUT_CLKCMU_MISC_NOC		135
#define DOUT_CLKCMU_NOCL0_NOC		136
#define DOUT_CLKCMU_NOCL1_NOC		137
#define DOUT_CLKCMU_NOCL2_NOC		138
#define DOUT_CLKCMU_PERIC0_NOC		139
#define DOUT_CLKCMU_PERIC0_IP		140
#define DOUT_CLKCMU_PERIC1_NOC		141
#define DOUT_CLKCMU_PERIC1_IP		142
#define DOUT_CLKCMU_SDMA_NOC		143
#define DOUT_CLKCMU_SNW_NOC		144
#define DOUT_CLKCMU_SSP_NOC		145
#define DOUT_CLKCMU_TAA_NOC		146

/* CMU_PERIC0 */
#define CLK_MOUT_PERIC0_IP_USER		1
#define CLK_MOUT_PERIC0_NOC_USER	2
#define CLK_MOUT_PERIC0_USI00_USI	3
#define CLK_MOUT_PERIC0_USI01_USI	4
#define CLK_MOUT_PERIC0_USI02_USI	5
#define CLK_MOUT_PERIC0_USI03_USI	6
#define CLK_MOUT_PERIC0_USI04_USI	7
#define CLK_MOUT_PERIC0_USI05_USI	8
#define CLK_MOUT_PERIC0_USI06_USI	9
#define CLK_MOUT_PERIC0_USI07_USI	10
#define CLK_MOUT_PERIC0_USI08_USI	11
#define CLK_MOUT_PERIC0_USI_I2C		12
#define CLK_MOUT_PERIC0_I3C		13

#define CLK_DOUT_PERIC0_USI00_USI	14
#define CLK_DOUT_PERIC0_USI01_USI	15
#define CLK_DOUT_PERIC0_USI02_USI	16
#define CLK_DOUT_PERIC0_USI03_USI	17
#define CLK_DOUT_PERIC0_USI04_USI	18
#define CLK_DOUT_PERIC0_USI05_USI	19
#define CLK_DOUT_PERIC0_USI06_USI	20
#define CLK_DOUT_PERIC0_USI07_USI	21
#define CLK_DOUT_PERIC0_USI08_USI	22
#define CLK_DOUT_PERIC0_USI_I2C		23
#define CLK_DOUT_PERIC0_I3C		24

#endif /* _DT_BINDINGS_CLOCK_EXYNOSAUTOV920_H */
