/*	$NetBSD: intel,agilex5-clkmgr.h,v 1.1.1.1 2026/01/18 05:21:31 skrll Exp $	*/

/* SPDX-License-Identifier: GPL-2.0-only OR BSD-2-Clause */
/*
 * Copyright (C) 2023, Intel Corporation
 */

#ifndef __DT_BINDINGS_INTEL_AGILEX5_CLKMGR_H
#define __DT_BINDINGS_INTEL_AGILEX5_CLKMGR_H

/* fixed rate clocks */
#define AGILEX5_OSC1			0
#define AGILEX5_CB_INTOSC_HS_DIV2_CLK	1
#define AGILEX5_CB_INTOSC_LS_CLK	2
#define AGILEX5_F2S_FREE_CLK		3

/* PLL clocks */
#define AGILEX5_MAIN_PLL_CLK		4
#define AGILEX5_MAIN_PLL_C0_CLK		5
#define AGILEX5_MAIN_PLL_C1_CLK		6
#define AGILEX5_MAIN_PLL_C2_CLK		7
#define AGILEX5_MAIN_PLL_C3_CLK		8
#define AGILEX5_PERIPH_PLL_CLK		9
#define AGILEX5_PERIPH_PLL_C0_CLK	10
#define AGILEX5_PERIPH_PLL_C1_CLK	11
#define AGILEX5_PERIPH_PLL_C2_CLK	12
#define AGILEX5_PERIPH_PLL_C3_CLK	13
#define AGILEX5_CORE0_FREE_CLK		14
#define AGILEX5_CORE1_FREE_CLK		15
#define AGILEX5_CORE2_FREE_CLK		16
#define AGILEX5_CORE3_FREE_CLK		17
#define AGILEX5_DSU_FREE_CLK		18
#define AGILEX5_BOOT_CLK		19

/* fixed factor clocks */
#define AGILEX5_L3_MAIN_FREE_CLK	20
#define AGILEX5_NOC_FREE_CLK		21
#define AGILEX5_S2F_USR0_CLK		22
#define AGILEX5_NOC_CLK			23
#define AGILEX5_EMAC_A_FREE_CLK		24
#define AGILEX5_EMAC_B_FREE_CLK		25
#define AGILEX5_EMAC_PTP_FREE_CLK	26
#define AGILEX5_GPIO_DB_FREE_CLK	27
#define AGILEX5_S2F_USER0_FREE_CLK	28
#define AGILEX5_S2F_USER1_FREE_CLK	29
#define AGILEX5_PSI_REF_FREE_CLK	30
#define AGILEX5_USB31_FREE_CLK		31

/* Gate clocks */
#define AGILEX5_CORE0_CLK		32
#define AGILEX5_CORE1_CLK		33
#define AGILEX5_CORE2_CLK		34
#define AGILEX5_CORE3_CLK		35
#define AGILEX5_MPU_CLK			36
#define AGILEX5_MPU_PERIPH_CLK		37
#define AGILEX5_MPU_CCU_CLK		38
#define AGILEX5_L4_MAIN_CLK		39
#define AGILEX5_L4_MP_CLK		40
#define AGILEX5_L4_SYS_FREE_CLK		41
#define AGILEX5_L4_SP_CLK		42
#define AGILEX5_CS_AT_CLK		43
#define AGILEX5_CS_TRACE_CLK		44
#define AGILEX5_CS_PDBG_CLK		45
#define AGILEX5_EMAC1_CLK		47
#define AGILEX5_EMAC2_CLK		48
#define AGILEX5_EMAC_PTP_CLK		49
#define AGILEX5_GPIO_DB_CLK		50
#define AGILEX5_S2F_USER0_CLK		51
#define AGILEX5_S2F_USER1_CLK		52
#define AGILEX5_PSI_REF_CLK		53
#define AGILEX5_USB31_SUSPEND_CLK	54
#define AGILEX5_EMAC0_CLK		46
#define AGILEX5_USB31_BUS_CLK_EARLY	55
#define AGILEX5_USB2OTG_HCLK		56
#define AGILEX5_SPIM_0_CLK		57
#define AGILEX5_SPIM_1_CLK		58
#define AGILEX5_SPIS_0_CLK		59
#define AGILEX5_SPIS_1_CLK		60
#define AGILEX5_DMA_CORE_CLK		61
#define AGILEX5_DMA_HS_CLK		62
#define AGILEX5_I3C_0_CORE_CLK		63
#define AGILEX5_I3C_1_CORE_CLK		64
#define AGILEX5_I2C_0_PCLK		65
#define AGILEX5_I2C_1_PCLK		66
#define AGILEX5_I2C_EMAC0_PCLK		67
#define AGILEX5_I2C_EMAC1_PCLK		68
#define AGILEX5_I2C_EMAC2_PCLK		69
#define AGILEX5_UART_0_PCLK		70
#define AGILEX5_UART_1_PCLK		71
#define AGILEX5_SPTIMER_0_PCLK		72
#define AGILEX5_SPTIMER_1_PCLK		73
#define AGILEX5_DFI_CLK			74
#define AGILEX5_NAND_NF_CLK		75
#define AGILEX5_NAND_BCH_CLK		76
#define AGILEX5_SDMMC_SDPHY_REG_CLK	77
#define AGILEX5_SDMCLK			78
#define AGILEX5_SOFTPHY_REG_PCLK	79
#define AGILEX5_SOFTPHY_PHY_CLK		80
#define AGILEX5_SOFTPHY_CTRL_CLK	81
#define AGILEX5_NUM_CLKS		82

#endif	/* __DT_BINDINGS_INTEL_AGILEX5_CLKMGR_H */
