/*	$NetBSD: htons.c,v 1.4 2026/01/09 08:01:11 skrll Exp $	*/

/*
 * Written by J.T. Conklin <jtc@NetBSD.org>.
 * Public domain.
 */

#include <sys/cdefs.h>
#if defined(LIBC_SCCS) && !defined(lint)
__RCSID("$NetBSD: htons.c,v 1.4 2026/01/09 08:01:11 skrll Exp $");
#endif

#include <sys/types.h>
#include <sys/endian.h>

#undef htons

uint16_t
htons(uint16_t x)
{
#if BYTE_ORDER == LITTLE_ENDIAN
	u_char *s = (void *) &x;
	return (uint16_t)(s[0] << 8 | s[1]);
#else
	return x;
#endif
}
