/*
 * "p" - A very simple Project Manager using the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <Foundation/NSAutoreleasePool.h>
#include <GToolKit/GToolKit.h>
#include "Manager.h"

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    Manager *manager;

    [[[GTKApplication alloc] initWithArgc:&argc argv:&argv] autorelease];
    [GTKApp rcParse:@"p.rc"];

    manager = [[Manager new] autorelease];
    if (argc > 1) [manager loadFromFile:[NSString stringWithCString:argv[1]]];

    [GTKApp run];
    [pool release];
    return 0;
}
