#include <Foundation/NSArray.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSProcessInfo.h>
#include <Foundation/NSUtilities.h>
#include <GToolKit/GToolKit.h>

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    GTKWindow *window;
    GTKLabel *label;
    GTKButton *button;
    GTKVBox *box;

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];

    NSLog([[[NSProcessInfo processInfo] arguments] description]);
    [GTOOLKIT_OBJECT(gtk_button_new()) release];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    [window setBorderWidth:10];

    button = [GTKButton buttonWithLabel:@"Quit"];
    label = [GTKLabel labelWithStr:@"Hello World!"];
    box = [GTKVBox vBoxWithHomogeneous:YES spacing:10];

    [box packStartDefaults:label];
    [box packStartDefaults:button];
    [window add:box];
    [window show];

    [button connectSignal:@"clicked" withTarget:window sel:@selector(destroy)];
    [button grabFocus];

    NSLog([[[box children] objectAtIndex:0] stringValue]);

    [GTKApp run];
    [pool release];
    return 0;
}
