#ifndef GTOOLKIT_GTKEDITABLE_H
#define GTOOLKIT_GTKEDITABLE_H

#include <GToolKit/GTKWidget.h>
#include <gtk/gtkeditable.h>

@interface GTKEditable : GTKWidget
+ (guint) getType;
- (void) selectRegion:(gint) start end:(gint) end;
- (void) insertText:(const NSString *) new_text newTextLength:(gint) new_text_length position:(gint *) position;
- (void) deleteText:(gint) start_pos endPos:(gint) end_pos;
- (NSString *) getChars:(gint) start_pos endPos:(gint) end_pos;
- (void) cutClipboard:(guint32) time;
- (void) copyClipboard:(guint32) time;
- (void) pasteClipboard:(guint32) time;
- (void) claimSelection:(gboolean) claim time:(guint32) time;
- (void) deleteSelection;
- (void) changed;
@end

#endif
