#include <GToolKit/GToolKit.h>
#include <Foundation/NSAutoreleasePool.h>
#include "Calc.h"

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    Calc *calc = [[Calc new] autorelease];
    GTKTable *table;
    GTKWindow *window;
    GTKAcceleratorTable *accel;
    GTKEntry *entry;
    NSString *str[][4] = { { @"1", @"2", @"3", @"+" },
			   { @"4", @"5", @"6", @"-" },
			   { @"7", @"8", @"9", @"*" },
			   { @"C", @"0", @"=", @"/" } };
    GTKButton *button;
    GTKTooltips *tips = [GTKTooltips tooltips];
    GdkColor yellow, black;
    GTKAction *action;
    int i, j;
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];

    accel = [GTKAcceleratorTable acceleratorTable];
    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    [window borderWidth:5];

    entry = [GTKEntry entry];
    [entry setSensitive:NO];

    table = [GTKTable tableWithRows:5 columns:4 homogeneous:NO];
    [table attachDefaults:entry leftAttach:0 rightAttach:4
	   topAttach:0 bottomAttach:1];

    [calc setTarget:entry];

    action = [GTKAction actionWithTarget:calc selector:@selector(gate:)];

    gdk_color_parse("light yellow", &yellow);
    gdk_color_alloc([window getColormap], &yellow);
    gdk_color_parse("black", &black);
    gdk_color_alloc([window getColormap], &black);
    [tips setColors:&yellow foreground:&black];

    for (i = 0; i < 4; ++i)
	for (j = 0; j < 4; ++j)
	{
	    int tag = [str[i][j] characterAtIndex:0];

	    button = [GTKButton buttonWithLabel:str[i][j]];
	    [button setTag:tag];
	    [button connectSignal:@"clicked" withAction:action];
	    [button installAccelerator:accel signalName:@"clicked"
		    key:tag modifiers:0];
	    [table attachDefaults:button leftAttach:j rightAttach:j + 1
		   topAttach:i + 1 bottomAttach:i + 2];
	    [tips setTip:button tipText:str[i][j] tipPrivate:nil];
	}

    [window add:table];
    [window addAcceleratorTable:accel];
    [table setColSpacings:5];
    [table setRowSpacings:5];
    [window setUsize:200 height:200];
    [window show];

    [window connectSignal:@"destroy" withAction:
	    [GTKAction actionWithTarget:GTKApp selector:@selector(terminate:)]];

    [GTKApp run];
    [pool release];
    return 0;
}
