#-
# Copyright 2016 Michal Meloun <mmel@FreeBSD.org>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

INTERFACE phynode;

HEADER {
	#include <dev/extres/phy/phy.h>

	struct phynode;
}

#
# Init/deinit phy
# Returns 0 on success or a standard errno value.
#
METHOD int init {
	struct phynode	*phynode;
};

#
# Enable/disable phy
# Returns 0 on success or a standard errno value.
#
METHOD int enable {
	struct phynode	*phynode;
	bool		enable;
};

#
# Get phy status
# Returns 0 on success or a standard errno value.
#
METHOD int status {
	struct phynode	*phynode;
	int		*status;    /* PHY_STATUS_* */
};


#
# Set mode/submode for multiprotocol phy
# Returns 0 on success or a standard errno value.
#
METHOD int set_mode  {
	struct phynode	*phynode;
	phy_mode_t	mode;
	phy_submode_t	submode;
};
