#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_BRAINPOOLP224T1

#ifndef __EC_PARAMS_BRAINPOOLP224T1_H__
#define __EC_PARAMS_BRAINPOOLP224T1_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 brainpoolp224t1_p[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87,
	0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5,
	0x7e, 0xc8, 0xc0, 0xff,
};

TO_EC_STR_PARAM(brainpoolp224t1_p);

#define CURVE_BRAINPOOLP224T1_P_BITLEN 224
static const u8 brainpoolp224t1_p_bitlen[] = {
	0xe0,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 brainpoolp224t1_r[] = {
	0x79, 0x36, 0x06, 0x11, 0x1c, 0x3f, 0xb2, 0x44,
	0x7b, 0x57, 0x6c, 0xf5, 0xa8, 0xe8, 0x42, 0x8f,
	0x5c, 0xbf, 0x03, 0x89, 0xd6, 0x82, 0x78, 0x5e,
	0x20, 0xb5, 0x62, 0xf7,
};

TO_EC_STR_PARAM(brainpoolp224t1_r);

static const u8 brainpoolp224t1_r_square[] = {
	0x2b, 0x3d, 0x40, 0xdd, 0x7e, 0xa5, 0x57, 0x7c,
	0x77, 0xe3, 0xd7, 0xe4, 0x76, 0xf9, 0xee, 0x46,
	0xf6, 0x91, 0xd1, 0x05, 0x3b, 0xfb, 0xc9, 0xbf,
	0x6b, 0x3d, 0x58, 0xff,
};

TO_EC_STR_PARAM(brainpoolp224t1_r_square);

static const u8 brainpoolp224t1_mpinv[] = {
	0xe2, 0x4d, 0x21, 0x6a, 0xe1, 0x49, 0xc1, 0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_mpinv);

static const u8 brainpoolp224t1_p_shift[] = {
	0x20,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_shift);

static const u8 brainpoolp224t1_p_normalized[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87,
	0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5,
	0x7e, 0xc8, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_normalized);

static const u8 brainpoolp224t1_p_reciprocal[] = {
	0x2f, 0xc0, 0x99, 0xf7, 0x8f, 0xd2, 0x22, 0x99,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 brainpoolp224t1_r[] = {
	0x28, 0x3e, 0xcb, 0x55, 0xd9, 0xbc, 0x99, 0x79,
	0xd5, 0xe7, 0xcf, 0xda, 0x8a, 0x2e, 0x28, 0x78,
	0x4f, 0x60, 0xf8, 0xa8, 0x68, 0x25, 0x76, 0x0a,
	0x81, 0x37, 0x3f, 0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_r);

static const u8 brainpoolp224t1_r_square[] = {
	0x05, 0x78, 0xfd, 0x59, 0x2e, 0x6a, 0x6c, 0xe4,
	0x3f, 0xe8, 0xa2, 0xaa, 0x96, 0xaf, 0x77, 0x4c,
	0x43, 0xc2, 0x0e, 0x72, 0x78, 0x67, 0xca, 0x80,
	0x64, 0xdc, 0xd0, 0x4f,
};

TO_EC_STR_PARAM(brainpoolp224t1_r_square);

static const u8 brainpoolp224t1_mpinv[] = {
	0xe1, 0x49, 0xc1, 0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_mpinv);

static const u8 brainpoolp224t1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_shift);

static const u8 brainpoolp224t1_p_normalized[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87,
	0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5,
	0x7e, 0xc8, 0xc0, 0xff,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_normalized);

static const u8 brainpoolp224t1_p_reciprocal[] = {
	0x2f, 0xc0, 0x99, 0xf7,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 brainpoolp224t1_r[] = {
	0x28, 0x3e, 0xcb, 0x55, 0xd9, 0xbc, 0x99, 0x79,
	0xd5, 0xe7, 0xcf, 0xda, 0x8a, 0x2e, 0x28, 0x78,
	0x4f, 0x60, 0xf8, 0xa8, 0x68, 0x25, 0x76, 0x0a,
	0x81, 0x37, 0x3f, 0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_r);

static const u8 brainpoolp224t1_r_square[] = {
	0x05, 0x78, 0xfd, 0x59, 0x2e, 0x6a, 0x6c, 0xe4,
	0x3f, 0xe8, 0xa2, 0xaa, 0x96, 0xaf, 0x77, 0x4c,
	0x43, 0xc2, 0x0e, 0x72, 0x78, 0x67, 0xca, 0x80,
	0x64, 0xdc, 0xd0, 0x4f,
};

TO_EC_STR_PARAM(brainpoolp224t1_r_square);

static const u8 brainpoolp224t1_mpinv[] = {
	0xc1, 0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_mpinv);

static const u8 brainpoolp224t1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_shift);

static const u8 brainpoolp224t1_p_normalized[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87,
	0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5,
	0x7e, 0xc8, 0xc0, 0xff,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_normalized);

static const u8 brainpoolp224t1_p_reciprocal[] = {
	0x2f, 0xc0,
};

TO_EC_STR_PARAM(brainpoolp224t1_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 brainpoolp224t1_a[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87,
	0xb0, 0x9f, 0x07, 0x57, 0x97, 0xda, 0x89, 0xf5,
	0x7e, 0xc8, 0xc0, 0xfc,
};

TO_EC_STR_PARAM(brainpoolp224t1_a);

static const u8 brainpoolp224t1_b[] = {
	0x4b, 0x33, 0x7d, 0x93, 0x41, 0x04, 0xcd, 0x7b,
	0xef, 0x27, 0x1b, 0xf6, 0x0c, 0xed, 0x1e, 0xd2,
	0x0d, 0xa1, 0x4c, 0x08, 0xb3, 0xbb, 0x64, 0xf1,
	0x8a, 0x60, 0x88, 0x8d,
};

TO_EC_STR_PARAM(brainpoolp224t1_b);

#define CURVE_BRAINPOOLP224T1_CURVE_ORDER_BITLEN 224
static const u8 brainpoolp224t1_curve_order[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98,
	0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3,
	0xa5, 0xa7, 0x93, 0x9f,
};

TO_EC_STR_PARAM(brainpoolp224t1_curve_order);

static const u8 brainpoolp224t1_gx[] = {
	0x6a, 0xb1, 0xe3, 0x44, 0xce, 0x25, 0xff, 0x38,
	0x96, 0x42, 0x4e, 0x7f, 0xfe, 0x14, 0x76, 0x2e,
	0xcb, 0x49, 0xf8, 0x92, 0x8a, 0xc0, 0xc7, 0x60,
	0x29, 0xb4, 0xd5, 0x80,
};

TO_EC_STR_PARAM(brainpoolp224t1_gx);

static const u8 brainpoolp224t1_gy[] = {
	0x03, 0x74, 0xe9, 0xf5, 0x14, 0x3e, 0x56, 0x8c,
	0xd2, 0x3f, 0x3f, 0x4d, 0x7c, 0x0d, 0x4b, 0x1e,
	0x41, 0xc8, 0xcc, 0x0d, 0x1c, 0x6a, 0xbd, 0x5f,
	0x1a, 0x46, 0xdb, 0x4c,
};

TO_EC_STR_PARAM(brainpoolp224t1_gy);

static const u8 brainpoolp224t1_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_gz);

static const u8 brainpoolp224t1_gen_order[] = {
	0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86,
	0x2a, 0x18, 0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98,
	0xd1, 0x16, 0xbc, 0x4b, 0x6d, 0xde, 0xbc, 0xa3,
	0xa5, 0xa7, 0x93, 0x9f,
};

TO_EC_STR_PARAM(brainpoolp224t1_gen_order);

#define CURVE_BRAINPOOLP224T1_Q_BITLEN 224
static const u8 brainpoolp224t1_gen_order_bitlen[] = {
	0xe0,
};

TO_EC_STR_PARAM(brainpoolp224t1_gen_order_bitlen);

static const u8 brainpoolp224t1_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(brainpoolp224t1_cofactor);

static const u8 brainpoolp224t1_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp224t1_alpha_montgomery, 0);

static const u8 brainpoolp224t1_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp224t1_gamma_montgomery, 0);

static const u8 brainpoolp224t1_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp224t1_alpha_edwards, 0);

static const u8 brainpoolp224t1_name[] = "BRAINPOOLP224T1";
TO_EC_STR_PARAM(brainpoolp224t1_name);

static const u8 brainpoolp224t1_oid[] = "1.3.36.3.3.2.8.1.1.6";
TO_EC_STR_PARAM(brainpoolp224t1_oid);

static const ec_str_params brainpoolp224t1_str_params = {
	.p = &brainpoolp224t1_p_str_param,
	.p_bitlen = &brainpoolp224t1_p_bitlen_str_param,
	.r = &brainpoolp224t1_r_str_param,
	.r_square = &brainpoolp224t1_r_square_str_param,
	.mpinv = &brainpoolp224t1_mpinv_str_param,
	.p_shift = &brainpoolp224t1_p_shift_str_param,
	.p_normalized = &brainpoolp224t1_p_normalized_str_param,
	.p_reciprocal = &brainpoolp224t1_p_reciprocal_str_param,
	.a = &brainpoolp224t1_a_str_param,
	.b = &brainpoolp224t1_b_str_param,
	.curve_order = &brainpoolp224t1_curve_order_str_param,
	.gx = &brainpoolp224t1_gx_str_param,
	.gy = &brainpoolp224t1_gy_str_param,
	.gz = &brainpoolp224t1_gz_str_param,
	.gen_order = &brainpoolp224t1_gen_order_str_param,
	.gen_order_bitlen = &brainpoolp224t1_gen_order_bitlen_str_param,
	.cofactor = &brainpoolp224t1_cofactor_str_param,
	.alpha_montgomery = &brainpoolp224t1_alpha_montgomery_str_param,
	.gamma_montgomery = &brainpoolp224t1_gamma_montgomery_str_param,
	.alpha_edwards = &brainpoolp224t1_alpha_edwards_str_param,
	.oid = &brainpoolp224t1_oid_str_param,
	.name = &brainpoolp224t1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_BRAINPOOLP224T1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_BRAINPOOLP224T1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_BRAINPOOLP224T1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_BRAINPOOLP224T1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_BRAINPOOLP224T1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_BRAINPOOLP224T1_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 1)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 1
#endif
#if (MAX_CURVE_NAME_LEN < 29)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 29
#endif

#endif /* __EC_PARAMS_BRAINPOOLP224T1_H__ */

#endif /* WITH_CURVE_BRAINPOOLP224T1 */
